/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer.simple;

import java.io.PrintStream;
import java.io.PrintWriter;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Unquote;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.Typer;
import org.mirah.typer.simple.PrintStreamAdapter;

public class TypePrinter
extends NodeScanner {
    private int indent = 0;
    private Object[] args;
    private Typer typer;
    private PrintWriter out;

    public TypePrinter(Typer typer) {
        this(typer, System.out);
    }

    public TypePrinter(Typer typer, PrintWriter writer) {
        this.typer = typer;
        this.args = new Object[1];
        this.args[0] = "";
        this.out = writer;
    }

    public TypePrinter(Typer typer, PrintStream writer) {
        this(typer, new PrintWriter(new PrintStreamAdapter(writer)));
    }

    public void printIndent() {
        block0: {
            if (this.indent <= 0) break block0;
            this.out.printf("%" + this.indent + "s", this.args);
        }
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        this.printIndent();
        this.out.print(node);
        TypeFuture type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print(": " + type.resolve());
        }
        this.out.println();
        this.indent += 2;
        return true;
    }

    @Override
    public boolean enterUnquote(Unquote node, Object arg) {
        super.enterUnquote(node, arg);
        if (node.object() != null) {
            if (node.object() instanceof Node) {
                ((Node)node.object()).accept(this, arg);
            } else {
                this.printIndent();
                this.out.print(node.object());
                this.out.println();
            }
        }
        return node.object() == null;
    }

    @Override
    public Object exitDefault(Node node, Object arg) {
        this.indent -= 2;
        return null;
    }
}

