/*
 * Decompiled with CFR 0.152.
 */
package cc.altius.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static String IST = "Asia/Calcutta";
    public static String GMT = "Europe/London";
    public static String EST = "US/Eastern";
    public static String CST = "US/Central";
    public static String MST = "US/Mountain";
    public static String PST = "US/Pacific";
    public static String UTC = "Etc/UTC";
    public static String GST = "Asia/Dubai";
    public static String YMD = "yyyy-MM-dd";
    public static String DMY = "dd-MM-yyyy";
    public static String DMMY = "dd-MMM-yyyy";
    public static String MMY = "MMM-yyyy";
    public static String MMMMDY = "MMMMM dd, yyyy";
    public static String YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static String YMDHM = "yyyy-MM-dd HH:mm";
    public static String DMYHMS = "dd-MM-yyyy HH:mm:ss";
    public static String DMYHM = "dd-MM-yyyy HH:mm";
    public static String Y = "yyyy";
    public static String[] dayName = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    public static String[] monthName = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public static String getCurrentDateString(String timeZone, String format) {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone(timeZone));
        return df.format(now);
    }

    public static Date getCurrentDateObject(String timeZone) {
        String format = YMDHMS;
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date tmpDate = null;
        try {
            tmpDate = df.parse(DateUtils.getCurrentDateString(timeZone, format));
        }
        catch (ParseException pe) {
            tmpDate = new Date();
        }
        return tmpDate;
    }

    public static String getOffsetFromCurrentDateString(String timeZone, String format, int days) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone(timeZone));
        return df.format(DateUtils.getOffsetFromCurrentDateObject(timeZone, days));
    }

    public static Date getOffsetFromCurrentDateObject(String timeZone, int days) {
        Date now = DateUtils.getCurrentDateObject(timeZone);
        Calendar c1 = Calendar.getInstance();
        c1.setTime(now);
        c1.add(5, days);
        return c1.getTime();
    }

    public static Date addDays(Date dt, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date addMonths(Date dt, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.add(2, months);
        return cal.getTime();
    }

    public static String formatDate(Date dt, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(dt);
    }

    public static int compareDate(Date d1, Date d2) {
        if (d1.after(d2)) {
            return 1;
        }
        if (d2.after(d1)) {
            return -1;
        }
        return 0;
    }

    public static int compareDates(String d1, String d2) {
        boolean compareTime;
        Calendar startDt = Calendar.getInstance();
        Calendar stopDt = Calendar.getInstance();
        String time1 = "";
        String time2 = "";
        if (d1.length() <= 10 || d2.length() <= 10) {
            startDt.set(Integer.parseInt(d1.substring(0, 4)), Integer.parseInt(d1.substring(5, 7)) - 1, Integer.parseInt(d1.substring(8, 10)));
            stopDt.set(Integer.parseInt(d2.substring(0, 4)), Integer.parseInt(d2.substring(5, 7)) - 1, Integer.parseInt(d2.substring(8, 10)));
            compareTime = false;
        } else {
            startDt.set(Integer.parseInt(d1.substring(0, 4)), Integer.parseInt(d1.substring(5, 7)) - 1, Integer.parseInt(d1.substring(8, 10)), Integer.parseInt(d1.substring(11, 13)), Integer.parseInt(d1.substring(14, 16)), Integer.parseInt(d1.substring(17, 19)));
            stopDt.set(Integer.parseInt(d2.substring(0, 4)), Integer.parseInt(d2.substring(5, 7)) - 1, Integer.parseInt(d2.substring(8, 10)), Integer.parseInt(d2.substring(11, 13)), Integer.parseInt(d2.substring(14, 16)), Integer.parseInt(d2.substring(17, 19)));
            compareTime = true;
            time1 = d1.substring(11, 19);
            time2 = d2.substring(11, 19);
        }
        int year1 = startDt.get(1);
        int month1 = startDt.get(2);
        int date1 = startDt.get(5);
        int year2 = stopDt.get(1);
        int month2 = stopDt.get(2);
        int date2 = stopDt.get(5);
        if (year1 == year2 && month1 == month2 && date1 == date2) {
            if (compareTime) {
                return DateUtils.compareTime(time1, time2);
            }
            return 0;
        }
        if (year1 < year2 || year1 == year2 && month1 < month2 || year1 == year2 && month1 == month2 && date1 < date2) {
            return -1;
        }
        return 1;
    }

    private static int compareTime(String t1, String t2) {
        int hour1 = Integer.parseInt(t1.substring(0, 2));
        int min1 = Integer.parseInt(t1.substring(3, 5));
        int sec1 = Integer.parseInt(t1.substring(6, 8));
        int hour2 = Integer.parseInt(t2.substring(0, 2));
        int min2 = Integer.parseInt(t2.substring(3, 5));
        int sec2 = Integer.parseInt(t2.substring(6, 8));
        if (hour1 < hour2) {
            return -1;
        }
        if (hour1 > hour2) {
            return 1;
        }
        if (min1 < min2) {
            return -1;
        }
        if (min1 > min2) {
            return 1;
        }
        if (sec1 < sec2) {
            return -1;
        }
        if (sec1 > sec2) {
            return 1;
        }
        return 0;
    }

    public static Date getDateFromString(String date, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.parse(date);
    }

    @Deprecated
    public static Date convertStringToDate(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    @Deprecated
    public static String convertDateToString(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static Date getStartOfMonthObject() {
        return DateUtils.getStartOfMonthVariable(new Date());
    }

    public static String getStartOfMonthString(String format) {
        Date d = DateUtils.getStartOfMonthObject();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(d);
    }

    public static Date getEndOfMonthObject() {
        return DateUtils.getEndOfMonthVariable(new Date());
    }

    public static String getEndOfMonthString(String format) {
        Date d = DateUtils.getEndOfMonthObject();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(d);
    }

    public static Date getStartOfPreviousMonthObject() {
        Date now = new Date();
        Calendar c1 = Calendar.getInstance();
        c1.setTime(now);
        c1.add(2, -1);
        c1.set(5, 1);
        c1.set(11, 0);
        c1.set(12, 0);
        c1.set(13, 0);
        return c1.getTime();
    }

    public static String getStartOfPreviousMonthString(String format) {
        Date d = DateUtils.getStartOfPreviousMonthObject();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(d);
    }

    public static Date getEndOfPreviousMonthObject() {
        Date now = new Date();
        Calendar c1 = Calendar.getInstance();
        c1.setTime(now);
        c1.set(5, 1);
        c1.add(5, -1);
        c1.set(11, 23);
        c1.set(12, 59);
        c1.set(13, 59);
        return c1.getTime();
    }

    public static String getEndOfPreviousMonthString(String format) {
        Date d = DateUtils.getEndOfPreviousMonthObject();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(d);
    }

    public static int getDaysBetween(Date d1, Date d2) {
        if (d1.getTime() > d2.getTime()) {
            return (int)((d1.getTime() - d2.getTime()) / 86400000L);
        }
        return (int)((d2.getTime() - d1.getTime()) / 86400000L);
    }

    public static Date getStartOfMonthVariable(Date d) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d);
        c1.set(5, 1);
        c1.set(11, 0);
        c1.set(12, 0);
        c1.set(13, 0);
        return c1.getTime();
    }

    public static Date getEndOfMonthVariable(Date d) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d);
        c1.add(2, 1);
        c1.set(5, 1);
        c1.add(5, -1);
        c1.set(11, 23);
        c1.set(12, 59);
        c1.set(13, 59);
        return c1.getTime();
    }

    public static String getStartOfMonthVariable(String dStr) throws ParseException {
        Calendar c1 = Calendar.getInstance();
        Date d = DateUtils.getDateFromString(dStr, YMD);
        c1.setTime(d);
        c1.set(5, 1);
        c1.set(11, 0);
        c1.set(12, 0);
        c1.set(13, 0);
        return new SimpleDateFormat(YMD).format(c1.getTime());
    }

    public static String getEndOfMonthVariable(String dStr) throws ParseException {
        Calendar c1 = Calendar.getInstance();
        Date d = DateUtils.getDateFromString(dStr, YMD);
        c1.setTime(d);
        c1.add(2, 1);
        c1.set(5, 1);
        c1.add(5, -1);
        c1.set(11, 23);
        c1.set(12, 59);
        c1.set(13, 59);
        return new SimpleDateFormat(YMD).format(c1.getTime());
    }

    public static String getVersion() {
        return "1.32";
    }
}

