/*
 * Decompiled with CFR 0.152.
 */
package cc.altius.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPUtils {
    private final long startIP;
    private final long stopIP;

    public IPUtils(String ipRange) {
        if (ipRange.indexOf("-") > 0) {
            String[] ips = ipRange.split("-");
            this.startIP = this.ipToLong(ips[0]);
            this.stopIP = this.ipToLong(ips[1]);
        } else {
            this.startIP = this.ipToLong(ipRange);
            this.stopIP = 0L;
        }
    }

    private long ipToLong(String ip) {
        try {
            InetAddress inet = InetAddress.getByName(ip);
            byte[] octets = inet.getAddress();
            long result = 0L;
            for (byte octet : octets) {
                result <<= 8;
                result |= (long)(octet & 0xFF);
            }
            return result;
        }
        catch (UnknownHostException u) {
            return 0L;
        }
    }

    public boolean checkIP(String ip) {
        long ipToTest = this.ipToLong(ip);
        if (this.stopIP == 0L) {
            return ipToTest == this.startIP;
        }
        return ipToTest >= this.startIP && ipToTest <= this.stopIP;
    }
}

