/*
 * Decompiled with CFR 0.152.
 */
package cc.altius.utils.POI;

import cc.altius.utils.POI.POICell;
import cc.altius.utils.POI.POIParameter;
import cc.altius.utils.POI.POIRow;
import cc.altius.utils.POI.POIWorkBookSheet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class POIWorkBook
implements Serializable {
    private OutputStream out;
    private SXSSFWorkbook workbook;
    private ArrayList<POIWorkBookSheet> workSheets;
    private CreationHelper createHelper;
    private Font headerFont;
    private Font bodyFont;
    private Font titleFont;
    private CellStyle styleTitle;
    private CellStyle styleHeader;
    private CellStyle styleBody;
    private CellStyle styleBodyDate;
    private CellStyle styleBodyDateTime;
    private CellStyle styleBodyDecimal;
    private CellStyle styleBodyPercentage;
    private CellStyle styleBodyInteger;
    private static final String IntegerFormat = "#0";
    private static final String DecimalFormat = "#0.00";
    private static final String PercFormat = "#0.0%";
    private String DateFormat = "dd/mm/yyyy";
    private String DateTimeFormat = "dd/mm/yyyy hh:mm:ss";

    public void setDateFormat(String DateFormat) {
        this.DateFormat = DateFormat;
        this.styleBodyDateTime.setDataFormat(this.createHelper.createDataFormat().getFormat(this.DateFormat));
    }

    public void setDateTimeFormat(String DateTimeFormat) {
        this.DateTimeFormat = DateTimeFormat;
        this.styleBodyDateTime.setDataFormat(this.createHelper.createDataFormat().getFormat(this.DateTimeFormat));
    }

    private void initializeWorkBook() {
        this.workbook = new SXSSFWorkbook();
        this.createHelper = this.workbook.getCreationHelper();
        this.headerFont = this.workbook.createFont();
        this.headerFont.setFontName("Arial");
        this.headerFont.setFontHeightInPoints((short)10);
        this.headerFont.setBold(true);
        this.headerFont.setColor((short)9);
        this.bodyFont = this.workbook.createFont();
        this.bodyFont.setFontName("Arial");
        this.bodyFont.setFontHeightInPoints((short)10);
        this.titleFont = this.workbook.createFont();
        this.titleFont.setFontName("Arial");
        this.titleFont.setFontHeightInPoints((short)14);
        this.styleTitle = this.workbook.createCellStyle();
        this.styleTitle.setFont(this.titleFont);
        this.styleHeader = this.workbook.createCellStyle();
        this.styleHeader.setBorderBottom(BorderStyle.THIN);
        this.styleHeader.setBorderTop(BorderStyle.THIN);
        this.styleHeader.setBorderLeft(BorderStyle.THIN);
        this.styleHeader.setBorderRight(BorderStyle.THIN);
        this.styleHeader.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.styleHeader.setFillBackgroundColor(IndexedColors.AQUA.getIndex());
        this.styleHeader.setWrapText(true);
        this.styleHeader.setFont(this.headerFont);
        this.styleBody = this.workbook.createCellStyle();
        this.styleBody.setBorderBottom(BorderStyle.THIN);
        this.styleBody.setBorderTop(BorderStyle.THIN);
        this.styleBody.setBorderLeft(BorderStyle.THIN);
        this.styleBody.setBorderRight(BorderStyle.THIN);
        this.styleBody.setWrapText(true);
        this.styleBody.setFont(this.bodyFont);
        this.styleBodyDate = this.workbook.createCellStyle();
        this.styleBodyDate.setBorderBottom(BorderStyle.THIN);
        this.styleBodyDate.setBorderTop(BorderStyle.THIN);
        this.styleBodyDate.setBorderLeft(BorderStyle.THIN);
        this.styleBodyDate.setBorderRight(BorderStyle.THIN);
        this.styleBodyDate.setWrapText(true);
        this.styleBodyDate.setFont(this.bodyFont);
        this.styleBodyDate.setDataFormat(this.createHelper.createDataFormat().getFormat(this.DateFormat));
        this.styleBodyDateTime = this.workbook.createCellStyle();
        this.styleBodyDateTime.setBorderBottom(BorderStyle.THIN);
        this.styleBodyDateTime.setBorderTop(BorderStyle.THIN);
        this.styleBodyDateTime.setBorderLeft(BorderStyle.THIN);
        this.styleBodyDateTime.setBorderRight(BorderStyle.THIN);
        this.styleBodyDateTime.setWrapText(true);
        this.styleBodyDateTime.setFont(this.bodyFont);
        this.styleBodyDateTime.setDataFormat(this.createHelper.createDataFormat().getFormat(this.DateTimeFormat));
        this.styleBodyDecimal = this.workbook.createCellStyle();
        this.styleBodyDecimal.setBorderBottom(BorderStyle.THIN);
        this.styleBodyDecimal.setBorderTop(BorderStyle.THIN);
        this.styleBodyDecimal.setBorderLeft(BorderStyle.THIN);
        this.styleBodyDecimal.setBorderRight(BorderStyle.THIN);
        this.styleBodyDecimal.setWrapText(true);
        this.styleBodyDecimal.setFont(this.bodyFont);
        this.styleBodyDecimal.setDataFormat(this.createHelper.createDataFormat().getFormat(DecimalFormat));
        this.styleBodyPercentage = this.workbook.createCellStyle();
        this.styleBodyPercentage.setBorderBottom(BorderStyle.THIN);
        this.styleBodyPercentage.setBorderTop(BorderStyle.THIN);
        this.styleBodyPercentage.setBorderLeft(BorderStyle.THIN);
        this.styleBodyPercentage.setBorderRight(BorderStyle.THIN);
        this.styleBodyPercentage.setWrapText(true);
        this.styleBodyPercentage.setFont(this.bodyFont);
        this.styleBodyPercentage.setDataFormat(this.createHelper.createDataFormat().getFormat(PercFormat));
        this.styleBodyInteger = this.workbook.createCellStyle();
        this.styleBodyInteger.setBorderBottom(BorderStyle.THIN);
        this.styleBodyInteger.setBorderTop(BorderStyle.THIN);
        this.styleBodyInteger.setBorderLeft(BorderStyle.THIN);
        this.styleBodyInteger.setBorderRight(BorderStyle.THIN);
        this.styleBodyInteger.setWrapText(true);
        this.styleBodyInteger.setFont(this.bodyFont);
        this.styleBodyInteger.setDataFormat(this.createHelper.createDataFormat().getFormat(IntegerFormat));
    }

    public POIWorkBook(OutputStream out) {
        this.out = out;
        this.workSheets = new ArrayList();
        this.initializeWorkBook();
    }

    public POIWorkBookSheet addWorkSheet(String sheetName) {
        POIWorkBookSheet w = new POIWorkBookSheet(sheetName);
        this.workSheets.add(w);
        return w;
    }

    public POIWorkBookSheet addWorkSheet() {
        POIWorkBookSheet w = new POIWorkBookSheet();
        this.workSheets.add(w);
        return w;
    }

    public void writeWorkBook() throws IOException {
        SXSSFSheet sheet = null;
        for (POIWorkBookSheet ws : this.workSheets) {
            if (ws.getRows().size() > 0x100000) {
                throw new IOException();
            }
            sheet = ws.getSheetName() == null ? this.workbook.createSheet() : this.workbook.createSheet(ws.getSheetName());
            int rownum = 0;
            int cellnum = 0;
            Row row = null;
            Cell cell = null;
            if (ws.isPrintTitle()) {
                row = sheet.createRow(rownum++);
                cell = row.createCell(cellnum++);
                cell.setCellStyle(this.styleTitle);
                cell.setCellValue(ws.getTitle());
                ++rownum;
                for (POIParameter p : ws.getParameters()) {
                    cellnum = 0;
                    row = sheet.createRow(rownum++);
                    cell = row.createCell(cellnum++);
                    cell.setCellStyle(this.styleBody);
                    cell.setCellValue(p.getLabel());
                    cell = row.createCell(cellnum++);
                    this.setStyleValue(cell, p.getValueType(), p.getValue());
                }
            }
            if (ws.getParameters().size() > 0) {
                ++rownum;
            }
            for (POIRow r : ws.getRows()) {
                cellnum = 0;
                row = sheet.createRow(rownum++);
                for (POICell c : r.getCells()) {
                    if (r.getRowType() == 1) {
                        cell = row.createCell(cellnum++);
                        cell.setCellStyle(this.styleHeader);
                        cell.setCellValue((String)c.getValue());
                        continue;
                    }
                    cell = row.createCell(cellnum++);
                    this.setStyleValue(cell, c.getCellType(), c.getValue());
                }
            }
        }
        try {
            this.workbook.write(this.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CellStyle getCellStyle(short valueType) {
        switch (valueType) {
            case 0: {
                return this.styleBody;
            }
            case 1: {
                return this.styleBody;
            }
            case 2: {
                return this.styleBodyDecimal;
            }
            case 3: {
                return this.styleBodyDecimal;
            }
            case 4: {
                return this.styleBodyDate;
            }
            case 5: {
                return this.styleBodyDate;
            }
            case 6: {
                return this.styleBodyInteger;
            }
        }
        return this.styleBody;
    }

    private void setStyleValue(Cell cell, short cellType, Object cellValue) {
        switch (cellType) {
            case 0: {
                cell.setCellStyle(this.styleBody);
                if (cellValue == null) break;
                cell.setCellValue(cellValue.toString());
                break;
            }
            case 1: {
                cell.setCellStyle(this.styleBody);
                if (cellValue == null) break;
                cell.setCellValue(cellValue.toString());
                break;
            }
            case 2: {
                cell.setCellStyle(this.styleBodyDecimal);
                if (cellValue == null) break;
                if (cellValue instanceof Double) {
                    cell.setCellValue(((Double)cellValue).doubleValue());
                    break;
                }
                try {
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                cell.setCellStyle(this.styleBodyPercentage);
                if (cellValue == null) break;
                if (cellValue instanceof Double) {
                    cell.setCellValue(((Double)cellValue).doubleValue());
                    break;
                }
                try {
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                cell.setCellStyle(this.styleBodyDate);
                if (cellValue == null) break;
                cell.setCellValue((Date)cellValue);
                break;
            }
            case 5: {
                cell.setCellStyle(this.styleBodyDateTime);
                if (cellValue == null) break;
                cell.setCellValue((Date)cellValue);
                break;
            }
            case 6: {
                cell.setCellStyle(this.styleBodyInteger);
                if (cellValue == null) break;
                if (cellValue instanceof Double) {
                    cell.setCellValue(((Double)cellValue).doubleValue());
                    break;
                }
                try {
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                cell.setCellStyle(this.styleBody);
                if (cellValue == null) break;
                cell.setCellValue(cellValue.toString());
            }
        }
    }
}

