/*
 * Decompiled with CFR 0.152.
 */
package cc.altius.utils.POI;

import cc.altius.utils.POI.POICell;
import cc.altius.utils.POI.POIParameter;
import cc.altius.utils.POI.POIRow;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class POIWorkSheet
implements Serializable {
    private OutputStream out;
    private String title;
    private String sheetName;
    private boolean autoSizeColumns;
    private ArrayList<POIParameter> parameters;
    private ArrayList<POIRow> rows;
    boolean printTitle;
    private SXSSFWorkbook workbook;
    private CreationHelper createHelper;
    private Font headerFont;
    private Font bodyFont;
    private Font titleFont;
    private CellStyle styleTitle;
    private CellStyle styleHeader;
    private CellStyle styleBody;
    private CellStyle styleBodyDate;
    private CellStyle styleBodyDateTime;
    private CellStyle styleBodyTime;
    private CellStyle styleBodyDecimal;
    private CellStyle styleBodyPercentage;
    private CellStyle styleBodyInteger;
    private static final String IntegerFormat = "#,##0";
    private static final String DecimalFormat = "#,##0.00";
    private static final String PercFormat = "#0.0%";
    private String DateFormat = "dd/MM/yyyy";
    private String DateTimeFormat = "dd/MM/yyyy HH:mm:ss";
    private String TimeFormat = "HH:mm";

    public void setDateFormat(String DateFormat) {
        this.DateFormat = DateFormat;
        this.styleBodyDateTime.setDataFormat(this.createHelper.createDataFormat().getFormat(this.DateFormat));
    }

    public void setDateTimeFormat(String DateTimeFormat) {
        this.DateTimeFormat = DateTimeFormat;
        this.styleBodyDateTime.setDataFormat(this.createHelper.createDataFormat().getFormat(this.DateTimeFormat));
    }

    private void initializeWorkSheet() {
        this.workbook = new SXSSFWorkbook();
        this.createHelper = this.workbook.getCreationHelper();
        this.headerFont = this.workbook.createFont();
        this.headerFont.setFontName("Arial");
        this.headerFont.setFontHeightInPoints((short)10);
        this.headerFont.setBold(true);
        this.headerFont.setColor((short)9);
        this.bodyFont = this.workbook.createFont();
        this.bodyFont.setFontName("Arial");
        this.bodyFont.setFontHeightInPoints((short)10);
        this.titleFont = this.workbook.createFont();
        this.titleFont.setFontName("Arial");
        this.titleFont.setFontHeightInPoints((short)14);
        this.styleTitle = this.workbook.createCellStyle();
        this.styleTitle.setFont(this.titleFont);
        this.styleHeader = this.workbook.createCellStyle();
        this.styleHeader.setBorderBottom(BorderStyle.THIN);
        this.styleHeader.setBorderTop(BorderStyle.THIN);
        this.styleHeader.setBorderLeft(BorderStyle.THIN);
        this.styleHeader.setBorderRight(BorderStyle.THIN);
        this.styleHeader.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.styleHeader.setFillBackgroundColor(IndexedColors.AQUA.getIndex());
        this.styleHeader.setWrapText(true);
        this.styleHeader.setFont(this.headerFont);
        this.styleBody = this.workbook.createCellStyle();
        this.styleBody.setBorderBottom(BorderStyle.THIN);
        this.styleBody.setBorderTop(BorderStyle.THIN);
        this.styleBody.setBorderLeft(BorderStyle.THIN);
        this.styleBody.setBorderRight(BorderStyle.THIN);
        this.styleBody.setWrapText(true);
        this.styleBody.setFont(this.bodyFont);
        this.styleBodyDate = this.workbook.createCellStyle();
        this.styleBodyDate.setBorderBottom(BorderStyle.THIN);
        this.styleBodyDate.setBorderTop(BorderStyle.THIN);
        this.styleBodyDate.setBorderLeft(BorderStyle.THIN);
        this.styleBodyDate.setBorderRight(BorderStyle.THIN);
        this.styleBodyDate.setWrapText(true);
        this.styleBodyDate.setFont(this.bodyFont);
        this.styleBodyDate.setDataFormat(this.createHelper.createDataFormat().getFormat(this.DateFormat));
        this.styleBodyDateTime = this.workbook.createCellStyle();
        this.styleBodyDateTime.setBorderBottom(BorderStyle.THIN);
        this.styleBodyDateTime.setBorderTop(BorderStyle.THIN);
        this.styleBodyDateTime.setBorderLeft(BorderStyle.THIN);
        this.styleBodyDateTime.setBorderRight(BorderStyle.THIN);
        this.styleBodyDateTime.setWrapText(true);
        this.styleBodyDateTime.setFont(this.bodyFont);
        this.styleBodyDateTime.setDataFormat(this.createHelper.createDataFormat().getFormat(this.DateTimeFormat));
        this.styleBodyTime = this.workbook.createCellStyle();
        this.styleBodyTime.setBorderBottom(BorderStyle.THIN);
        this.styleBodyTime.setBorderTop(BorderStyle.THIN);
        this.styleBodyTime.setBorderLeft(BorderStyle.THIN);
        this.styleBodyTime.setBorderRight(BorderStyle.THIN);
        this.styleBodyTime.setWrapText(true);
        this.styleBodyTime.setFont(this.bodyFont);
        this.styleBodyTime.setDataFormat(this.createHelper.createDataFormat().getFormat(this.TimeFormat));
        this.styleBodyDecimal = this.workbook.createCellStyle();
        this.styleBodyDecimal.setBorderBottom(BorderStyle.THIN);
        this.styleBodyDecimal.setBorderTop(BorderStyle.THIN);
        this.styleBodyDecimal.setBorderLeft(BorderStyle.THIN);
        this.styleBodyDecimal.setBorderRight(BorderStyle.THIN);
        this.styleBodyDecimal.setWrapText(true);
        this.styleBodyDecimal.setFont(this.bodyFont);
        this.styleBodyDecimal.setDataFormat(this.createHelper.createDataFormat().getFormat(DecimalFormat));
        this.styleBodyPercentage = this.workbook.createCellStyle();
        this.styleBodyPercentage.setBorderBottom(BorderStyle.THIN);
        this.styleBodyPercentage.setBorderTop(BorderStyle.THIN);
        this.styleBodyPercentage.setBorderLeft(BorderStyle.THIN);
        this.styleBodyPercentage.setBorderRight(BorderStyle.THIN);
        this.styleBodyPercentage.setWrapText(true);
        this.styleBodyPercentage.setFont(this.bodyFont);
        this.styleBodyPercentage.setDataFormat(this.createHelper.createDataFormat().getFormat(PercFormat));
        this.styleBodyInteger = this.workbook.createCellStyle();
        this.styleBodyInteger.setBorderBottom(BorderStyle.THIN);
        this.styleBodyInteger.setBorderTop(BorderStyle.THIN);
        this.styleBodyInteger.setBorderLeft(BorderStyle.THIN);
        this.styleBodyInteger.setBorderRight(BorderStyle.THIN);
        this.styleBodyInteger.setWrapText(true);
        this.styleBodyInteger.setFont(this.bodyFont);
        this.styleBodyInteger.setDataFormat(this.createHelper.createDataFormat().getFormat(IntegerFormat));
    }

    public POIWorkSheet(OutputStream out) {
        this.out = out;
        this.printTitle = true;
        this.parameters = new ArrayList();
        this.rows = new ArrayList();
        this.title = "Report";
        this.autoSizeColumns = true;
        this.initializeWorkSheet();
    }

    public POIWorkSheet(OutputStream out, String sheetName) {
        this.out = out;
        this.printTitle = true;
        this.parameters = new ArrayList();
        this.rows = new ArrayList();
        this.sheetName = sheetName;
        this.title = "Report";
        this.autoSizeColumns = true;
        this.initializeWorkSheet();
    }

    public POIWorkSheet(OutputStream out, String sheetName, boolean autoSizeColumns) {
        this.out = out;
        this.printTitle = true;
        this.parameters = new ArrayList();
        this.rows = new ArrayList();
        this.sheetName = sheetName;
        this.title = "Report";
        this.autoSizeColumns = autoSizeColumns;
        this.initializeWorkSheet();
    }

    public void addRow(POIRow r) {
        this.rows.add(r);
    }

    public void addParameter(String label, Object value, short valueType) {
        POIParameter p1 = new POIParameter(label, value, valueType);
        this.parameters.add(p1);
    }

    public void addParameter(String label, Object value) {
        POIParameter p1 = new POIParameter(label, value);
        this.parameters.add(p1);
    }

    public boolean isPrintTitle() {
        return this.printTitle;
    }

    public void setPrintTitle(boolean printTitle) {
        this.printTitle = printTitle;
    }

    public ArrayList<POIParameter> getParameters() {
        return this.parameters;
    }

    public ArrayList<POIRow> getRows() {
        return this.rows;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void writeWorkBook() throws IOException {
        if (this.getRows().size() > 0x100000) {
            throw new IOException();
        }
        SXSSFSheet sheet = null;
        sheet = this.getSheetName() == null ? this.workbook.createSheet() : this.workbook.createSheet(this.getSheetName());
        int rownum = 0;
        int cellnum = 0;
        Row row = null;
        Cell cell = null;
        if (this.isPrintTitle()) {
            row = sheet.createRow(rownum++);
            cell = row.createCell(cellnum++);
            cell.setCellStyle(this.styleTitle);
            cell.setCellValue(this.getTitle());
            ++rownum;
            for (POIParameter p : this.getParameters()) {
                cellnum = 0;
                row = sheet.createRow(rownum++);
                cell = row.createCell(cellnum++);
                cell.setCellStyle(this.styleBody);
                cell.setCellValue(p.getLabel());
                cell = row.createCell(cellnum++);
                this.setStyleValue(cell, p.getValueType(), p.getValue());
            }
        }
        if (this.getParameters().size() > 0) {
            ++rownum;
        }
        for (POIRow r : this.getRows()) {
            cellnum = 0;
            row = sheet.createRow(rownum++);
            for (POICell c : r.getCells()) {
                if (r.getRowType() == 1) {
                    cell = row.createCell(cellnum++);
                    cell.setCellStyle(this.styleHeader);
                    cell.setCellValue((String)c.getValue());
                    if (!c.isMergeRegion()) continue;
                    sheet.addMergedRegion(c.getCellRangeAddress());
                    continue;
                }
                cell = row.createCell(cellnum++);
                this.setStyleValue(cell, c.getCellType(), c.getValue());
            }
        }
        try {
            this.workbook.write(this.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CellStyle getCellStyle(short valueType) {
        switch (valueType) {
            case 0: {
                return this.styleBody;
            }
            case 1: {
                return this.styleBody;
            }
            case 2: {
                return this.styleBodyDecimal;
            }
            case 3: {
                return this.styleBodyDecimal;
            }
            case 4: {
                return this.styleBodyDate;
            }
            case 5: {
                return this.styleBodyDate;
            }
            case 6: {
                return this.styleBodyInteger;
            }
            case 9: {
                return this.styleBodyTime;
            }
            case 7: {
                return this.styleBodyInteger;
            }
            case 8: {
                return this.styleBodyDecimal;
            }
        }
        return this.styleBody;
    }

    private void setStyleValue(Cell cell, short cellType, Object cellValue) {
        switch (cellType) {
            case 0: {
                cell.setCellStyle(this.styleBody);
                if (cellValue == null) break;
                cell.setCellValue(cellValue.toString());
                break;
            }
            case 1: {
                cell.setCellStyle(this.styleBody);
                if (cellValue == null) break;
                cell.setCellValue(cellValue.toString());
                break;
            }
            case 2: {
                cell.setCellStyle(this.styleBodyDecimal);
                if (cellValue == null) break;
                if (cellValue instanceof Double) {
                    cell.setCellValue(((Double)cellValue).doubleValue());
                    break;
                }
                try {
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                cell.setCellStyle(this.styleBodyPercentage);
                if (cellValue == null) break;
                if (cellValue instanceof Double) {
                    cell.setCellValue(((Double)cellValue).doubleValue());
                    break;
                }
                try {
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                cell.setCellStyle(this.styleBodyDate);
                if (cellValue == null) break;
                cell.setCellValue((Date)cellValue);
                break;
            }
            case 5: {
                cell.setCellStyle(this.styleBodyDateTime);
                if (cellValue == null) break;
                cell.setCellValue((Date)cellValue);
                break;
            }
            case 6: {
                cell.setCellStyle(this.styleBodyInteger);
                if (cellValue == null) break;
                if (cellValue instanceof Double) {
                    cell.setCellValue(((Double)cellValue).doubleValue());
                    break;
                }
                try {
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                }
                catch (Exception exception) {}
                break;
            }
            case 7: {
                cell.setCellStyle(this.styleBodyInteger);
                if (cellValue == null) break;
                if (cellValue instanceof Double) {
                    cell.setCellValue(((Double)cellValue).doubleValue());
                    break;
                }
                try {
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                }
                catch (Exception exception) {}
                break;
            }
            case 8: {
                cell.setCellStyle(this.styleBodyDecimal);
                if (cellValue == null) break;
                if (cellValue instanceof Double) {
                    cell.setCellValue(((Double)cellValue).doubleValue());
                    break;
                }
                try {
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                }
                catch (Exception exception) {}
                break;
            }
            case 9: {
                cell.setCellStyle(this.styleBodyTime);
                if (cellValue == null) break;
                cell.setCellValue((Date)cellValue);
                break;
            }
            default: {
                cell.setCellStyle(this.styleBody);
                if (cellValue == null) break;
                cell.setCellValue(cellValue.toString());
            }
        }
    }
}

