/*
 * Decompiled with CFR 0.152.
 */
package cc.altius.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class StringUtils {
    public static int LEFT = 1;
    public static int RIGHT = 2;

    public static String[] split(String mainString, char delim, char textQualifier) {
        ArrayList<String> finalArray = new ArrayList<String>();
        Object tmpString = "";
        boolean hasTextQualifier = false;
        if (textQualifier != '*') {
            hasTextQualifier = true;
        }
        boolean insideText = false;
        for (int x = 0; x < mainString.length(); ++x) {
            if (mainString.charAt(x) == textQualifier && hasTextQualifier) {
                if (insideText) {
                    insideText = false;
                    continue;
                }
                insideText = true;
                continue;
            }
            if (mainString.charAt(x) == delim && (!insideText && hasTextQualifier || !hasTextQualifier)) {
                finalArray.add(((String)tmpString).trim());
                tmpString = "";
                continue;
            }
            tmpString = (String)tmpString + mainString.charAt(x);
        }
        finalArray.add((String)tmpString);
        String[] returnArray = new String[finalArray.size()];
        for (int x = 0; x < finalArray.size(); ++x) {
            returnArray[x] = (String)finalArray.get(x);
        }
        return returnArray;
    }

    public static String roundString(double originalNumber, int noOfDigits) {
        String tmp = Double.toString(StringUtils.round(originalNumber, noOfDigits));
        if (tmp.length() - 1 - tmp.indexOf(".") < noOfDigits) {
            return StringUtils.pad(tmp, '0', noOfDigits + 1 + tmp.indexOf("."), RIGHT);
        }
        return tmp;
    }

    public static double round(double originalNumber, int noOfDigits) {
        double finalNumber = Math.round(originalNumber * Math.pow(10.0, noOfDigits));
        return finalNumber / Math.pow(10.0, noOfDigits);
    }

    public static String pad(String str, char padChar, int len, int direction) {
        StringBuffer pad = new StringBuffer();
        pad.append(padChar);
        Object newString = str;
        while (((String)newString).length() < len) {
            if (direction == 1) {
                newString = pad + (String)newString;
                continue;
            }
            if (direction != 2) continue;
            newString = (String)newString + pad;
        }
        return newString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream cleanInputStreamForUpload(InputStream is) {
        boolean insideFlag = false;
        StringBuilder outputString = new StringBuilder();
        char[] charBuf = new char[1];
        InputStreamReader isr = new InputStreamReader(is);
        try {
            block17: while (isr.read(charBuf) != -1) {
                switch (charBuf[0]) {
                    case '\"': {
                        if (insideFlag) {
                            insideFlag = false;
                            continue block17;
                        }
                        insideFlag = true;
                        continue block17;
                    }
                    case '\'': {
                        outputString.append('`');
                        continue block17;
                    }
                    case ',': {
                        if (insideFlag) {
                            outputString.append('.');
                            continue block17;
                        }
                        outputString.append(charBuf[0]);
                        continue block17;
                    }
                    case '\n': {
                        if (insideFlag) {
                            outputString.append(' ');
                            continue block17;
                        }
                        outputString.append(charBuf[0]);
                        continue block17;
                    }
                }
                outputString.append(charBuf[0]);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return IOUtils.toInputStream((String)outputString.toString(), (Charset)Charset.defaultCharset());
    }

    public static boolean isBlank(String input) {
        if (input == null) {
            return true;
        }
        return input.isEmpty();
    }

    public static boolean isValidMobileNo(String input) {
        if (StringUtils.isBlank(input)) {
            return false;
        }
        if (input.length() != 10) {
            return false;
        }
        return input.matches("[7-9][0-9]{9}");
    }

    public static String convertToString(Integer[] intArray) {
        StringBuilder sb = new StringBuilder();
        for (Integer i : intArray) {
            if (i == null) continue;
            sb.append("'").append(i).append("',");
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String convertToString(String[] strArray) {
        StringBuilder sb = new StringBuilder();
        for (String i : strArray) {
            if (i == null) continue;
            sb.append("'").append(i).append("',");
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean isNumber(String input) {
        Pattern pattern = Pattern.compile(".*[^0-9].*");
        if (StringUtils.isBlank(input)) {
            return false;
        }
        return !pattern.matcher(input).matches();
    }

    public static boolean isNumber(String input, int len) {
        Pattern digitPattern = Pattern.compile("\\d{" + len + "}");
        if (StringUtils.isBlank(input)) {
            return false;
        }
        return digitPattern.matcher(input).matches();
    }

    public static String appendOrdinalSuffixToInt(int i) {
        int j = i % 10;
        int k = i % 100;
        if (j == 1 && k != 11) {
            return i + " ST";
        }
        if (j == 2 && k != 12) {
            return i + " ND";
        }
        if (j == 3 && k != 13) {
            return i + " RD";
        }
        return i + " TH";
    }

    public static String escapeQuotes(String s) {
        String source1 = "'";
        String target1 = "\\'";
        String source2 = "\"";
        String target2 = "\\\"";
        return s.replace(source1, target1).replace(source2, target2);
    }

    public static boolean isValidEmail(String emailId) {
        String regEx = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        Matcher matcherObj = Pattern.compile(regEx).matcher(emailId);
        return matcherObj.matches();
    }
}

