/*
 * Decompiled with CFR 0.152.
 */
package cc.altius.utils.TreeUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedList;
import java.util.List;

public class Node<T> {
    private int id;
    private Integer parentId;
    private T payload;
    @JsonIgnore
    private List<Node<T>> tree;
    private int level;
    private String sortOrder;
    private int payloadId;

    public Node(int id, Integer parentId, T payload, int payloadId) {
        this.id = id;
        this.parentId = parentId;
        this.payload = payload;
        this.tree = new LinkedList<Node<T>>();
        this.payloadId = payloadId;
    }

    public Node(int id, int payloadId) {
        this.id = id;
        this.payloadId = payloadId;
        this.tree = new LinkedList<Node<T>>();
        this.level = 0;
        this.sortOrder = "00";
    }

    public Node() {
        this.tree = new LinkedList<Node<T>>();
    }

    public int getPayloadId() {
        return this.payloadId;
    }

    public void setPayloadId(int payloadId) {
        this.payloadId = payloadId;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public List<Node<T>> getTree() {
        return this.tree;
    }

    public void setTree(List<Node<T>> tree) {
        this.tree = tree;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public T getPayload() {
        return this.payload;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    @JsonIgnore
    public boolean hasChild() {
        return !this.tree.isEmpty();
    }

    @JsonIgnore
    public int getNoOfChild() {
        return this.getTree().size();
    }

    public String toString() {
        return "Node{sortOrder=" + this.sortOrder + ", level=" + this.level + ", id=" + this.id + ", parentId=" + this.parentId + ", payloadId=" + this.payloadId + ", payload=" + this.payload + ", tree=" + this.tree.size() + "}";
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.id;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return this.id == other.id;
    }
}

