/*
 * Decompiled with CFR 0.152.
 */
package cc.altius.utils.TreeUtils;

import cc.altius.utils.StringUtils;
import cc.altius.utils.TreeUtils.Node;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class Tree<T>
implements Serializable {
    private final Node<T> root;
    private List<Node<T>> flatList = new LinkedList<Node<T>>();

    public Tree(Node<T> root) {
        this.root = root;
        this.root.setLevel(0);
        this.root.setSortOrder("00");
        this.flatList = new LinkedList<Node<T>>();
        this.flatList.add(root);
    }

    public void addNode(Node<T> n) throws Exception {
        if (n.getParentId() == null) {
            throw new Exception("Must have a valid Parent Id");
        }
        Node checkNode = new Node(n.getParentId(), 0);
        int idx = this.flatList.indexOf(checkNode);
        if (idx == -1) {
            throw new Exception("Must have a valid Parent Id");
        }
        Node<T> foundNode = this.findNode(this.root, n.getParentId());
        if (foundNode != null) {
            n.setLevel(foundNode.getLevel() + 1);
            String newSortOrder = foundNode.getSortOrder() + ".";
            newSortOrder = newSortOrder + StringUtils.pad(Integer.toString(foundNode.getNoOfChild() + 1), '0', 2, StringUtils.LEFT);
            n.setSortOrder(newSortOrder);
            foundNode.getTree().add(n);
        } else {
            n.setLevel(this.root.getLevel() + 1);
            String newSortOrder = this.root.getSortOrder() + ".";
            newSortOrder = newSortOrder + StringUtils.pad(Integer.toString(this.root.getNoOfChild() + 1), '0', 2, StringUtils.LEFT);
            n.setSortOrder(newSortOrder);
            this.root.getTree().add(n);
        }
        this.flatList.add(n);
    }

    public Node<T> findNode(int id) {
        Node<T> n = this.root;
        return this.findNode(n, id);
    }

    private Node<T> findNode(Node<T> node, int id) {
        if (node.getId() == id) {
            return node;
        }
        for (Node<T> n : node.getTree()) {
            Node<T> foundNode;
            if (n.getId() == id) {
                return n;
            }
            if (n.getTree().isEmpty() || (foundNode = this.findNode(n, id)) == null) continue;
            return foundNode;
        }
        return null;
    }

    public Node<T> findNodeByPayloadId(int payloadId) {
        Node<T> n = this.root;
        return this.findNodeByPayloadId(n, payloadId);
    }

    private Node<T> findNodeByPayloadId(Node<T> node, int payloadId) {
        if (node.getPayloadId() == payloadId) {
            return node;
        }
        for (Node<T> n : node.getTree()) {
            Node<T> foundNode;
            if (n.getPayloadId() == payloadId) {
                return n;
            }
            if (n.getTree().isEmpty() || (foundNode = this.findNodeByPayloadId(n, payloadId)) == null) continue;
            return foundNode;
        }
        return null;
    }

    public Node<T> getTreeRoot() {
        return this.root;
    }

    public List<Node<T>> getFlatList() {
        return this.flatList;
    }

    public List<T> getPayloadSubList(int id, boolean includeSelf, int level) {
        LinkedList<T> subList = new LinkedList<T>();
        Node<T> n = this.findNode(id);
        if (includeSelf) {
            subList.add(n.getPayload());
        }
        if (level == -1 || level > 0) {
            n.getTree().forEach(child -> this.getPayloadSubList((Node<T>)child, (List<T>)subList, level > 0 ? level - 1 : level));
        }
        return subList;
    }

    public List<Node<T>> getTreeFullList() {
        return this.getTreeSubList(1, true, -1);
    }

    public List<Node<T>> getTreeSubList(int id, boolean includeSelf, int level) {
        LinkedList<Node<T>> subList = new LinkedList<Node<T>>();
        Node<T> n = this.findNode(id);
        if (includeSelf) {
            subList.add(n);
        }
        if (level == -1 || level > 0) {
            n.getTree().forEach(child -> this.getTreeSubList((Node<T>)child, (List<Node<T>>)subList, level > 0 ? level - 1 : level));
        }
        return subList;
    }

    private void getPayloadSubList(Node<T> n, List<T> subList, int level) {
        subList.add(n.getPayload());
        if (level == -1 || level > 0) {
            n.getTree().forEach(child -> this.getPayloadSubList((Node<T>)child, subList, level > 0 ? level - 1 : level));
        }
    }

    private void getTreeSubList(Node<T> n, List<Node<T>> subList, int level) {
        subList.add(n);
        if (level == -1 || level > 0) {
            n.getTree().forEach(child -> this.getTreeSubList((Node<T>)child, subList, level > 0 ? level - 1 : level));
        }
    }
}

