/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.configuration.json;

import cc.carm.lib.configuration.core.ConfigInitializer;
import cc.carm.lib.configuration.core.source.ConfigurationProvider;
import cc.carm.lib.configuration.core.source.impl.FileConfigProvider;
import cc.carm.lib.configuration.json.JSONConfigWrapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSONConfigProvider
extends FileConfigProvider<JSONConfigWrapper> {
    protected final Gson gson = new GsonBuilder().serializeNulls().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapter(JSONConfigWrapper.class, (src, typeOfSrc, context) -> context.serialize(src.data)).create();
    protected JSONConfigWrapper configuration;
    protected ConfigInitializer<JSONConfigProvider> initializer = new ConfigInitializer((ConfigurationProvider)this);

    public JSONConfigProvider(@NotNull File file) {
        super(file);
    }

    public void initializeConfig() {
        LinkedHashMap map = null;
        try (FileInputStream is = new FileInputStream(this.file);){
            map = (LinkedHashMap)this.gson.fromJson((Reader)new InputStreamReader((InputStream)is, StandardCharsets.UTF_8), LinkedHashMap.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (map == null) {
            map = new LinkedHashMap();
        }
        this.configuration = new JSONConfigWrapper(map);
        this.initializer = new ConfigInitializer((ConfigurationProvider)this);
    }

    @NotNull
    public JSONConfigWrapper getConfiguration() {
        return this.configuration;
    }

    public void reload() {
        this.initializeConfig();
    }

    public void save() throws Exception {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);){
            this.gson.toJson(this.configuration.data, (Appendable)writer);
        }
    }

    public void setComments(@NotNull String path, String ... comments) {
    }

    @Nullable
    public String[] getComments(@NotNull String path) {
        return new String[0];
    }

    @NotNull
    public ConfigInitializer<? extends ConfigurationProvider<JSONConfigWrapper>> getInitializer() {
        return this.initializer;
    }
}

