/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.configuration.json;

import cc.carm.lib.configuration.core.source.ConfigurationWrapper;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSONConfigWrapper
implements ConfigurationWrapper {
    private static final char SEPARATOR = '.';
    protected final Map<String, Object> data = new LinkedHashMap<String, Object>();

    JSONConfigWrapper(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key;
            String string = key = entry.getKey() == null ? "null" : entry.getKey().toString();
            if (entry.getValue() instanceof Map) {
                this.data.put(key, new JSONConfigWrapper((Map)entry.getValue()));
                continue;
            }
            this.data.put(key, entry.getValue());
        }
    }

    @NotNull
    public Set<String> getKeys(boolean deep) {
        return new LinkedHashSet<String>(this.data.keySet());
    }

    @NotNull
    public Map<String, Object> getValues(boolean deep) {
        return new LinkedHashMap<String, Object>(this.data);
    }

    public void set(@NotNull String path, @Nullable Object value) {
        JSONConfigWrapper section;
        if (value instanceof Map) {
            value = new JSONConfigWrapper((Map)value);
        }
        if ((section = this.getSectionFor(path)) == this) {
            if (value == null) {
                this.data.remove(path);
            } else {
                this.data.put(path, value);
            }
        } else {
            section.set(this.getChild(path), value);
        }
    }

    public boolean contains(@NotNull String path) {
        return this.get(path) != null;
    }

    @Nullable
    public Object get(@NotNull String path) {
        JSONConfigWrapper section = this.getSectionFor(path);
        return section == this ? this.data.get(path) : section.get(this.getChild(path));
    }

    public boolean isList(@NotNull String path) {
        return this.get(path) instanceof List;
    }

    @Nullable
    public List<?> getList(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof List ? (List)val : null;
    }

    public boolean isConfigurationSection(@NotNull String path) {
        return this.get(path) instanceof JSONConfigWrapper;
    }

    @Nullable
    public ConfigurationWrapper getConfigurationSection(@NotNull String path) {
        Object val = this.get(path);
        return val instanceof JSONConfigWrapper ? (JSONConfigWrapper)val : null;
    }

    private JSONConfigWrapper getSectionFor(String path) {
        int index = path.indexOf(46);
        if (index == -1) {
            return this;
        }
        String root = path.substring(0, index);
        Object section = this.data.get(root);
        if (section == null) {
            section = new JSONConfigWrapper(new LinkedHashMap());
            this.data.put(root, section);
        }
        return (JSONConfigWrapper)section;
    }

    private String getChild(String path) {
        int index = path.indexOf(46);
        return index == -1 ? path : path.substring(index + 1);
    }
}

