/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.configuration.source.sql;

import cc.carm.lib.configuration.adapter.ValueType;
import cc.carm.lib.configuration.commentable.Commentable;
import cc.carm.lib.configuration.function.DataFunction;
import cc.carm.lib.configuration.source.ConfigurationFactory;
import cc.carm.lib.configuration.source.ConfigurationHolder;
import cc.carm.lib.configuration.source.loader.ConfigurationInitializer;
import cc.carm.lib.configuration.source.sql.SQLSource;
import cc.carm.lib.configuration.source.sql.SQLValueResolver;
import cc.carm.lib.configuration.versioned.VersionedMetaTypes;
import cc.carm.lib.easysql.api.SQLManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class SQLConfigFactory
extends ConfigurationFactory<SQLSource, ConfigurationHolder<SQLSource>, SQLConfigFactory> {
    @NotNull
    protected Supplier<SQLManager> managerSupplier;
    protected Supplier<Gson> gsonSupplier = () -> SQLSource.DEFAULT_GSON;
    protected HashMap<Integer, SQLValueResolver<?>> resolvers = new HashMap(SQLValueResolver.STANDARD_RESOLVERS);
    protected String tableName = "configs";
    protected String namespace = "default";

    public static SQLConfigFactory from(@NotNull @NotNull Supplier<@NotNull SQLManager> managerSupplier) {
        return new SQLConfigFactory(managerSupplier);
    }

    public static SQLConfigFactory from(@NotNull SQLManager manager) {
        return SQLConfigFactory.from(() -> manager);
    }

    public SQLConfigFactory(@NotNull Supplier<SQLManager> managerSupplier) {
        this.managerSupplier = managerSupplier;
    }

    protected SQLConfigFactory self() {
        return this;
    }

    public SQLConfigFactory manager(@NotNull Supplier<SQLManager> managerSupplier) {
        this.managerSupplier = managerSupplier;
        return this.self();
    }

    public SQLConfigFactory manager(@NotNull SQLManager manager) {
        return this.manager(() -> manager);
    }

    public SQLConfigFactory gson(@NotNull Supplier<Gson> gsonSupplier) {
        this.gsonSupplier = gsonSupplier;
        return this.self();
    }

    public SQLConfigFactory gson(@NotNull Consumer<GsonBuilder> builder) {
        return this.gson(() -> {
            GsonBuilder gsonBuilder = new GsonBuilder();
            builder.accept(gsonBuilder);
            return gsonBuilder.create();
        });
    }

    public SQLConfigFactory gson(@NotNull Gson gson) {
        return this.gson(() -> gson);
    }

    public SQLConfigFactory resolver(@Range(from=0L, to=255L) int type, @NotNull SQLValueResolver<?> resolver) {
        this.resolvers.put(type, resolver);
        return this.self();
    }

    public <T> SQLConfigFactory resolver(@Range(from=0L, to=255L) int id, @NotNull Class<T> clazz, @NotNull DataFunction<String, T> parser) {
        return this.resolver(id, ValueType.of(clazz), parser);
    }

    public <T> SQLConfigFactory resolver(@Range(from=0L, to=255L) int id, @NotNull ValueType<T> type, @NotNull DataFunction<String, T> parser) {
        return this.resolver(id, SQLValueResolver.of(type, parser));
    }

    public <T> SQLConfigFactory resolver(@Range(from=0L, to=255L) int id, @NotNull Class<T> clazz, @NotNull DataFunction<String, T> parser, @NotNull DataFunction<T, String> serializer) {
        return this.resolver(id, ValueType.of(clazz), parser, serializer);
    }

    public <T> SQLConfigFactory resolver(@Range(from=0L, to=255L) int id, @NotNull ValueType<T> type, @NotNull DataFunction<String, T> parser, @NotNull DataFunction<T, String> serializer) {
        return this.resolver(id, SQLValueResolver.of(type, parser, serializer));
    }

    public SQLConfigFactory tableName(@NotNull String tableName) {
        this.tableName = tableName;
        return this.self();
    }

    public SQLConfigFactory namespace(@NotNull String namespace) {
        this.namespace = namespace;
        return this.self();
    }

    @NotNull
    public ConfigurationHolder<SQLSource> build() {
        final Gson gson = this.gsonSupplier.get();
        if (gson == null) {
            throw new NullPointerException("No Gson instance provided.");
        }
        final SQLManager manager = this.managerSupplier.get();
        if (manager == null) {
            throw new NullPointerException("No SQLManager instance provided.");
        }
        Commentable.registerMeta((ConfigurationInitializer)this.initializer);
        VersionedMetaTypes.register((ConfigurationInitializer)this.initializer);
        return new ConfigurationHolder<SQLSource>(this.adapters, this.options, this.metadata, this.initializer){
            final SQLSource source;
            {
                super(adapters, options, metadata, initializer);
                this.source = new SQLSource(this, System.currentTimeMillis(), gson, manager, SQLConfigFactory.this.resolvers, SQLConfigFactory.this.tableName, SQLConfigFactory.this.namespace);
            }

            @NotNull
            public SQLSource config() {
                return this.source;
            }
        };
    }
}

