/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.configuration.source.sql;

import cc.carm.lib.configuration.commentable.Commentable;
import cc.carm.lib.configuration.source.ConfigurationHolder;
import cc.carm.lib.configuration.source.section.ConfigureSource;
import cc.carm.lib.configuration.source.section.SourcedSection;
import cc.carm.lib.configuration.source.sql.SQLOptions;
import cc.carm.lib.configuration.source.sql.SQLValueResolver;
import cc.carm.lib.configuration.value.ConfigValue;
import cc.carm.lib.configuration.versioned.VersionedMetaTypes;
import cc.carm.lib.easysql.api.SQLManager;
import cc.carm.lib.easysql.api.SQLQuery;
import cc.carm.lib.easysql.api.SQLTable;
import cc.carm.lib.easysql.api.action.PreparedSQLUpdateBatchAction;
import cc.carm.lib.easysql.api.action.query.PreparedQueryAction;
import cc.carm.lib.easysql.api.builder.DeleteBuilder;
import cc.carm.lib.easysql.api.builder.TableQueryBuilder;
import cc.carm.lib.easysql.api.enums.IndexType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLSource
extends ConfigureSource<SourcedSection, Map<String, Object>, SQLSource> {
    @NotNull
    protected static final Gson DEFAULT_GSON = new GsonBuilder().serializeNulls().disableHtmlEscaping().create();
    @NotNull
    protected final Gson gson;
    @NotNull
    protected final SQLManager sqlManager;
    @NotNull
    protected final String namespace;
    @NotNull
    protected final SQLTable table;
    @NotNull
    protected final Map<Integer, SQLValueResolver<?>> resolvers;
    protected SourcedSection rootSection;

    public SQLSource(@NotNull ConfigurationHolder<? extends SQLSource> holder, long lastUpdateMillis, @NotNull Gson gson, @NotNull SQLManager sqlManager, @NotNull Map<Integer, SQLValueResolver<?>> resolvers, @NotNull String tableName, @NotNull String namespace) {
        super(holder, lastUpdateMillis);
        this.gson = gson;
        this.sqlManager = sqlManager;
        this.resolvers = resolvers;
        this.namespace = namespace;
        this.table = SQLTable.of((String)tableName, builder -> {
            builder.addColumn("namespace", "VARCHAR(32) NOT NULL");
            builder.addColumn("path", "VARCHAR(96) NOT NULL");
            builder.addColumn("value", "TEXT");
            builder.addColumn("inline_comment", "TEXT");
            builder.addColumn("header_comments", "MEDIUMTEXT");
            builder.addColumn("footer_comments", "MEDIUMTEXT");
            builder.addColumn("type", "TINYINT NOT NULL DEFAULT 0");
            builder.addColumn("version", "MEDIUMINT UNSIGNED NOT NULL DEFAULT 0");
            builder.addColumn("create_time", "TIMESTAMP NOT NULL");
            builder.addColumn("update_time", "TIMESTAMP NOT NULL");
            builder.setIndex(IndexType.PRIMARY_KEY, "pk_" + tableName.toLowerCase(), "namespace", new String[]{"path"});
            builder.setTableSettings("ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
        });
        try {
            this.table.create(this.sqlManager);
            this.onReload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    protected SQLSource self() {
        return this;
    }

    @NotNull
    public Gson gson() {
        return this.gson;
    }

    @NotNull
    public Map<String, Object> original() {
        return this.section().data();
    }

    @NotNull
    public SourcedSection section() {
        return Objects.requireNonNull(this.rootSection, "Root section is not initialized.");
    }

    public int purge() throws Exception {
        return (Integer)((DeleteBuilder)this.table.createDelete().addCondition("namespace", (Object)this.namespace)).build().execute();
    }

    public void save() throws Exception {
        LocalDateTime time = LocalDateTime.now();
        ArrayList<Object[]> dataValues = new ArrayList<Object[]>();
        SourcedSection section = this.section();
        Map values = this.holder().registeredValues();
        for (Map.Entry entry : values.entrySet()) {
            @NotNull String path = (String)entry.getKey();
            @NotNull ConfigValue config = (ConfigValue)entry.getValue();
            @Nullable ArrayList<Map<K, V>> value = section.get(path);
            if (value instanceof SourcedSection) {
                value = ((SourcedSection)value).rawMap();
            } else if (value instanceof List) {
                ArrayList list = new ArrayList();
                for (Object obj : (List)value) {
                    if (obj instanceof SourcedSection) {
                        list.add(((SourcedSection)obj).rawMap());
                        continue;
                    }
                    list.add(obj);
                }
                value = list;
            }
            if (value == null) continue;
            try {
                int typeID = this.typeIdOf(value);
                String data = this.serialize(typeID, value);
                if (data == null) continue;
                int version = (Integer)this.holder().metadata(path).get(VersionedMetaTypes.VERSION, (Object)0);
                dataValues.add(new Object[]{this.namespace, path, time, version, typeID, data, Commentable.getInlineComment((ConfigurationHolder)this.holder(), (String)path), this.gson.toJson((Object)Commentable.getHeaderComments((ConfigurationHolder)this.holder(), (String)path)), this.gson.toJson((Object)Commentable.getFooterComments((ConfigurationHolder)this.holder(), (String)path))});
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (((Boolean)this.holder.option(SQLOptions.PURGE)).booleanValue()) {
            this.purge();
        }
        ((PreparedSQLUpdateBatchAction)this.table.createReplaceBatch().setColumnNames(new String[]{"namespace", "path", "update_time", "version", "type", "value", "inline_comment", "header_comments", "footer_comments"})).setAllParams(dataValues).execute();
    }

    protected void onReload() throws Exception {
        LinkedHashMap<String, Object> loaded = new LinkedHashMap<String, Object>();
        try (SQLQuery query = (SQLQuery)((PreparedQueryAction)((TableQueryBuilder)this.table.createQuery().addCondition("namespace", (Object)this.namespace)).build()).execute();){
            ResultSet rs = query.getResultSet();
            while (rs.next()) {
                String path = rs.getString("path");
                if (path == null) continue;
                int ver = rs.getInt("version");
                try {
                    loaded.put(path, this.parse(rs.getInt("type"), rs.getString("value")));
                    if (ver == 0) continue;
                    this.holder().metadata(path).set(VersionedMetaTypes.VERSION, (Object)ver);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.rootSection = SourcedSection.root((ConfigureSource)this, loaded);
    }

    @Nullable
    protected Object parse(int type, String value) throws Exception {
        SQLValueResolver<?> function = this.resolvers.get(type);
        if (function == null) {
            throw new IllegalStateException("No resolvers for type #" + type);
        }
        return function.resolve(this, value);
    }

    @Nullable
    protected String serialize(int type, @NotNull Object value) throws Exception {
        SQLValueResolver<?> function = this.resolvers.get(type);
        if (function == null) {
            throw new IllegalStateException("No resolvers for type #" + type);
        }
        return function.serialize(this, value);
    }

    protected int typeIdOf(@NotNull Object value) {
        return this.resolvers.entrySet().stream().filter(entry -> ((SQLValueResolver)entry.getValue()).isInstance(value)).findFirst().map(Map.Entry::getKey).orElseThrow(() -> new IllegalStateException("No resolvers for value " + value.getClass().getName()));
    }
}

