/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.configuration.source.sql;

import cc.carm.lib.configuration.adapter.ValueType;
import cc.carm.lib.configuration.function.DataFunction;
import cc.carm.lib.configuration.source.sql.SQLSource;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SQLValueResolver<T> {
    @NotNull
    public static final SQLValueResolver<String> STRING = SQLValueResolver.of(ValueType.STRING, s -> s);
    @NotNull
    public static final SQLValueResolver<Byte> BYTE = SQLValueResolver.of(ValueType.BYTE, Byte::parseByte);
    @NotNull
    public static final SQLValueResolver<Short> SHORT = SQLValueResolver.of(ValueType.SHORT, Short::parseShort);
    @NotNull
    public static final SQLValueResolver<Integer> INTEGER = SQLValueResolver.of(ValueType.INTEGER, Integer::parseInt);
    @NotNull
    public static final SQLValueResolver<Long> LONG = SQLValueResolver.of(ValueType.LONG, Long::parseLong);
    @NotNull
    public static final SQLValueResolver<Float> FLOAT = SQLValueResolver.of(ValueType.FLOAT, Float::parseFloat);
    @NotNull
    public static final SQLValueResolver<Double> DOUBLE = SQLValueResolver.of(ValueType.DOUBLE, Double::parseDouble);
    @NotNull
    public static final SQLValueResolver<Boolean> BOOLEAN = SQLValueResolver.of(ValueType.BOOLEAN, Boolean::parseBoolean);
    @NotNull
    public static final SQLValueResolver<Character> CHAR = SQLValueResolver.of(ValueType.CHAR, s -> Character.valueOf(s.charAt(0)));
    @NotNull
    public static final SQLValueResolver<List<?>> LIST = new SQLValueResolver<List<?>>(new ValueType<List<?>>(){}){

        @Override
        @Nullable
        public List<?> resolve(@NotNull SQLSource source, String data) throws Exception {
            return (List)source.gson().fromJson(data, List.class);
        }

        @Override
        @Nullable
        public String serialize(@NotNull SQLSource source, Object value) {
            return source.gson().toJson(value);
        }
    };
    @NotNull
    public static final SQLValueResolver<Map<?, ?>> MAP = new SQLValueResolver<Map<?, ?>>(new ValueType<Map<?, ?>>(){}){

        @Override
        @Nullable
        public Map<?, ?> resolve(@NotNull SQLSource source, String data) throws Exception {
            return (Map)source.gson().fromJson(data, LinkedHashMap.class);
        }

        @Override
        @Nullable
        public String serialize(@NotNull SQLSource source, Object value) {
            return source.gson().toJson(value);
        }
    };
    @NotNull
    public static final Map<Integer, SQLValueResolver<?>> STANDARD_RESOLVERS = Collections.unmodifiableMap(SQLValueResolver.standards());
    @NotNull
    protected final ValueType<T> type;

    static Map<Integer, SQLValueResolver<?>> standards() {
        LinkedHashMap map = new LinkedHashMap();
        map.put(0, STRING);
        map.put(1, BYTE);
        map.put(2, SHORT);
        map.put(3, INTEGER);
        map.put(4, LONG);
        map.put(5, FLOAT);
        map.put(6, DOUBLE);
        map.put(7, BOOLEAN);
        map.put(8, CHAR);
        map.put(10, LIST);
        map.put(11, MAP);
        return map;
    }

    public static <V> SQLValueResolver<V> of(@NotNull ValueType<V> type, final @NotNull DataFunction<String, V> resolver) {
        return new SQLValueResolver<V>(type){

            @Override
            @NotNull
            public V resolve(@NotNull SQLSource source, String data) throws Exception {
                return resolver.handle((Object)data);
            }
        };
    }

    public static <V> SQLValueResolver<V> of(@NotNull ValueType<V> type, final @NotNull DataFunction<String, V> resolver, final @NotNull DataFunction<V, String> serializer) {
        return new SQLValueResolver<V>(type){

            @Override
            @NotNull
            public V resolve(@NotNull SQLSource source, String data) throws Exception {
                return resolver.handle((Object)data);
            }

            @Override
            @NotNull
            public String serialize(@NotNull SQLSource source, Object value) throws Exception {
                return (String)serializer.handle(this.type.cast(value));
            }
        };
    }

    protected SQLValueResolver(@NotNull ValueType<T> type) {
        this.type = type;
    }

    @NotNull
    public ValueType<T> getType() {
        return this.type;
    }

    public boolean isInstance(@NotNull Object obj) {
        return this.getType().isInstance(obj);
    }

    @Nullable
    public abstract T resolve(@NotNull SQLSource var1, String var2) throws Exception;

    @Nullable
    public String serialize(@NotNull SQLSource source, Object value) throws Exception {
        return String.valueOf(value);
    }
}

