/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.mineconfiguration.bukkit.source;

import cc.carm.lib.configuration.core.ConfigInitializer;
import cc.carm.lib.configuration.core.source.ConfigurationProvider;
import cc.carm.lib.mineconfiguration.bukkit.source.BukkitYAMLComments;
import cc.carm.lib.mineconfiguration.bukkit.source.CraftConfigProvider;
import cc.carm.lib.mineconfiguration.bukkit.source.CraftSectionWrapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BukkitConfigProvider
extends CraftConfigProvider {
    protected static final char SEPARATOR = '.';
    protected BukkitYAMLComments bukkitComments = new BukkitYAMLComments();

    public BukkitConfigProvider(@NotNull File file) {
        super(file);
    }

    public void initializeConfig() {
        this.configuration = YamlConfiguration.loadConfiguration((File)this.file);
        this.initializer = new ConfigInitializer((ConfigurationProvider)this);
    }

    @NotNull
    public CraftSectionWrapper getConfiguration() {
        return CraftSectionWrapper.of((ConfigurationSection)this.configuration);
    }

    public void save() throws Exception {
        this.configuration.save(this.getFile());
        StringWriter writer = new StringWriter();
        this.bukkitComments.writeComments(this.configuration, new BufferedWriter(writer));
        String value = writer.toString();
        Path toUpdatePath = this.getFile().toPath();
        if (!value.equals(new String(Files.readAllBytes(toUpdatePath), StandardCharsets.UTF_8))) {
            Files.write(toUpdatePath, value.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public void setHeaderComment(@Nullable String path, @Nullable List<String> comments) {
        this.bukkitComments.setHeaderComments(path, comments);
    }

    public void setInlineComment(@NotNull String path, @Nullable String comment) {
        this.bukkitComments.setInlineComment(path, comment);
    }

    @Nullable
    public @Unmodifiable List<String> getHeaderComment(@Nullable String path) {
        return this.bukkitComments.getHeaderComment(path);
    }

    @Nullable
    public String getInlineComment(@NotNull String path) {
        return this.bukkitComments.getInlineComment(path);
    }
}

