/*
 * Decompiled with CFR 0.152.
 */
package cc.carm.lib.mineconfiguration.bukkit.source;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BukkitYAMLComments {
    @NotNull
    protected final Map<String, List<String>> headerComments = new HashMap<String, List<String>>();
    @NotNull
    protected final Map<String, String> inlineComments = new HashMap<String, String>();

    @NotNull
    protected Map<String, List<String>> getHeaderComments() {
        return this.headerComments;
    }

    @NotNull
    protected Map<String, String> getInlineComments() {
        return this.inlineComments;
    }

    public void setHeaderComments(@Nullable String path, @Nullable List<String> comments) {
        if (comments == null) {
            this.getHeaderComments().remove(path);
        } else {
            this.getHeaderComments().put(path, comments);
        }
    }

    public void setInlineComment(@NotNull String path, @Nullable String comment) {
        if (comment == null) {
            this.getInlineComments().remove(path);
        } else {
            this.getInlineComments().put(path, comment);
        }
    }

    @Nullable
    public @Unmodifiable List<String> getHeaderComment(@Nullable String path) {
        return Optional.ofNullable(this.getHeaderComments().get(path)).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public String getInlineComment(@NotNull String path) {
        return this.getInlineComments().get(path);
    }

    @Nullable
    public String buildHeaderComments(@Nullable String path, @NotNull String indents) {
        List<String> comments = this.getHeaderComment(path);
        if (comments == null || comments.size() == 0) {
            return null;
        }
        StringJoiner joiner = new StringJoiner("\n");
        for (String comment : comments) {
            if (comment.length() == 0) {
                joiner.add(" ");
                continue;
            }
            joiner.add(indents + "# " + comment);
        }
        return joiner + "\n";
    }

    public void writeComments(@NotNull YamlConfiguration source, @NotNull BufferedWriter writer) throws IOException {
        YamlConfiguration temp = new YamlConfiguration();
        String configHeader = this.buildHeaderComments(null, "");
        if (configHeader != null) {
            writer.write(configHeader);
        }
        for (String fullKey : source.getKeys(true)) {
            Object currentValue = source.get(fullKey);
            String indents = BukkitYAMLComments.getIndents(fullKey);
            String headerComments = this.buildHeaderComments(fullKey, indents);
            String inlineComment = this.getInlineComment(fullKey);
            if (headerComments != null) {
                writer.write(headerComments);
            }
            String[] splitFullKey = fullKey.split("[.]");
            String trailingKey = splitFullKey[splitFullKey.length - 1];
            if (currentValue instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)currentValue;
                writer.write(indents + trailingKey + ":");
                if (inlineComment != null && inlineComment.length() > 0) {
                    writer.write(" # " + inlineComment);
                }
                if (!section.getKeys(false).isEmpty()) {
                    writer.write("\n");
                    continue;
                }
                writer.write(" {}\n");
                if (indents.length() != 0) continue;
                writer.write("\n");
                continue;
            }
            temp.set(trailingKey, currentValue);
            String yaml = temp.saveToString();
            temp.set(trailingKey, null);
            yaml = yaml.substring(0, yaml.length() - 1);
            if (inlineComment != null && inlineComment.length() > 0) {
                if (yaml.contains("\n")) {
                    String[] splitLine = yaml.split("\n", 2);
                    yaml = splitLine[0] + " # " + inlineComment + "\n" + splitLine[1];
                } else {
                    yaml = yaml + " # " + inlineComment;
                }
            }
            writer.write(indents + yaml.replace("\n", "\n" + indents) + "\n");
            if (indents.length() != 0) continue;
            writer.write("\n");
        }
        writer.close();
    }

    protected static String getIndents(String key) {
        String[] splitKey = key.split("[.]");
        return IntStream.range(1, splitKey.length).mapToObj(i -> "  ").collect(Collectors.joining());
    }
}

