/*
 * Decompiled with CFR 0.152.
 */
package cc.cc4414.spring.resource.util;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.Signer;

public final class TokenUtils {
    public static boolean isExpires(String value, StringRedisTemplate redisTemplate) {
        if (value != null && value.toLowerCase().startsWith("bearer")) {
            long iat;
            String token = value.substring("bearer".length()).trim();
            Jwt jwt = JwtHelper.decode((String)token);
            String claims = jwt.getClaims();
            JSON json = JSONUtil.parse((Object)claims);
            String id = (String)json.getByPath("id", String.class);
            String date = (String)redisTemplate.opsForValue().get((Object)("auth:expires:" + id));
            if (date != null && (iat = ((Long)json.getByPath("iat", Long.class)).longValue()) < Long.parseLong(date)) {
                return true;
            }
        }
        return false;
    }

    public static String createAccessToken(Object user, String key) {
        JSONObject obj = JSONUtil.parseObj((Object)user);
        obj.put("exp", (Object)(System.currentTimeMillis() / 1000L + 43200L));
        obj.put("iat", (Object)System.currentTimeMillis());
        return JwtHelper.encode((CharSequence)obj.toString(), (Signer)new MacSigner(key)).getEncoded();
    }

    private TokenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

