/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.easytool.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String objectConvertToJson(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            log.error("JsonUtil objectConvertToJson fail error=", (Throwable)e);
            return null;
        }
    }

    public static <T> T jsonConvertToObject(String src, Class<T> clazz) {
        if (Objects.isNull(src) || src.length() < 1 || Objects.isNull(clazz)) {
            return null;
        }
        try {
            return (T)(clazz.equals(String.class) ? src : objectMapper.readValue(src, clazz));
        }
        catch (Exception e) {
            log.error("JsonUtil jsonConvertToObject fail error=", (Throwable)e);
            return null;
        }
    }

    public static <T> T objectConvertToObject(Object obj, Class<T> clazz) {
        return JsonUtil.jsonConvertToObject(JsonUtil.objectConvertToJson(obj), clazz);
    }

    public static Map<String, Object> jsonConvertToMap(String src) {
        if (Objects.isNull(src) || src.length() < 1) {
            return Collections.emptyMap();
        }
        try {
            return (Map)objectMapper.readValue(src, Map.class);
        }
        catch (Exception e) {
            log.error("JsonUtil jsonConvertToMap fail error=", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static <T> List<T> jsonConvertToList(String src, Class<T> clazz) {
        if (Objects.isNull(src) || src.length() < 1 || Objects.isNull(clazz)) {
            return Collections.emptyList();
        }
        try {
            return (List)objectMapper.readValue(src, objectMapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clazz}));
        }
        catch (Exception e) {
            log.error("JsonUtil jsonConvertToList fail error=", (Throwable)e);
            return Collections.emptyList();
        }
    }

    static {
        objectMapper.setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.registerModule((Module)new JavaTimeModule());
    }
}

