/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.easytool.core;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUtil {
    private static final Logger log = LoggerFactory.getLogger(ListUtil.class);

    public static <T> List<List<T>> splitByInsideListSize(List<T> list, int splitSize) {
        if (Objects.isNull(list) || list.size() < 1) {
            return Collections.emptyList();
        }
        if (splitSize < 1) {
            return Collections.singletonList(list);
        }
        int maxSize = (list.size() + splitSize - 1) / splitSize;
        return Stream.iterate(0, n -> n + 1).limit(maxSize).map(a -> list.stream().skip((long)a.intValue() * (long)splitSize).limit(splitSize).collect(Collectors.toList())).filter(b -> !b.isEmpty()).collect(Collectors.toList());
    }

    public static <T> List<List<T>> splitByOutsideListSize(List<T> list, int splitSize) {
        if (Objects.isNull(list) || list.size() < 1) {
            return Collections.emptyList();
        }
        if (splitSize < 2) {
            return Collections.singletonList(list);
        }
        int maxSize = (list.size() + splitSize - 1) / splitSize;
        return Stream.iterate(0, n -> n + 1).limit(splitSize).map(a -> list.stream().skip((long)a.intValue() * (long)maxSize).limit(maxSize).collect(Collectors.toList())).filter(b -> !b.isEmpty()).collect(Collectors.toList());
    }
}

