/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.easytool.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtil {
    private static final Logger log = LoggerFactory.getLogger(MapUtil.class);

    public static <T> Map<String, Object> objectToMap(T obj) {
        if (Objects.isNull(obj)) {
            return Collections.emptyMap();
        }
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields) {
                field.setAccessible(true);
                map.put(field.getName(), field.get(obj));
            }
            return map;
        }
        catch (Exception e) {
            log.error("MapUtil objectToMap fail error=", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> clazz) {
        if (Objects.isNull(map)) {
            return null;
        }
        try {
            Field[] fields;
            T obj = clazz.newInstance();
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                field.setAccessible(true);
                field.set(obj, map.get(field.getName()));
            }
            return obj;
        }
        catch (Exception e) {
            log.error("MapUtil mapToObject fail error=", (Throwable)e);
            return null;
        }
    }
}

