/*
 * Decompiled with CFR 0.152.
 */
package cc.jinhx.easytool.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeUtil {
    private static final Logger log = LoggerFactory.getLogger(TreeUtil.class);

    public static <T, R> List<T> listToTree(List<T> target, Function<T, R> getId, Function<T, R> getParentId, Function<T, List<T>> getChildList, BiConsumer<T, List<T>> setChildList) {
        Map targetMap = target.stream().collect(Collectors.toMap(getId, t -> t));
        ArrayList result = new ArrayList();
        target.forEach(tree -> {
            Object parent = targetMap.get(getParentId.apply(tree));
            if (Objects.isNull(parent)) {
                result.add(tree);
            } else {
                ArrayList<Object> ch = (ArrayList<Object>)getChildList.apply(parent);
                if (Objects.isNull(ch)) {
                    ch = new ArrayList<Object>();
                }
                ch.add(tree);
                setChildList.accept(parent, ch);
            }
        });
        return result;
    }
}

