/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.handler.codec.base64;

import cc.otavia.buffer.Buffer;
import cc.otavia.buffer.BufferAllocator;
import cc.otavia.buffer.BufferAllocator$;
import cc.otavia.handler.codec.base64.Base64;
import cc.otavia.handler.codec.base64.Base64$Decoder$;
import cc.otavia.handler.codec.base64.Base64Dialect;
import cc.otavia.handler.codec.base64.Base64Dialect$;
import java.io.Serializable;
import scala.runtime.ModuleSerializationProxy;

public final class Base64$
implements Serializable {
    private static final int MAX_LINE_LENGTH;
    public static final byte cc$otavia$handler$codec$base64$Base64$$$EQUALS_SIGN;
    private static final byte NEW_LINE;
    public static final int cc$otavia$handler$codec$base64$Base64$$$WHITE_SPACE_ENC;
    public static final int cc$otavia$handler$codec$base64$Base64$$$EQUALS_SIGN_ENC;
    public static final Base64$Decoder$ Decoder;
    public static final Base64$ MODULE$;

    private Base64$() {
    }

    static {
        MODULE$ = new Base64$();
        MAX_LINE_LENGTH = 76;
        cc$otavia$handler$codec$base64$Base64$$$EQUALS_SIGN = (byte)61;
        NEW_LINE = (byte)10;
        cc$otavia$handler$codec$base64$Base64$$$WHITE_SPACE_ENC = -5;
        cc$otavia$handler$codec$base64$Base64$$$EQUALS_SIGN_ENC = -1;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Base64$.class);
    }

    private byte[] alphabet(Base64Dialect dialect) {
        return dialect.alphabet();
    }

    public byte[] cc$otavia$handler$codec$base64$Base64$$$decodabet(Base64Dialect dialect) {
        return dialect.decodabet();
    }

    private boolean breakLines(Base64Dialect dialect) {
        return dialect.breakLinesByDefault();
    }

    public Buffer encode(Buffer src, Base64Dialect dialect) {
        return this.encode(src, this.breakLines(dialect), dialect);
    }

    public Base64Dialect encode$default$2() {
        return Base64Dialect$.STANDARD;
    }

    public Buffer encode(Buffer src, boolean breakLines) {
        return this.encode(src, breakLines, Base64Dialect$.STANDARD);
    }

    public Buffer encode(Buffer src, boolean breakLines, Base64Dialect dialect) {
        Buffer dest = this.encode(src, src.readerOffset(), src.readableBytes(), breakLines, dialect);
        src.readerOffset(src.writerOffset());
        return dest;
    }

    public Buffer encode(Buffer src, int off, int len) {
        return this.encode(src, off, len, Base64Dialect$.STANDARD);
    }

    public Buffer encode(Buffer src, int off, int len, Base64Dialect dialect) {
        return this.encode(src, off, len, this.breakLines(dialect), dialect);
    }

    public Buffer encode(Buffer src, int off, int len, boolean breakLines) {
        return this.encode(src, off, len, breakLines, Base64Dialect$.STANDARD);
    }

    public Buffer encode(Buffer src, int off, int len, boolean breakLines, Base64Dialect dialect) {
        BufferAllocator allocator = src.isDirect() ? BufferAllocator$.MODULE$.offHeapAllocator() : BufferAllocator$.MODULE$.onHeapAllocator();
        return this.encode(src, off, len, breakLines, dialect, allocator);
    }

    public void encode(Buffer src, Buffer dest) {
        this.encode(src, this.breakLines(Base64Dialect$.STANDARD), dest);
    }

    public void encode(Buffer src, boolean breakLines, Buffer dest) {
        this.encode(src, breakLines, Base64Dialect$.STANDARD, dest);
    }

    public void encode(Buffer src, boolean breakLines, Base64Dialect dialect, Buffer dest) {
        this.encode(src, src.readerOffset(), src.readableBytes(), breakLines, dialect, dest);
    }

    public Buffer encode(Buffer src, int off, int len, boolean breakLines, Base64Dialect dialect, BufferAllocator allocator) {
        Buffer dest = allocator.allocate(this.encodedBufferSize(len, breakLines));
        this.encode(src, off, len, breakLines, dialect, dest);
        return dest;
    }

    public void encode(Buffer src, int off, int len, boolean breakLines, Base64Dialect dialect, Buffer dest) {
        dest.ensureWritable(this.encodedBufferSize(len, breakLines));
        byte[] bytes = this.alphabet(dialect);
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            this.encode3to4(src, d + off, 3, dest, e, bytes);
            if (breakLines && (lineLength += 4) == MAX_LINE_LENGTH) {
                dest.setByte(e + 4, NEW_LINE);
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            this.encode3to4(src, d + off, len - d, dest, e, bytes);
            e += 4;
        }
        if (e > 1 && dest.getByte(e - 1) == NEW_LINE) {
            --e;
        }
        dest.writerOffset(e);
    }

    private void encode3to4(Buffer src, int srcOffset, int numSigBytes, Buffer dest, int destOffset, byte[] alphabet) {
        int inBuff = 0;
        int n = numSigBytes;
        inBuff = 1 == n ? this.toInt(src.getByte(srcOffset)) : (2 == n ? this.toIntBE(src.getShort(srcOffset)) : (numSigBytes <= 0 ? 0 : this.toIntBE(src.getMedium(srcOffset))));
        this.encode3to4BigEndian(inBuff, numSigBytes, dest, destOffset, alphabet);
    }

    private int encodedBufferSize(int len, boolean breakLines) {
        long len43 = ((long)len << 2) / 3L;
        long ret = len43 + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (breakLines) {
            ret += len43 / (long)MAX_LINE_LENGTH;
        }
        if (ret < Integer.MAX_VALUE) {
            return (int)ret;
        }
        return Integer.MAX_VALUE;
    }

    private int toInt(byte value) {
        return (value & 0xFF) << 16;
    }

    private int toIntBE(short value) {
        return (value & 0xFF00) << 8 | (value & 0xFF) << 8;
    }

    private int toIntBE(int mediumValue) {
        return mediumValue & 0xFF0000 | mediumValue & 0xFF00 | mediumValue & 0xFF;
    }

    private void encode3to4BigEndian(int inBuff, int numSigBytes, Buffer dest, int destOffset, byte[] alphabet) {
        int n = numSigBytes;
        switch (n) {
            case 3: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | alphabet[inBuff >>> 6 & 0x3F] << 8 | alphabet[inBuff & 0x3F]);
                return;
            }
            case 2: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | alphabet[inBuff >>> 6 & 0x3F] << 8 | cc$otavia$handler$codec$base64$Base64$$$EQUALS_SIGN);
                return;
            }
            case 1: {
                dest.setInt(destOffset, alphabet[inBuff >>> 18] << 24 | alphabet[inBuff >>> 12 & 0x3F] << 16 | cc$otavia$handler$codec$base64$Base64$$$EQUALS_SIGN << 8 | cc$otavia$handler$codec$base64$Base64$$$EQUALS_SIGN);
                return;
            }
        }
    }

    public Buffer decode(Buffer src) {
        return this.decode(src, Base64Dialect$.STANDARD);
    }

    public Buffer decode(Buffer src, Base64Dialect dialect) {
        Buffer dest = this.decode(src, src.readerOffset(), src.readableBytes(), dialect);
        src.readerOffset(src.writerOffset());
        return dest;
    }

    public Buffer decode(Buffer src, int off, int len) {
        return this.decode(src, off, len, Base64Dialect$.STANDARD);
    }

    public Buffer decode(Buffer src, int off, int len, Base64Dialect dialect) {
        BufferAllocator allocator = src.isDirect() ? BufferAllocator$.MODULE$.offHeapAllocator() : BufferAllocator$.MODULE$.onHeapAllocator();
        return this.decode(src, off, len, dialect, allocator);
    }

    public Buffer decode(Buffer src, int off, int len, Base64Dialect dialect, BufferAllocator allocator) {
        return new Base64.Decoder().decode(src, off, len, allocator, dialect);
    }

    public void decode(Buffer src, int off, int len, Base64Dialect dialect, Buffer dst) {
        new Base64.Decoder().decode(src, off, len, dst, dialect);
    }

    public int cc$otavia$handler$codec$base64$Base64$$$decodedBufferSize(int len) {
        return len - (len >>> 2);
    }
}

