/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.actor;

import cc.otavia.core.actor.AbstractActor$;
import cc.otavia.core.actor.Actor;
import cc.otavia.core.actor.ActorContext;
import cc.otavia.core.actor.ExceptionStrategy;
import cc.otavia.core.actor.ExceptionStrategy$;
import cc.otavia.core.address.Address;
import cc.otavia.core.cache.Poolable;
import cc.otavia.core.message.Ask;
import cc.otavia.core.message.AskTimeoutEvent;
import cc.otavia.core.message.Call;
import cc.otavia.core.message.ChannelTimeoutEvent;
import cc.otavia.core.message.Event;
import cc.otavia.core.message.ExceptionMessage;
import cc.otavia.core.message.ExceptionMessage$;
import cc.otavia.core.message.Notice;
import cc.otavia.core.message.ReactorEvent;
import cc.otavia.core.message.Reply;
import cc.otavia.core.message.TimeoutEvent;
import cc.otavia.core.message.TimeoutReply;
import cc.otavia.core.message.TimeoutReply$;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.stack.AbstractPromise;
import cc.otavia.core.stack.AskStack;
import cc.otavia.core.stack.AskStack$;
import cc.otavia.core.stack.BatchAskStack;
import cc.otavia.core.stack.BatchAskStack$;
import cc.otavia.core.stack.BatchNoticeStack;
import cc.otavia.core.stack.BatchNoticeStack$;
import cc.otavia.core.stack.ChannelPromise;
import cc.otavia.core.stack.ChannelStack;
import cc.otavia.core.stack.Future;
import cc.otavia.core.stack.FutureDispatcher;
import cc.otavia.core.stack.MessagePromise;
import cc.otavia.core.stack.NoticeStack;
import cc.otavia.core.stack.NoticeStack$;
import cc.otavia.core.stack.PromiseIterator;
import cc.otavia.core.stack.Stack;
import cc.otavia.core.stack.StackState;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public abstract class AbstractActor<M extends Call>
extends FutureDispatcher
implements Actor<M> {
    private Logger logger;
    private ActorContext ctx;
    private Object currentReceived;
    private Stack currentStack;
    private long revAsks;
    private long sendAsks;
    private long currentSendMessageId;
    private final Function1 batchNoticeFilter;
    private final Function1 batchAskFilter;

    public AbstractActor() {
        Actor.$init$(this);
        this.revAsks = 0L;
        this.sendAsks = 0L;
        this.currentSendMessageId = Long.MIN_VALUE;
        this.batchNoticeFilter = AbstractActor$.cc$otavia$core$actor$AbstractActor$$$TURE_FUNC;
        this.batchAskFilter = AbstractActor$.cc$otavia$core$actor$AbstractActor$$$TURE_FUNC;
    }

    public Logger logger() {
        return this.logger;
    }

    public void logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Object currentReceived() {
        return this.currentReceived;
    }

    public void currentReceived_$eq(Object x$1) {
        this.currentReceived = x$1;
    }

    public Stack currentStack() {
        return this.currentStack;
    }

    public void currentStack_$eq(Stack x$1) {
        this.currentStack = x$1;
    }

    public final float stackEndRate() {
        if (this.revAsks != 0L) {
            return (float)this.sendAsks / (float)this.revAsks;
        }
        return Float.MAX_VALUE;
    }

    public long generateSendMessageId() {
        long id = this.currentSendMessageId++;
        return id;
    }

    public Address<M> self() {
        return this.context().address();
    }

    public final void setCtx(ActorContext context) {
        this.ctx = context;
        this.logger_$eq(Logger$.MODULE$.getLogger(this.getClass(), this.ctx.system()));
    }

    @Override
    public final ActorContext context() {
        return this.ctx;
    }

    public final void mount() {
        try {
            this.afterMount();
        }
        catch (Throwable t) {
            this.logger().error("afterMount error with", t);
        }
    }

    public void attachStack(long askId, Future<?> future) {
        AbstractPromise promise = (AbstractPromise)future.promise();
        promise.setStack(this.currentStack());
        promise.setId(askId);
        this.currentStack().addUncompletedPromise(promise);
        AbstractPromise abstractPromise = promise;
        if (abstractPromise instanceof MessagePromise) {
            MessagePromise promise2 = (MessagePromise)abstractPromise;
            ++this.sendAsks;
            if (!promise2.notInChain()) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"The ReplyFuture has been used, can't be use again!");
            }
            this.push(promise2);
            return;
        }
        if (abstractPromise instanceof ChannelPromise) {
            ChannelPromise promise3 = (ChannelPromise)abstractPromise;
            if (!promise3.notInChain()) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"The ChannelPromise has been used, can't be use again!");
            }
            return;
        }
    }

    public final void receiveFuture(Future<?> future) {
        AbstractPromise promise = (AbstractPromise)future.promise();
        Stack stack = future.promise().actorStack();
        this.handlePromiseCompleted(stack, promise);
    }

    @Override
    public final void receiveNotice(Notice notice) {
        this.currentReceived_$eq(notice);
        NoticeStack<Notice> stack = NoticeStack$.MODULE$.apply(this);
        stack.setNotice(notice);
        this.dispatchNoticeStack(stack);
        this.currentReceived_$eq(null);
    }

    @Override
    public final void receiveBatchNotice(Seq<Notice> notices) {
        this.currentReceived_$eq(notices);
        BatchNoticeStack<Notice> stack = BatchNoticeStack$.MODULE$.apply(this);
        stack.setNotices(notices);
        this.dispatchBatchNoticeStack(stack);
        this.currentReceived_$eq(null);
    }

    @Override
    public final void receiveAsk(Ask<? extends Reply> ask) {
        ++this.revAsks;
        this.currentReceived_$eq(ask);
        AskStack<Ask<? extends Reply>> stack = AskStack$.MODULE$.apply(this);
        stack.setAsk(ask);
        this.dispatchAskStack(stack);
        this.currentReceived_$eq(null);
    }

    @Override
    public final void receiveBatchAsk(Seq<Ask<?>> asks) {
        this.currentReceived_$eq(asks);
        BatchAskStack<Ask<? extends Reply>> stack = BatchAskStack$.MODULE$.apply(this);
        stack.setAsks(asks);
        this.dispatchBatchAskStack(stack);
        this.currentReceived_$eq(null);
    }

    @Override
    public final void receiveReply(Reply reply) {
        if (!reply.isBatch()) {
            if (this.contains(reply.replyId())) {
                MessagePromise<?> promise = this.pop(reply.replyId());
                if (promise.canTimeout()) {
                    this.system().timer().cancelTimerTask(promise.timeoutId());
                }
                this.receiveReply0(reply, promise);
                return;
            }
            return;
        }
        reply.replyIds().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long senderId = tuple2._1$mcJ$sp();
                long rid = tuple2._2$mcJ$sp();
                return true;
            }
            return false;
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long senderId = BoxesRunTime.unboxToLong((Object)tuple2._1());
                long rid = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return senderId == this.actorId() && this.contains(rid);
            }
            throw new MatchError((Object)tuple2);
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long senderId = tuple2._1$mcJ$sp();
                long rid = tuple2._2$mcJ$sp();
                MessagePromise<?> promise = this.pop(rid);
                if (promise.canTimeout()) {
                    this.system().timer().cancelTimerTask(promise.timeoutId());
                }
                this.receiveReply0(reply, promise);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private void receiveReply0(Reply reply, MessagePromise<?> promise) {
        this.currentReceived_$eq(reply);
        Reply reply2 = reply;
        if (reply2 instanceof ExceptionMessage) {
            ExceptionMessage message = (ExceptionMessage)reply2;
            promise.setFailure(message);
        } else {
            promise.setSuccess(reply);
        }
        Stack stack = promise.actorStack();
        this.handlePromiseCompleted(stack, promise);
        this.currentReceived_$eq(null);
    }

    @Override
    public final void receiveEvent(Event event) {
        Event event2 = event;
        if (event2 instanceof AskTimeoutEvent) {
            AskTimeoutEvent event3 = (AskTimeoutEvent)event2;
            this.dispatchAskTimeoutEvent(event3);
            return;
        }
        if (event2 instanceof TimeoutEvent) {
            TimeoutEvent event4 = (TimeoutEvent)event2;
            this.handleActorTimeout(event4);
            return;
        }
        if (event2 instanceof ChannelTimeoutEvent) {
            ChannelTimeoutEvent event5 = (ChannelTimeoutEvent)event2;
            this.receiveChannelTimeoutEvent(event5);
            return;
        }
        if (event2 instanceof ReactorEvent) {
            ReactorEvent event6 = (ReactorEvent)event2;
            this.receiveReactorEvent(event6);
            return;
        }
    }

    private void dispatchNoticeStack(NoticeStack<Notice> stack) {
        this.currentStack_$eq(stack);
        try {
            try {
                StackState oldState = stack.state();
                this.switchState(stack, oldState, this.resumeNotice(stack));
            }
            catch (Throwable cause) {
                cause.printStackTrace();
                this.handleNoticeException(stack, cause);
                this.recycleStack(stack);
            }
        }
        finally {
            this.currentStack_$eq(null);
        }
    }

    private void dispatchBatchNoticeStack(BatchNoticeStack<Notice> stack) {
        this.currentStack_$eq(stack);
        try {
            try {
                StackState oldState = stack.state();
                this.switchState(stack, oldState, this.resumeBatchNotice(stack));
            }
            catch (Throwable cause) {
                this.handleNoticeException(stack, cause);
                this.recycleStack(stack);
            }
        }
        finally {
            this.currentStack_$eq(null);
        }
    }

    private void dispatchAskStack(AskStack<Ask<? extends Reply>> stack) {
        this.currentStack_$eq(stack);
        try {
            try {
                StackState oldState = stack.state();
                this.switchState(stack, oldState, this.resumeAsk(stack));
            }
            catch (Throwable cause) {
                cause.printStackTrace();
                stack.throw(ExceptionMessage$.MODULE$.apply(cause));
                this.recycleStack(stack);
            }
        }
        finally {
            this.currentStack_$eq(null);
        }
    }

    private void dispatchBatchAskStack(BatchAskStack<Ask<? extends Reply>> stack) {
        this.currentStack_$eq(stack);
        try {
            try {
                StackState oldState = stack.state();
                this.switchState(stack, oldState, this.resumeBatchAsk(stack));
            }
            catch (Throwable cause) {
                stack.throw(ExceptionMessage$.MODULE$.apply(cause));
                this.recycleStack(stack);
            }
        }
        finally {
            this.currentStack_$eq(null);
        }
    }

    private void dispatchAskTimeoutEvent(AskTimeoutEvent timeoutEvent) {
        MessagePromise<?> promise = this.pop(timeoutEvent.askId());
        if (promise != null) {
            if (promise.canTimeout()) {
                promise.setFailure(new TimeoutException());
            } else {
                TimeoutReply timeoutReply = TimeoutReply$.MODULE$.apply();
                timeoutReply.setReplyId(promise.id());
                promise.setSuccess(TimeoutReply$.MODULE$.apply());
            }
            Stack stack = promise.actorStack();
            this.handlePromiseCompleted(stack, promise);
            return;
        }
    }

    private void handlePromiseCompleted(Stack stack, AbstractPromise<?> promise) {
        stack.moveCompletedPromise(promise);
        if (stack.state().resumable() || !stack.hasUncompletedPromise()) {
            Stack stack2 = stack;
            if (stack2 instanceof AskStack) {
                AskStack stack3 = (AskStack)stack2;
                this.dispatchAskStack(stack3);
                return;
            }
            if (stack2 instanceof NoticeStack) {
                NoticeStack stack4 = (NoticeStack)stack2;
                this.dispatchNoticeStack(stack4);
                return;
            }
            if (stack2 instanceof BatchAskStack) {
                BatchAskStack s = (BatchAskStack)stack2;
                this.dispatchBatchAskStack(s);
                return;
            }
            if (stack2 instanceof BatchNoticeStack) {
                BatchNoticeStack s = (BatchNoticeStack)stack2;
                this.dispatchBatchNoticeStack(s);
                return;
            }
            if (stack2 instanceof ChannelStack) {
                ChannelStack stack5 = (ChannelStack)stack2;
                this.dispatchChannelStack(stack5);
                return;
            }
            return;
        }
    }

    public final void switchState(Stack stack, StackState oldState, Option<StackState> newState) {
        Option<StackState> option = newState;
        if (option instanceof Some) {
            StackState state = (StackState)((Some)option).value();
            StackState stackState = oldState;
            StackState stackState2 = state;
            if (stackState == null ? stackState2 != null : !stackState.equals(stackState2)) {
                stack.setState(state);
                StackState stackState3 = oldState;
                if (stackState3 instanceof Poolable) {
                    Poolable state2 = (Poolable)((Object)stackState3);
                    state2.recycle();
                }
            }
            if (!stack.hasUncompletedPromise()) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(26).append("has no future to wait for ").append(stack).toString());
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            StackState stackState = oldState;
            if (stackState instanceof Poolable) {
                Poolable state = (Poolable)((Object)stackState);
                state.recycle();
            }
            if (!stack.isDone()) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"None but not call return method of Stack!");
            }
            if (!(stack instanceof ChannelStack)) {
                this.recycleStack(stack);
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    private void recycleUncompletedPromise(PromiseIterator uncompleted) {
        while (uncompleted.hasNext()) {
            Object promise = uncompleted.next();
            this.pop(((AbstractPromise)promise).id());
            promise.recycle();
        }
    }

    public final void recycleStack(Stack stack) {
        if (stack.hasUncompletedPromise()) {
            this.recycleUncompletedPromise(stack.uncompletedPromises());
        }
        stack.recycle();
    }

    public void handleNoticeException(Stack stack, Throwable e) {
        String string;
        Stack stack2 = stack;
        if (stack2 instanceof NoticeStack) {
            NoticeStack s = (NoticeStack)stack2;
            string = new StringBuilder(50).append("Stack with call message ").append(s.notice()).append(" failed at handle ").append(this.currentReceived()).append(" message").toString();
        } else if (stack2 instanceof BatchNoticeStack) {
            BatchNoticeStack s = (BatchNoticeStack)stack2;
            string = new StringBuilder(50).append("Stack with call message ").append(s.notices()).append(" failed at handle ").append(this.currentReceived()).append(" message").toString();
        } else {
            string = "";
        }
        String log = string;
        ExceptionStrategy exceptionStrategy = this.noticeExceptionStrategy();
        ExceptionStrategy exceptionStrategy2 = ExceptionStrategy$.Restart;
        ExceptionStrategy exceptionStrategy3 = exceptionStrategy;
        if (!(exceptionStrategy2 != null ? !exceptionStrategy2.equals(exceptionStrategy3) : exceptionStrategy3 != null)) {
            this.logger().error(log, e);
            try {
                this.beforeRestart();
                this.restart();
                this.afterRestart();
            }
            catch (Exception exception) {
                this.logger().error("Fatal error on restart", exception);
                this.system().shutdown();
            }
            return;
        }
        ExceptionStrategy exceptionStrategy4 = ExceptionStrategy$.Ignore;
        ExceptionStrategy exceptionStrategy5 = exceptionStrategy;
        if (!(exceptionStrategy4 != null ? !exceptionStrategy4.equals(exceptionStrategy5) : exceptionStrategy5 != null)) {
            this.logger().error(log, e);
            return;
        }
        ExceptionStrategy exceptionStrategy6 = ExceptionStrategy$.ShutdownSystem;
        ExceptionStrategy exceptionStrategy7 = exceptionStrategy;
        if (!(exceptionStrategy6 != null ? !exceptionStrategy6.equals(exceptionStrategy7) : exceptionStrategy7 != null)) {
            this.logger().error(log, e);
            this.system().shutdown();
            return;
        }
        throw new MatchError((Object)exceptionStrategy);
    }

    public abstract void dispatchChannelStack(ChannelStack<?> var1);

    public void receiveReactorEvent(ReactorEvent event) {
    }

    public void receiveChannelTimeoutEvent(ChannelTimeoutEvent event) {
    }

    public Option<StackState> resumeAsk(AskStack<Ask<? extends Reply>> stack) {
        throw new NotImplementedError(new StringBuilder(30).append(this.getClass().getName()).append(": an implementation is missing").toString());
    }

    public Option<StackState> resumeNotice(NoticeStack<Notice> stack) {
        throw new NotImplementedError(new StringBuilder(30).append(this.getClass().getName()).append(": an implementation is missing").toString());
    }

    public boolean batchable() {
        return false;
    }

    public int maxBatchSize() {
        return this.system().defaultMaxBatchSize();
    }

    public Function1<Notice, Object> batchNoticeFilter() {
        return this.batchNoticeFilter;
    }

    public Function1<Ask<?>, Object> batchAskFilter() {
        return this.batchAskFilter;
    }

    public Option<StackState> resumeBatchNotice(BatchNoticeStack<Notice> stack) {
        throw new NotImplementedError(new StringBuilder(30).append(this.getClass().getName()).append(": an implementation is missing").toString());
    }

    public Option<StackState> resumeBatchAsk(BatchAskStack<Ask<? extends Reply>> stack) {
        throw new NotImplementedError(new StringBuilder(30).append(this.getClass().getName()).append(": an implementation is missing").toString());
    }

    public void handleActorTimeout(TimeoutEvent timeoutEvent) {
    }
}

