/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.actor;

import cc.otavia.core.actor.AbstractActor;
import cc.otavia.core.actor.Actor;
import cc.otavia.core.actor.ChannelsActor$Bind$;
import cc.otavia.core.actor.ChannelsActor$ChannelEstablished$;
import cc.otavia.core.address.ActorAddress;
import cc.otavia.core.address.Address;
import cc.otavia.core.channel.AbstractChannel;
import cc.otavia.core.channel.AbstractNetworkChannel;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelAddress;
import cc.otavia.core.channel.ChannelInitializer;
import cc.otavia.core.message.Ask;
import cc.otavia.core.message.Call;
import cc.otavia.core.message.ChannelTimeoutEvent;
import cc.otavia.core.message.ReactorEvent;
import cc.otavia.core.message.Reply;
import cc.otavia.core.reactor.Reactor;
import cc.otavia.core.stack.ChannelFuture;
import cc.otavia.core.stack.ChannelStack;
import cc.otavia.core.stack.StackState;
import cc.otavia.core.stack.helper.ChannelFutureState;
import cc.otavia.core.stack.helper.ChannelFutureState$;
import cc.otavia.core.system.ActorThread;
import cc.otavia.core.util.Nextable;
import java.io.File;
import java.net.InetAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class ChannelsActor<M extends Call>
extends AbstractActor<M> {
    private int channelCursor = 0;
    private Object currentChannelReceived;

    @Override
    public ActorAddress<M> self() {
        return (ActorAddress)super.self();
    }

    public ActorAddress<M> address() {
        return this.self();
    }

    public final Reactor reactor() {
        return this.system().reactor();
    }

    public ProtocolFamily family() {
        return StandardProtocolFamily.INET;
    }

    public int generateChannelId() {
        int channelId = this.channelCursor++;
        return channelId;
    }

    public void receiveChannelMessage(ChannelStack<?> stack) {
        this.currentChannelReceived = stack.message();
        this.dispatchChannelStack(stack);
        this.currentChannelReceived = null;
    }

    @Override
    public final void dispatchChannelStack(ChannelStack<?> stack) {
        this.currentStack_$eq(stack);
        try {
            try {
                StackState oldState = stack.state();
                Option<StackState> newState = this.resumeChannelStack(stack);
                this.switchState(stack, oldState, newState);
                if (newState.isEmpty()) {
                    stack.internalChannel().processCompletedChannelStacks();
                }
            }
            catch (Throwable cause) {
                cause.printStackTrace();
                stack.return(cause);
                stack.internalChannel().processCompletedChannelStacks();
            }
        }
        finally {
            this.currentStack_$eq(null);
        }
    }

    @Override
    public final void receiveReactorEvent(ReactorEvent event) {
        ReactorEvent reactorEvent = event;
        if (reactorEvent instanceof ReactorEvent.RegisterReply) {
            ReactorEvent.RegisterReply e = (ReactorEvent.RegisterReply)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelRegisterReplyEvent(e);
            this.afterChannelRegistered(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.DeregisterReply) {
            ReactorEvent.DeregisterReply e = (ReactorEvent.DeregisterReply)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelDeregisterReplyEvent(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.ChannelClose) {
            ReactorEvent.ChannelClose e = (ReactorEvent.ChannelClose)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelCloseEvent(e);
            this.afterChannelClosed(e.channel(), e.cause());
            return;
        }
        if (reactorEvent instanceof ReactorEvent.ChannelReadiness) {
            ReactorEvent.ChannelReadiness e = (ReactorEvent.ChannelReadiness)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelReadinessEvent(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.AcceptedEvent) {
            ReactorEvent.AcceptedEvent e = (ReactorEvent.AcceptedEvent)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelAcceptedEvent(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.ReadCompletedEvent) {
            ReactorEvent.ReadCompletedEvent e = (ReactorEvent.ReadCompletedEvent)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelReadCompletedEvent(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.BindReply) {
            ReactorEvent.BindReply e = (ReactorEvent.BindReply)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelBindReplyEvent(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.ConnectReply) {
            ReactorEvent.ConnectReply e = (ReactorEvent.ConnectReply)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelConnectReplyEvent(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.ReadBuffer) {
            ReactorEvent.ReadBuffer e = (ReactorEvent.ReadBuffer)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelReadBufferEvent(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.OpenReply) {
            ReactorEvent.OpenReply e = (ReactorEvent.OpenReply)reactorEvent;
            ((AbstractChannel)e.channel()).handleChannelOpenReplyEvent(e);
            return;
        }
        if (reactorEvent instanceof ReactorEvent.ShutdownReply) {
            ReactorEvent.ShutdownReply e = (ReactorEvent.ShutdownReply)reactorEvent;
            ((AbstractNetworkChannel)e.channel()).handleShutdownReply(e);
            return;
        }
        throw new MatchError((Object)reactorEvent);
    }

    @Override
    public final void receiveChannelTimeoutEvent(ChannelTimeoutEvent event) {
        AbstractChannel channel = (AbstractChannel)event.channel();
        channel.handleChannelTimeoutEvent(event.registerId());
    }

    public final ChannelAddress createChannelAndInit() throws Exception {
        Channel channel;
        Channel channel2 = this.newChannel();
        channel2.mount(this);
        try {
            this.initChannel(channel2);
            channel = channel2;
        }
        catch (Throwable cause) {
            channel2.closeAfterCreate();
            throw cause;
        }
        return channel;
    }

    public final ChannelAddress createFileChannelAndInit() throws Exception {
        Channel channel;
        Channel channel2 = this.system().channelFactory().openFileChannel();
        channel2.mount(this);
        try {
            this.initFileChannel(channel2);
            channel = channel2;
        }
        catch (Throwable cause) {
            channel2.closeAfterCreate();
            throw cause;
        }
        return channel;
    }

    public final Option<ChannelFutureState> openFileChannelAndSuspend(Path path, Seq<OpenOption> opts, Seq<FileAttribute<?>> attrs) {
        ChannelAddress channel = this.createFileChannelAndInit();
        ChannelFutureState state = ChannelFutureState$.MODULE$.apply();
        ChannelFuture future = state.future();
        channel.open(path, opts, attrs, future);
        return state.suspend();
    }

    public final Option<ChannelFutureState> openFileChannelAndSuspend(File file, Seq<OpenOption> opts, Seq<FileAttribute<?>> attrs) {
        ChannelAddress channel = this.createFileChannelAndInit();
        ChannelFutureState state = ChannelFutureState$.MODULE$.apply();
        ChannelFuture future = state.future();
        channel.open(file, opts, attrs, future);
        return state.suspend();
    }

    public final boolean inExecutor() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ActorThread) {
            ActorThread thread2 = (ActorThread)thread;
            Actor<?> actor = thread2.currentRunningActor();
            ChannelsActor channelsActor = this;
            return !(actor != null ? !actor.equals(channelsActor) : channelsActor != null);
        }
        return false;
    }

    public Option<StackState> resumeChannelStack(ChannelStack<Object> stack) {
        throw new NotImplementedError(new StringBuilder(30).append(this.getClass().getName()).append(": an implementation is missing").toString());
    }

    public void afterChannelClosed(Channel channel, Option<Throwable> cause) {
    }

    public void afterChannelRegistered(ReactorEvent.RegisterReply event) {
    }

    public Channel newChannel() {
        throw new NotImplementedError(new StringBuilder(41).append(this.getClass().getName()).append(".newChannel: an implementation is missing").toString());
    }

    public void initChannel(Channel channel) throws Exception {
        Option<ChannelInitializer<Channel>> option = this.handler();
        if (option instanceof Some) {
            ChannelInitializer h = (ChannelInitializer)((Some)option).value();
            channel.pipeline().addLast(h);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void initFileChannel(Channel channel) {
    }

    public Option<ChannelInitializer<? extends Channel>> handler() {
        return None$.MODULE$;
    }

    public static class Bind
    implements Ask<ChannelEstablished>,
    Product {
        private volatile Nextable cc$otavia$core$util$Nextable$$n;
        private Address cc$otavia$core$message$Ask$$address;
        private long cc$otavia$core$message$Ask$$sid;
        private long cc$otavia$core$message$Ask$$mid;
        private final SocketAddress local;

        public static Bind apply(InetAddress inetAddress, int n) {
            return ChannelsActor$Bind$.MODULE$.apply(inetAddress, n);
        }

        public static Bind apply(int n) {
            return ChannelsActor$Bind$.MODULE$.apply(n);
        }

        public static Bind apply(SocketAddress socketAddress) {
            return ChannelsActor$Bind$.MODULE$.apply(socketAddress);
        }

        public static Bind apply(String string, int n) {
            return ChannelsActor$Bind$.MODULE$.apply(string, n);
        }

        public static Bind fromProduct(Product product) {
            return ChannelsActor$Bind$.MODULE$.fromProduct(product);
        }

        public static Bind unapply(Bind bind) {
            return ChannelsActor$Bind$.MODULE$.unapply(bind);
        }

        public Bind(SocketAddress local) {
            this.local = local;
            Nextable.$init$(this);
            Ask.$init$(this);
        }

        @Override
        public Nextable cc$otavia$core$util$Nextable$$n() {
            return this.cc$otavia$core$util$Nextable$$n;
        }

        @Override
        public void cc$otavia$core$util$Nextable$$n_$eq(Nextable x$1) {
            this.cc$otavia$core$util$Nextable$$n = x$1;
        }

        @Override
        public Address cc$otavia$core$message$Ask$$address() {
            return this.cc$otavia$core$message$Ask$$address;
        }

        @Override
        public long cc$otavia$core$message$Ask$$sid() {
            return this.cc$otavia$core$message$Ask$$sid;
        }

        @Override
        public long cc$otavia$core$message$Ask$$mid() {
            return this.cc$otavia$core$message$Ask$$mid;
        }

        @Override
        public void cc$otavia$core$message$Ask$$address_$eq(Address x$1) {
            this.cc$otavia$core$message$Ask$$address = x$1;
        }

        @Override
        public void cc$otavia$core$message$Ask$$sid_$eq(long x$1) {
            this.cc$otavia$core$message$Ask$$sid = x$1;
        }

        @Override
        public void cc$otavia$core$message$Ask$$mid_$eq(long x$1) {
            this.cc$otavia$core$message$Ask$$mid = x$1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Bind)) return false;
            Bind bind = (Bind)object;
            SocketAddress socketAddress = this.local();
            SocketAddress socketAddress2 = bind.local();
            if (socketAddress == null) {
                if (socketAddress2 != null) {
                    return false;
                }
            } else if (!socketAddress.equals(socketAddress2)) return false;
            if (!bind.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Bind;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Bind";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "local";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SocketAddress local() {
            return this.local;
        }

        public Bind copy(SocketAddress local) {
            return new Bind(local);
        }

        public SocketAddress copy$default$1() {
            return this.local();
        }

        public SocketAddress _1() {
            return this.local();
        }
    }

    public static class ChannelEstablished
    implements Nextable,
    Reply,
    Product {
        private volatile Nextable cc$otavia$core$util$Nextable$$n;
        private long cc$otavia$core$message$Reply$$sid;
        private long cc$otavia$core$message$Reply$$rid;
        private Seq cc$otavia$core$message$Reply$$rids;
        private boolean cc$otavia$core$message$Reply$$batch;
        private boolean cc$otavia$core$message$Reply$$bound;
        private final int channelId;

        public static ChannelEstablished apply(int n) {
            return ChannelsActor$ChannelEstablished$.MODULE$.apply(n);
        }

        public static ChannelEstablished fromProduct(Product product) {
            return ChannelsActor$ChannelEstablished$.MODULE$.fromProduct(product);
        }

        public static ChannelEstablished unapply(ChannelEstablished channelEstablished) {
            return ChannelsActor$ChannelEstablished$.MODULE$.unapply(channelEstablished);
        }

        public ChannelEstablished(int channelId) {
            this.channelId = channelId;
            Nextable.$init$(this);
            Reply.$init$(this);
        }

        @Override
        public Nextable cc$otavia$core$util$Nextable$$n() {
            return this.cc$otavia$core$util$Nextable$$n;
        }

        @Override
        public void cc$otavia$core$util$Nextable$$n_$eq(Nextable x$1) {
            this.cc$otavia$core$util$Nextable$$n = x$1;
        }

        @Override
        public long cc$otavia$core$message$Reply$$sid() {
            return this.cc$otavia$core$message$Reply$$sid;
        }

        @Override
        public long cc$otavia$core$message$Reply$$rid() {
            return this.cc$otavia$core$message$Reply$$rid;
        }

        public Seq cc$otavia$core$message$Reply$$rids() {
            return this.cc$otavia$core$message$Reply$$rids;
        }

        @Override
        public boolean cc$otavia$core$message$Reply$$batch() {
            return this.cc$otavia$core$message$Reply$$batch;
        }

        @Override
        public boolean cc$otavia$core$message$Reply$$bound() {
            return this.cc$otavia$core$message$Reply$$bound;
        }

        @Override
        public void cc$otavia$core$message$Reply$$sid_$eq(long x$1) {
            this.cc$otavia$core$message$Reply$$sid = x$1;
        }

        @Override
        public void cc$otavia$core$message$Reply$$rid_$eq(long x$1) {
            this.cc$otavia$core$message$Reply$$rid = x$1;
        }

        public void cc$otavia$core$message$Reply$$rids_$eq(Seq x$1) {
            this.cc$otavia$core$message$Reply$$rids = x$1;
        }

        @Override
        public void cc$otavia$core$message$Reply$$batch_$eq(boolean x$1) {
            this.cc$otavia$core$message$Reply$$batch = x$1;
        }

        @Override
        public void cc$otavia$core$message$Reply$$bound_$eq(boolean x$1) {
            this.cc$otavia$core$message$Reply$$bound = x$1;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.channelId());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ChannelEstablished)) return false;
            ChannelEstablished channelEstablished = (ChannelEstablished)object;
            if (this.channelId() != channelEstablished.channelId()) return false;
            if (!channelEstablished.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ChannelEstablished;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ChannelEstablished";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "channelId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int channelId() {
            return this.channelId;
        }

        public ChannelEstablished copy(int channelId) {
            return new ChannelEstablished(channelId);
        }

        public int copy$default$1() {
            return this.channelId();
        }

        public int _1() {
            return this.channelId();
        }
    }
}

