/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.address;

import cc.otavia.core.actor.AbstractActor;
import cc.otavia.core.address.Address;
import cc.otavia.core.message.Ask;
import cc.otavia.core.message.Call;
import cc.otavia.core.message.Event;
import cc.otavia.core.message.Notice;
import cc.otavia.core.message.Reply;
import cc.otavia.core.stack.MessageFuture;
import cc.otavia.core.stack.MessagePromise;
import cc.otavia.core.system.ActorHouse;
import cc.otavia.core.timer.TimeoutTrigger$DelayTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class PhysicalAddress<M extends Call>
implements Address<M> {
    public abstract ActorHouse house();

    @Override
    public <A extends Ask<? extends Reply> & M> MessageFuture<Reply> ask(A ask, MessageFuture<Reply> future, AbstractActor<?> sender) {
        ask.setAskContext(sender);
        sender.attachStack(ask.askId(), future);
        this.house().putAsk(ask);
        return future;
    }

    @Override
    public MessageFuture<?> askUnsafe(Ask<?> ask, MessageFuture<?> f, AbstractActor<?> sender) {
        ask.setAskContext(sender);
        sender.attachStack(ask.askId(), f);
        this.house().putAsk(ask);
        return f;
    }

    @Override
    public <A extends Ask<? extends Reply> & M> MessageFuture<Reply> ask(A ask, MessageFuture<Reply> future, long timeout, AbstractActor<?> sender) {
        this.ask(ask, future, sender);
        MessagePromise<Reply> promise = future.promise();
        long id = sender.timer().registerAskTimeout(TimeoutTrigger$DelayTime$.MODULE$.apply(timeout, TimeoutTrigger$DelayTime$.MODULE$.$lessinit$greater$default$2()), sender.self(), ask.askId());
        promise.setTimeoutId(id);
        return future;
    }

    @Override
    public void notice(Notice notice) {
        this.house().putNotice(notice);
    }

    @Override
    public void reply(Reply reply, AbstractActor<?> sender) {
        this.house().putReply(reply);
    }

    @Override
    public void inform(Event event) {
        this.house().putEvent(event);
    }
}

