/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.address;

import cc.otavia.core.actor.AbstractActor;
import cc.otavia.core.address.Address;
import cc.otavia.core.address.ProxyAddress;
import cc.otavia.core.message.Ask;
import cc.otavia.core.message.Call;
import cc.otavia.core.message.Notice;
import cc.otavia.core.message.Reply;
import cc.otavia.core.stack.MessageFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RobinAddress<M extends Call>
implements ProxyAddress<M> {
    private final Address[] underlying;
    private int noticeCursor;
    private int askCursor;

    public RobinAddress(Address<M>[] underlying) {
        this.underlying = underlying;
        this.noticeCursor = 0;
        this.askCursor = 0;
    }

    public Address<M>[] underlying() {
        return this.underlying;
    }

    @Override
    public void notice(Notice notice) {
        int index = this.noticeCursor % this.underlying().length;
        ++this.noticeCursor;
        this.underlying()[index].notice(notice);
    }

    @Override
    public <A extends Ask<? extends Reply> & M> MessageFuture<Reply> ask(A ask, MessageFuture<Reply> future, AbstractActor<? extends Call> sender) {
        Address<M> address = this.getAddress();
        return address.ask(ask, future, (AbstractActor<?>)sender);
    }

    @Override
    public MessageFuture<?> askUnsafe(Ask<?> ask, MessageFuture<?> f, AbstractActor<?> sender) {
        Address<M> addr = this.getAddress();
        return addr.askUnsafe(ask, f, sender);
    }

    @Override
    public <A extends Ask<? extends Reply> & M> MessageFuture<Reply> ask(A ask, MessageFuture<Reply> f, long timeout, AbstractActor<? extends Call> sender) {
        Address<M> address = this.getAddress();
        return address.ask(ask, f, timeout, sender);
    }

    private final Address<M> getAddress() {
        int index = this.askCursor % this.underlying().length;
        ++this.askCursor;
        return this.underlying()[index];
    }

    @Override
    public void reply(Reply reply, AbstractActor<? extends Call> sender) {
        throw new UnsupportedOperationException("");
    }
}

