/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.cache;

import cc.otavia.core.cache.ActorThreadLocal;
import cc.otavia.core.cache.ObjectPool;
import cc.otavia.core.cache.Poolable;
import cc.otavia.core.cache.ResourceTimer;
import cc.otavia.core.cache.SingleThreadPoolableHolder;
import cc.otavia.core.cache.SingleThreadPoolableHolder$;
import cc.otavia.core.cache.ThreadLocalTimer;
import cc.otavia.core.timer.TimeoutTrigger;
import scala.Option;

public abstract class AbstractThreadIsolatedObjectPool<T extends Poolable>
extends ObjectPool<T> {
    public abstract SingleThreadPoolableHolder<T> holder();

    public abstract boolean dropIfRecycleNotByCreated();

    @Override
    public T get() {
        SingleThreadPoolableHolder<T> h = this.holder();
        Poolable pop = h.pop();
        if (pop != null) {
            return (T)pop;
        }
        return this.newInstance();
    }

    @Override
    public void recycle(T poolable) {
        poolable.clean();
        if (this.dropIfRecycleNotByCreated()) {
            Thread thread = poolable.creator();
            Thread thread2 = Thread.currentThread();
            if (!(thread != null ? !thread.equals(thread2) : thread2 != null)) {
                this.holder().push(poolable);
                return;
            }
            return;
        }
        this.holder().push(poolable);
    }

    public abstract Option<TimeoutTrigger> timeoutTrigger();

    public abstract void handleTimeout(long var1, ThreadLocalTimer var3);

    public static class ObjectPoolThreadLocal<T extends Poolable>
    extends ActorThreadLocal<SingleThreadPoolableHolder<T>> {
        private final AbstractThreadIsolatedObjectPool parent;

        public ObjectPoolThreadLocal(AbstractThreadIsolatedObjectPool<T> parent) {
            this.parent = parent;
        }

        public AbstractThreadIsolatedObjectPool<T> parent() {
            return this.parent;
        }

        @Override
        public SingleThreadPoolableHolder<T> initialValue() {
            return new SingleThreadPoolableHolder(SingleThreadPoolableHolder$.MODULE$.$lessinit$greater$default$1());
        }

        @Override
        public final Option<TimeoutTrigger> initialTimeoutTrigger() {
            return this.parent().timeoutTrigger();
        }

        @Override
        public void handleTimeout(long registerId, ResourceTimer resourceTimer) {
            ThreadLocalTimer threadLocalTimer = (ThreadLocalTimer)resourceTimer;
            this.parent().handleTimeout(registerId, threadLocalTimer);
        }
    }
}

