/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.cache;

import cc.otavia.core.cache.Poolable;
import cc.otavia.core.cache.PoolableHolder;
import cc.otavia.core.cache.SingleThreadPoolableHolder$;
import cc.otavia.core.util.Chainable;

public final class SingleThreadPoolableHolder<T extends Poolable>
implements PoolableHolder<T> {
    private final int maxSize;
    private int count;
    private Chainable head;
    private Chainable tail;

    public static <T extends Poolable> int $lessinit$greater$default$1() {
        return SingleThreadPoolableHolder$.MODULE$.$lessinit$greater$default$1();
    }

    public SingleThreadPoolableHolder(int maxSize) {
        this.maxSize = maxSize;
        this.count = 0;
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Poolable pop() {
        if (this.count > 1) {
            Chainable poolable = this.head;
            this.head = poolable.next();
            --this.count;
            poolable.deChain();
            return (Poolable)poolable;
        }
        if (this.count == 1) {
            Chainable poolable = this.head;
            this.tail = null;
            this.head = null;
            --this.count;
            return (Poolable)poolable;
        }
        return null;
    }

    @Override
    public void push(T poolable) {
        if (this.count == 0) {
            this.head = poolable;
            this.tail = poolable;
            this.count = 1;
            return;
        }
        if (this.count != this.maxSize()) {
            Chainable oldHead = this.head;
            poolable.next_$eq(oldHead);
            this.head = poolable;
            ++this.count;
            return;
        }
    }

    public void clean(int keep) {
        if (this.count > keep) {
            if (keep == 0) {
                this.head = null;
                this.tail = null;
                this.count = 0;
                return;
            }
            this.tail = this.head;
            for (int c = keep - 1; c > 0; --c) {
                this.tail = this.tail.next();
            }
            this.tail.cleanNext();
            this.count = keep;
            return;
        }
    }

    public int clean$default$1() {
        return 0;
    }
}

