/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.cache;

import cc.otavia.core.cache.ThreadLocal$;
import cc.otavia.core.cache.ThreadLocalTimer;
import cc.otavia.core.cache.TimeoutResource;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.ActorThread;
import cc.otavia.core.system.ActorThread$;
import cc.otavia.core.timer.TimeoutTrigger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;

public abstract class ThreadLocal<V>
implements TimeoutResource {
    private boolean initial = false;
    private ThreadLocalTimer[] threadLocalTimers;
    private volatile boolean triggered = false;

    public static Object[] EMPTY() {
        return ThreadLocal$.MODULE$.EMPTY();
    }

    private final void initialIfNot(ActorThread thread) {
        if (this.initial) {
            return;
        }
        this.syncInit(thread);
    }

    public final int threadIndex() {
        ActorThread thread = ActorThread$.MODULE$.currentThread();
        this.initialIfNot(thread);
        return thread.index();
    }

    private void syncInit(ActorThread thread) {
        ThreadLocal threadLocal = this;
        synchronized (threadLocal) {
            BoxedUnit boxedUnit;
            int len = thread.parent().size();
            if (!this.initial) {
                this.doInitial(len);
                Option option = this.initialTimeoutTrigger();
                if (option instanceof Some) {
                    TimeoutTrigger value = (TimeoutTrigger)((Some)option).value();
                    if (value instanceof TimeoutTrigger.DelayPeriod || value instanceof TimeoutTrigger.FirstTimePeriod) {
                        thread.system().registerLongLifeThreadLocal(this);
                    }
                } else if (!None$.MODULE$.equals(option)) {
                    throw new MatchError((Object)option);
                }
                this.threadLocalTimers = new ThreadLocalTimer[len];
                this.initial = true;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public abstract void doInitial(int var1);

    public final boolean isInitial() {
        return this.initial;
    }

    public abstract V initialValue();

    public abstract V get();

    public final void updateGetTime(int index) {
        if (this.isSupportTimeout()) {
            ThreadLocalTimer threadLocalTimer = this.threadLocalTimers[index];
            threadLocalTimer.updateGetTime();
            return;
        }
    }

    public abstract Object getIfExists();

    public abstract void set(V var1);

    public void updateSetTime() {
        if (this.isSupportTimeout()) {
            ThreadLocalTimer threadLocalTimer = this.threadLocalTimers[ActorThread$.MODULE$.currentThread().index()];
            threadLocalTimer.updateSetTime();
            return;
        }
    }

    public abstract boolean isSet();

    public abstract void remove();

    public void cancelTimer() {
        if (this.isSupportTimeout()) {
            ActorThread thread = ActorThread$.MODULE$.currentThread();
            int index = thread.index();
            ThreadLocalTimer threadLocalTimer = this.threadLocalTimers[index];
            thread.system().timer().cancelTimerTask(threadLocalTimer.registerId());
            this.threadLocalTimers[index] = null;
            return;
        }
    }

    public void onRemoval(V value) {
    }

    public final void initialTimer() {
        Option option = this.initialTimeoutTrigger();
        if (option instanceof Some) {
            TimeoutTrigger trigger = (TimeoutTrigger)((Some)option).value();
            this.triggered = true;
            ActorThread thread = ActorThread$.MODULE$.currentThread();
            ActorSystem system = thread.system();
            ThreadLocalTimer threadLocalTimer = new ThreadLocalTimer(this);
            long id = system.timer().registerResourceTimeout(trigger, thread.actorThreadAddress(), threadLocalTimer);
            threadLocalTimer.updateRegisterId(id);
            this.threadLocalTimers[thread.index()] = threadLocalTimer;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.threadLocalTimers = null;
            return;
        }
        throw new MatchError((Object)option);
    }

    private final boolean isSupportTimeout() {
        return this.triggered;
    }
}

