/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.buffer.Buffer;
import cc.otavia.buffer.pool.AbstractPooledPageAllocator;
import cc.otavia.buffer.pool.AdaptiveBuffer;
import cc.otavia.buffer.pool.RecyclablePageBuffer;
import cc.otavia.core.actor.ChannelsActor;
import cc.otavia.core.channel.AbstractChannel$;
import cc.otavia.core.channel.AbstractUnsafeChannel;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelAddress;
import cc.otavia.core.channel.ChannelInflight$;
import cc.otavia.core.channel.ChannelOption;
import cc.otavia.core.channel.ChannelOption$;
import cc.otavia.core.channel.ChannelPipeline;
import cc.otavia.core.channel.ChannelPipelineImpl;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.ChannelState;
import cc.otavia.core.channel.FileRegion;
import cc.otavia.core.channel.inflight.QueueMap;
import cc.otavia.core.channel.internal.AdaptiveBufferOffset;
import cc.otavia.core.channel.message.DatagramAdaptiveRangePacket$;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.message.ReactorEvent;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.stack.ChannelFuture;
import cc.otavia.core.stack.ChannelPromise;
import cc.otavia.core.stack.ChannelStack;
import cc.otavia.core.stack.ChannelStack$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.ActorThread;
import cc.otavia.core.system.ActorThread$;
import cc.otavia.core.util.CompressionBooleanLong;
import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public abstract class AbstractChannel
implements ChannelAddress,
Channel,
CompressionBooleanLong,
ChannelState {
    private long cc$otavia$core$util$CompressionBooleanLong$$compression;
    private final ActorSystem system;
    private final Logger logger;
    private ChannelsActor<?> actor;
    private int channelId;
    private ChannelPipelineImpl pipe;
    private AbstractUnsafeChannel unsafe;
    private Function1<Object, Object> futureBarrier;
    private Function1<Object, Object> stackBarrier;
    private int maxStackInflight;
    private int maxFutureInflight;
    private final QueueMap<ChannelPromise> inflightFutures;
    private final QueueMap<ChannelPromise> pendingFutures;
    private final QueueMap<ChannelStack<?>> inflightStacks;
    private final QueueMap<ChannelStack<?>> pendingStacks;
    private Object pipelineStackRequest;
    private long channelMsgId;
    private ChannelPromise ongoingChannelPromise;
    private ArrayDeque outboundQueue;
    private AbstractPooledPageAllocator direct;
    private AbstractPooledPageAllocator heap;

    public AbstractChannel(ActorSystem system) {
        this.system = system;
        CompressionBooleanLong.$init$(this);
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), system);
        this.channelId = -1;
        this.futureBarrier = AbstractChannel$.cc$otavia$core$channel$AbstractChannel$$$FALSE_FUNC;
        this.stackBarrier = AbstractChannel$.cc$otavia$core$channel$AbstractChannel$$$TURE_FUNC;
        this.maxStackInflight = 1;
        this.maxFutureInflight = 1;
        this.inflightFutures = new QueueMap();
        this.pendingFutures = new QueueMap();
        this.inflightStacks = new QueueMap();
        this.pendingStacks = new QueueMap();
        this.channelMsgId = ChannelInflight$.MODULE$.INVALID_CHANNEL_MESSAGE_ID();
        this.outboundQueue = ArrayDeque$.MODULE$.empty();
        this.created_$eq(true);
        this.registering_$eq(false);
        this.registered_$eq(false);
        this.connecting_$eq(false);
        this.connected_$eq(false);
        this.neverRegistered_$eq(true);
        this.neverActive_$eq(true);
        this.inputClosedSeenErrorOnRead_$eq(false);
        this.autoRead_$eq(true);
        this.autoClose_$eq(true);
        this.writable_$eq(true);
        this.allowHalfClosure_$eq(false);
        this.inWriteFlushed_$eq(false);
        this.closed_$eq(false);
        this.closing_$eq(false);
    }

    @Override
    public long cc$otavia$core$util$CompressionBooleanLong$$compression() {
        return this.cc$otavia$core$util$CompressionBooleanLong$$compression;
    }

    @Override
    public void cc$otavia$core$util$CompressionBooleanLong$$compression_$eq(long x$1) {
        this.cc$otavia$core$util$CompressionBooleanLong$$compression = x$1;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    public Logger logger() {
        return this.logger;
    }

    public ChannelPromise ongoingChannelPromise() {
        return this.ongoingChannelPromise;
    }

    public void ongoingChannelPromise_$eq(ChannelPromise x$1) {
        this.ongoingChannelPromise = x$1;
    }

    public ArrayDeque<Object> outboundQueue() {
        return this.outboundQueue;
    }

    public void outboundQueue_$eq(ArrayDeque<Object> x$1) {
        this.outboundQueue = x$1;
    }

    @Override
    public final boolean isMounted() {
        return this.mounted();
    }

    private final void setFutureMessageBarrier(Function1<Object, Object> barrier) {
        this.futureBarrier = barrier;
    }

    private final void setStackMessageBarrier(Function1<Object, Object> barrier) {
        this.stackBarrier = barrier;
    }

    private final void setMaxFutureInflight(int max) {
        this.maxFutureInflight = max;
    }

    private final void setMaxStackInflight(int max) {
        this.maxStackInflight = max;
    }

    @Override
    public final int inflightFutureSize() {
        return this.inflightFutures.size();
    }

    @Override
    public final int pendingFutureSize() {
        return this.pendingFutures.size();
    }

    @Override
    public final int inflightStackSize() {
        return this.inflightStacks.size();
    }

    @Override
    public final int pendingStackSize() {
        return this.pendingStacks.size();
    }

    private final void setStackHeadOfLine(boolean hol) {
        this.stackHeadOfLine_$eq(hol);
    }

    @Override
    public long generateMessageId() {
        ++this.channelMsgId;
        return this.channelMsgId;
    }

    @Override
    public <T> T writingChannelStackRequest() {
        return (T)this.pipelineStackRequest;
    }

    @Override
    public void onInboundMessage(Object msg) {
        if (this.maxFutureInflight == 1 && this.inflightFutures.size() == 1) {
            ChannelPromise promise = this.inflightFutures.pop();
            if (!(msg instanceof Throwable)) {
                promise.setSuccess(msg);
            } else {
                promise.setFailure((Throwable)msg);
            }
        } else {
            ChannelStack<Object> stack = ChannelStack$.MODULE$.apply(this, msg, this.generateMessageId());
            stack.setBarrier(BoxesRunTime.unboxToBoolean((Object)this.stackBarrier.apply(msg)));
            this.pendingStacks.append(stack);
            this.processPendingStacks();
        }
        if (this.pendingFutures.nonEmpty()) {
            this.processPendingFutures();
            return;
        }
    }

    @Override
    public void onInboundMessage(Object msg, long id) {
        if (this.inflightFutures.contains(id)) {
            ChannelPromise promise = this.inflightFutures.remove(id);
            if (!(msg instanceof Throwable)) {
                promise.setSuccess(msg);
            } else {
                promise.setFailure((Throwable)msg);
            }
        } else {
            ChannelStack<Object> stack = ChannelStack$.MODULE$.apply(this, msg, id);
            stack.setBarrier(BoxesRunTime.unboxToBoolean((Object)this.stackBarrier.apply(msg)));
            this.pendingStacks.append(stack);
            this.processPendingStacks();
        }
        if (this.pendingFutures.nonEmpty()) {
            this.processPendingFutures();
            return;
        }
    }

    public final void processCompletedChannelStacks() {
        while (this.inflightStacks.nonEmpty() && this.inflightStacks.first().isDone()) {
            ChannelStack<?> stack = this.inflightStacks.pop();
            if (stack.hasResult()) {
                this.pipelineStackRequest = stack.message();
                this.write(stack.result(), stack.messageId());
                this.pipelineStackRequest = null;
            }
            this.actor.recycleStack(stack);
        }
        this.flush();
    }

    public final void processPendingStacks() {
        if (this.pendingStacks.headIsBarrier()) {
            if (this.inflightStacks.isEmpty()) {
                this.processPendingStack();
                return;
            }
            return;
        }
        if (!this.inflightStacks.headIsBarrier()) {
            while (this.pendingStacks.nonEmpty() && this.inflightStacks.size() < this.maxStackInflight && !this.pendingStacks.headIsBarrier()) {
                this.processPendingStack();
            }
            this.processCompletedChannelStacks();
            return;
        }
    }

    private void processPendingStack() {
        ChannelStack<?> stack = this.pendingStacks.pop();
        this.inflightStacks.append(stack);
        this.executor().receiveChannelMessage(stack);
        if (stack.isDone() && !this.stackHeadOfLine()) {
            this.inflightStacks.remove(stack.entityId());
            if (stack.hasResult()) {
                this.writeAndFlush(stack.result(), stack.messageId());
            }
            this.actor.recycleStack(stack);
            return;
        }
    }

    public final void processPendingFutures() {
        if (this.pendingFutures.headIsBarrier()) {
            if (this.inflightFutures.isEmpty()) {
                ChannelPromise promise = this.pendingFutures.pop();
                this.inflightFutures.append(promise);
                this.writeAndFlush(promise.getAsk(), promise.messageId());
                return;
            }
            return;
        }
        if (!this.inflightFutures.headIsBarrier()) {
            while (this.pendingFutures.nonEmpty() && this.inflightFutures.size() < this.maxFutureInflight && !this.pendingFutures.headIsBarrier()) {
                ChannelPromise promise = this.pendingFutures.pop();
                this.write(promise.getAsk(), promise.messageId());
                this.inflightFutures.append(promise);
            }
            this.flush();
            return;
        }
    }

    public final void failedFutures(Throwable cause) {
        while (this.inflightFutures.nonEmpty()) {
            ChannelPromise promise = this.inflightFutures.pop();
            promise.setFailure(cause);
        }
        while (this.pendingFutures.nonEmpty()) {
            ChannelPromise promise = this.pendingFutures.pop();
            promise.setFailure(cause);
        }
    }

    public final void failedStacks(Throwable cause) {
        while (this.inflightStacks.nonEmpty()) {
            ChannelStack<?> stack = this.inflightStacks.pop();
            this.actor.recycleStack(stack);
        }
        while (this.pendingStacks.nonEmpty()) {
            ChannelStack<?> stack = this.pendingStacks.pop();
            this.actor.recycleStack(stack);
        }
    }

    @Override
    public ChannelFuture ask(Object value, ChannelFuture future) {
        ChannelPromise promise = future.promise();
        promise.setMessageId(this.generateMessageId());
        promise.setBarrier(BoxesRunTime.unboxToBoolean((Object)this.stackBarrier.apply(value)));
        promise.setAsk(value);
        promise.setChannel(this);
        this.actor.attachStack(this.actor.generateSendMessageId(), future);
        this.pendingFutures.append(promise);
        this.processPendingFutures();
        return future;
    }

    @Override
    public void notice(Object value) {
        this.write(value);
        this.flush();
    }

    @Override
    public void batchNotice(Seq<Object> notices) {
        notices.foreach((Function1)(JProcedure1 & Serializable)notice -> this.write(notice));
        this.flush();
    }

    @Override
    public int id() {
        return this.channelId;
    }

    @Override
    public final ChannelsActor<?> executor() {
        return this.actor;
    }

    @Override
    public final void mount(ChannelsActor<?> channelsActor) {
        if (this.mounted()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(64).append("The channel ").append(this).append(" has been mounted already, you can't mount it twice!").toString());
        }
        this.actor = channelsActor;
        ActorThread thread = ActorThread$.MODULE$.currentThread();
        this.direct = thread.directAllocator();
        this.heap = thread.heapAllocator();
        this.channelId = this.executor().generateChannelId();
        this.pipe = this.newChannelPipeline();
        this.mounted_$eq(true);
    }

    public AbstractPooledPageAllocator directAllocator() {
        return this.direct;
    }

    public AbstractPooledPageAllocator heapAllocator() {
        return this.heap;
    }

    @Override
    public AbstractUnsafeChannel unsafeChannel() {
        return this.unsafe;
    }

    public void setUnsafeChannel(AbstractUnsafeChannel uch) {
        this.unsafe = uch;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipe;
    }

    private ChannelPipelineImpl newChannelPipeline() {
        return new ChannelPipelineImpl(this);
    }

    private ArrayDeque<Runnable> laterTasks() {
        return ActorThread$.MODULE$.currentThread().laterTasks();
    }

    public void invokeLater(Runnable task) {
        this.laterTasks().append((Object)task);
    }

    @Override
    public final <T> T getOption(ChannelOption<T> option) {
        ChannelOption<T> channelOption = option;
        ChannelOption<Function1<Object, Object>> channelOption2 = ChannelOption$.MODULE$.CHANNEL_FUTURE_BARRIER();
        ChannelOption<T> channelOption3 = channelOption;
        if (!(channelOption2 != null ? !channelOption2.equals(channelOption3) : channelOption3 != null)) {
            return (T)this.futureBarrier;
        }
        ChannelOption<Function1<Object, Object>> channelOption4 = ChannelOption$.MODULE$.CHANNEL_STACK_BARRIER();
        ChannelOption<T> channelOption5 = channelOption;
        if (!(channelOption4 != null ? !channelOption4.equals(channelOption5) : channelOption5 != null)) {
            return (T)this.stackBarrier;
        }
        ChannelOption<Object> channelOption6 = ChannelOption$.MODULE$.CHANNEL_MAX_FUTURE_INFLIGHT();
        ChannelOption<T> channelOption7 = channelOption;
        if (!(channelOption6 != null ? !channelOption6.equals(channelOption7) : channelOption7 != null)) {
            return (T)BoxesRunTime.boxToInteger((int)this.maxFutureInflight);
        }
        ChannelOption<Object> channelOption8 = ChannelOption$.MODULE$.CHANNEL_MAX_STACK_INFLIGHT();
        ChannelOption<T> channelOption9 = channelOption;
        if (!(channelOption8 != null ? !channelOption8.equals(channelOption9) : channelOption9 != null)) {
            return (T)BoxesRunTime.boxToInteger((int)this.maxStackInflight);
        }
        ChannelOption<Object> channelOption10 = ChannelOption$.MODULE$.CHANNEL_STACK_HEAD_OF_LINE();
        ChannelOption<T> channelOption11 = channelOption;
        if (!(channelOption10 != null ? !channelOption10.equals(channelOption11) : channelOption11 != null)) {
            return (T)BoxesRunTime.boxToBoolean((boolean)this.stackHeadOfLine());
        }
        return this.getExtendedOption(option);
    }

    public <T> T getExtendedOption(ChannelOption<T> option) {
        throw new UnsupportedOperationException(new StringBuilder(29).append("ChannelOption not supported: ").append(option).toString());
    }

    @Override
    public final <T> Channel setOption(ChannelOption<T> option, T value) {
        ChannelOption<T> channelOption = option;
        ChannelOption<Function1<Object, Object>> channelOption2 = ChannelOption$.MODULE$.CHANNEL_FUTURE_BARRIER();
        ChannelOption<T> channelOption3 = channelOption;
        if (!(channelOption2 != null ? !channelOption2.equals(channelOption3) : channelOption3 != null)) {
            this.setFutureMessageBarrier((Function1<Object, Object>)((Function1)value));
        } else {
            ChannelOption<Function1<Object, Object>> channelOption4 = ChannelOption$.MODULE$.CHANNEL_STACK_BARRIER();
            ChannelOption<T> channelOption5 = channelOption;
            if (!(channelOption4 != null ? !channelOption4.equals(channelOption5) : channelOption5 != null)) {
                this.setStackMessageBarrier((Function1<Object, Object>)((Function1)value));
            } else {
                ChannelOption<Object> channelOption6 = ChannelOption$.MODULE$.CHANNEL_MAX_FUTURE_INFLIGHT();
                ChannelOption<T> channelOption7 = channelOption;
                if (!(channelOption6 != null ? !channelOption6.equals(channelOption7) : channelOption7 != null)) {
                    this.setMaxFutureInflight(BoxesRunTime.unboxToInt(value));
                } else {
                    ChannelOption<Object> channelOption8 = ChannelOption$.MODULE$.CHANNEL_MAX_STACK_INFLIGHT();
                    ChannelOption<T> channelOption9 = channelOption;
                    if (!(channelOption8 != null ? !channelOption8.equals(channelOption9) : channelOption9 != null)) {
                        this.setMaxStackInflight(BoxesRunTime.unboxToInt(value));
                    } else {
                        ChannelOption<Object> channelOption10 = ChannelOption$.MODULE$.CHANNEL_STACK_HEAD_OF_LINE();
                        ChannelOption<T> channelOption11 = channelOption;
                        if (!(channelOption10 != null ? !channelOption10.equals(channelOption11) : channelOption11 != null)) {
                            this.setStackHeadOfLine(BoxesRunTime.unboxToBoolean(value));
                        } else {
                            this.setExtendedOption(option, value);
                        }
                    }
                }
            }
        }
        return this;
    }

    public <T> void setExtendedOption(ChannelOption<T> option, T value) {
        throw new UnsupportedOperationException(new StringBuilder(29).append("ChannelOption not supported: ").append(option).toString());
    }

    @Override
    public final boolean isOptionSupported(ChannelOption<?> option) {
        return AbstractChannel$.cc$otavia$core$channel$AbstractChannel$$$SUPPORTED_CHANNEL_OPTIONS.contains(option) || this.isExtendedOptionSupported(option);
    }

    public boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.unsafe.isOpen();
    }

    @Override
    public final boolean isActive() {
        return this.unsafe.isActive();
    }

    @Override
    public final boolean isRegistered() {
        return this.registered();
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        return this.unsafe.isShutdown(direction);
    }

    @Override
    public long writableBytes() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void closeAfterCreate() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public final void handleChannelAcceptedEvent(ReactorEvent.AcceptedEvent event) {
        event.channel().pipeline().fireChannelRead(event.accepted());
    }

    public final void handleChannelReadCompletedEvent(ReactorEvent.ReadCompletedEvent event) {
        this.pipe.fireChannelReadComplete();
    }

    public final void handleChannelReadBufferEvent(ReactorEvent.ReadBuffer event) {
        Option<SocketAddress> option = event.sender();
        if (option instanceof Some) {
            SocketAddress address = (SocketAddress)((Some)option).value();
            int start = this.channelInboundAdaptiveBuffer().writerOffset();
            this.channelInboundAdaptiveBuffer().extend(event.buffer());
            int length = this.channelInboundAdaptiveBuffer().writerOffset() - start;
            this.pipeline().fireChannelRead(DatagramAdaptiveRangePacket$.MODULE$.apply(start, length, event.recipient(), event.sender()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.channelInboundAdaptiveBuffer().readableBytes() == 0) {
                this.channelInboundAdaptiveBuffer().extend(event.buffer());
                boxedUnit = BoxedUnit.UNIT;
            } else if (this.channelInboundAdaptiveBuffer().allocatedWritableBytes() >= event.buffer().readableBytes()) {
                boxedUnit = this.channelInboundAdaptiveBuffer().writeBytes((Buffer)event.buffer());
            } else {
                RecyclablePageBuffer last = this.channelInboundAdaptiveBuffer().splitLast();
                if (last.capacity() - last.readableBytes() >= event.buffer().readableBytes()) {
                    last.compact();
                    last.writeBytes((Buffer)event.buffer());
                    event.buffer().close();
                    this.channelInboundAdaptiveBuffer().extend(last);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.channelInboundAdaptiveBuffer().extend(last);
                    this.channelInboundAdaptiveBuffer().extend(event.buffer());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            this.pipeline().fireChannelRead(this.channelInboundAdaptiveBuffer());
            return;
        }
        throw new MatchError(option);
    }

    public void closeAdaptiveBuffers() {
        this.closeInboundAdaptiveBuffers();
        this.closeOutboundAdaptiveBuffers();
    }

    public void closeInboundAdaptiveBuffers() {
        this.shutdownedInbound_$eq(true);
        this.pipeline().closeInboundAdaptiveBuffers();
    }

    public void closeOutboundAdaptiveBuffers() {
        this.shutdownedOutbound_$eq(true);
        this.pipeline().closeOutboundAdaptiveBuffers();
    }

    public final ChannelPromise newPromise() {
        return new ChannelPromise();
    }

    public final void writeTransport(Object msg) {
        Object object = msg;
        if (object instanceof AdaptiveBuffer) {
            AdaptiveBuffer adaptiveBuffer;
            AdaptiveBuffer adaptiveBuffer2 = adaptiveBuffer = (AdaptiveBuffer)object;
            AdaptiveBuffer adaptiveBuffer3 = this.channelOutboundAdaptiveBuffer();
            if (!(adaptiveBuffer2 != null ? !adaptiveBuffer2.equals(adaptiveBuffer3) : adaptiveBuffer3 != null)) {
                this.updateLastOutboundQueue();
                return;
            }
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            this.channelOutboundAdaptiveBuffer().writeBytes(bytes);
            this.updateLastOutboundQueue();
            return;
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)object;
            this.channelOutboundAdaptiveBuffer().writeBytes(buffer);
            this.updateLastOutboundQueue();
            return;
        }
        if (object instanceof FileRegion) {
            FileRegion fileRegion = (FileRegion)object;
            this.outboundQueue().addOne((Object)fileRegion);
            return;
        }
        throw new UnsupportedOperationException();
    }

    private void updateLastOutboundQueue() {
        if (this.outboundQueue().nonEmpty() && this.outboundQueue().last() instanceof AdaptiveBufferOffset) {
            AdaptiveBufferOffset last = (AdaptiveBufferOffset)this.outboundQueue().last();
            last.endIndex_$eq(this.channelOutboundAdaptiveBuffer().writerOffset());
            return;
        }
        AdaptiveBufferOffset offset = new AdaptiveBufferOffset(this.channelOutboundAdaptiveBuffer().writerOffset());
        this.outboundQueue().addOne((Object)offset);
    }

    public final void flushTransport() {
        boolean resize;
        boolean bl = resize = this.outboundQueue().size() > 64;
        while (this.outboundQueue().nonEmpty()) {
            ArrayDeque<Object> arrayDeque = this.outboundQueue();
            Object payload = arrayDeque.removeHead(arrayDeque.removeHead$default$1());
            Object object = payload;
            if (object instanceof FileRegion) {
                FileRegion fileRegion = (FileRegion)object;
                this.reactor().flush(this, fileRegion);
                continue;
            }
            if (object instanceof AdaptiveBufferOffset) {
                AdaptiveBufferOffset adaptiveBufferOffset = (AdaptiveBufferOffset)object;
                RecyclablePageBuffer chain = this.channelOutboundAdaptiveBuffer().splitBefore(adaptiveBufferOffset.endIndex());
                this.reactor().flush(this, chain);
                continue;
            }
            throw new MatchError(object);
        }
        if (resize) {
            ArrayDeque<Object> arrayDeque = this.outboundQueue();
            arrayDeque.clearAndShrink(arrayDeque.clearAndShrink$default$1());
            return;
        }
    }

    public abstract void bindTransport(SocketAddress var1, ChannelPromise var2);

    public abstract void connectTransport(SocketAddress var1, Option<SocketAddress> var2, ChannelPromise var3);

    public abstract void openTransport(Path var1, Seq<OpenOption> var2, Seq<FileAttribute<?>> var3, ChannelPromise var4);

    public abstract void disconnectTransport(ChannelPromise var1);

    public abstract void closeTransport(ChannelPromise var1);

    public abstract void shutdownTransport(ChannelShutdownDirection var1, ChannelPromise var2);

    public abstract void registerTransport(ChannelPromise var1);

    public abstract void deregisterTransport(ChannelPromise var1);

    public void readTransport(ReadPlan readPlan) {
        this.reactor().read(this, readPlan);
    }

    public void handleChannelCloseEvent(ReactorEvent.ChannelClose event) {
    }

    public void handleChannelRegisterReplyEvent(ReactorEvent.RegisterReply event) {
    }

    public void handleChannelDeregisterReplyEvent(ReactorEvent.DeregisterReply event) {
    }

    public void handleChannelReadinessEvent(ReactorEvent.ChannelReadiness event) {
    }

    public void handleChannelBindReplyEvent(ReactorEvent.BindReply event) {
    }

    public void handleChannelConnectReplyEvent(ReactorEvent.ConnectReply event) {
    }

    public void handleChannelDisconnectReplyEvent(ReactorEvent.DisconnectReply event) {
    }

    public void handleChannelOpenReplyEvent(ReactorEvent.OpenReply event) {
    }

    public void handleChannelTimeoutEvent(long eventRegisterId) {
    }
}

