/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.core.channel.AbstractChannel;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.message.ReactorEvent;
import cc.otavia.core.message.ReactorEvent$;
import cc.otavia.core.stack.ChannelPromise;
import cc.otavia.core.system.ActorSystem;
import java.net.SocketAddress;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;

public abstract class AbstractFileChannel
extends AbstractChannel {
    private Path path;

    public AbstractFileChannel(ActorSystem system) {
        super(system);
    }

    private ActorSystem system$accessor() {
        return super.system();
    }

    @Override
    public final Option<SocketAddress> localAddress() {
        return None$.MODULE$;
    }

    @Override
    public final Option<SocketAddress> remoteAddress() {
        return None$.MODULE$;
    }

    @Override
    public final boolean isShutdown(ChannelShutdownDirection direction) {
        return !this.isOpen();
    }

    @Override
    public void bindTransport(SocketAddress local, ChannelPromise channelPromise) {
        channelPromise.setFailure(new UnsupportedOperationException());
    }

    @Override
    public void connectTransport(SocketAddress remote, Option<SocketAddress> local, ChannelPromise promise) {
        promise.setFailure(new UnsupportedOperationException());
    }

    @Override
    public void disconnectTransport(ChannelPromise promise) {
        promise.setFailure(new UnsupportedOperationException());
    }

    @Override
    public void shutdownTransport(ChannelShutdownDirection direction, ChannelPromise promise) {
        promise.setFailure(new UnsupportedOperationException());
    }

    @Override
    public void registerTransport(ChannelPromise promise) {
        this.registered_$eq(true);
        promise.setSuccess(ReactorEvent$.EMPTY_EVENT);
    }

    @Override
    public void handleChannelRegisterReplyEvent(ReactorEvent.RegisterReply event) {
    }

    @Override
    public void deregisterTransport(ChannelPromise promise) {
        promise.setSuccess(ReactorEvent$.EMPTY_EVENT);
    }

    @Override
    public void openTransport(Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs, ChannelPromise promise) {
        if (!this.mounted()) {
            promise.setFailure(new IllegalStateException(new StringBuilder(33).append("channel ").append(this).append(" is not mounted to actor!").toString()));
            return;
        }
        if (this.opening()) {
            promise.setFailure(new IllegalStateException("Channel is opening!"));
            return;
        }
        if (this.opened()) {
            promise.setFailure(new IllegalStateException("Open already!"));
            return;
        }
        this.opening_$eq(true);
        this.ongoingChannelPromise_$eq(promise);
        this.path = path;
        this.reactor().open(this, path, options, attrs);
    }

    @Override
    public final void handleChannelOpenReplyEvent(ReactorEvent.OpenReply event) {
        ChannelPromise promise = this.ongoingChannelPromise();
        this.ongoingChannelPromise_$eq(null);
        Option<Throwable> option = event.cause();
        if (None$.MODULE$.equals(option)) {
            this.opening_$eq(false);
            this.opened_$eq(true);
            this.pipeline().fireChannelActive();
            promise.setSuccess(event);
            return;
        }
        if (option instanceof Some) {
            Throwable cause = (Throwable)((Some)option).value();
            promise.setFailure(cause);
            this.closeTransport(this.newPromise());
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void closeTransport(ChannelPromise promise) {
        if (!this.opened()) {
            promise.setFailure(new IllegalStateException("File not opened!"));
            return;
        }
        if (this.closing() || this.closed()) {
            promise.setSuccess(ReactorEvent$.EMPTY_EVENT);
            return;
        }
        this.closing_$eq(true);
        this.ongoingChannelPromise_$eq(promise);
        this.reactor().close(this);
    }

    @Override
    public void handleChannelCloseEvent(ReactorEvent.ChannelClose event) {
        ChannelPromise promise = this.ongoingChannelPromise();
        this.ongoingChannelPromise_$eq(null);
        Option<Throwable> option = event.cause();
        if (None$.MODULE$.equals(option)) {
            this.closed_$eq(true);
            this.closing_$eq(false);
            this.pipeline().fireChannelInactive();
            promise.setSuccess(event);
            return;
        }
        if (option instanceof Some) {
            Throwable cause = (Throwable)((Some)option).value();
            promise.setFailure(cause);
            return;
        }
        throw new MatchError(option);
    }

    public String toString() {
        return new StringBuilder(26).append("FileChannel(path=").append(this.path.toAbsolutePath()).append(", state=").append(this.getStateString()).append(")").toString();
    }
}

