/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.core.channel.AbstractChannel;
import cc.otavia.core.channel.AbstractNetworkChannel$;
import cc.otavia.core.channel.ChannelOption;
import cc.otavia.core.channel.ChannelOption$;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.ChannelShutdownDirection$;
import cc.otavia.core.channel.ConnectTimeoutException;
import cc.otavia.core.channel.internal.WriteBufferWaterMark;
import cc.otavia.core.channel.internal.WriteBufferWaterMark$;
import cc.otavia.core.channel.message.ReadPlanFactory;
import cc.otavia.core.message.ReactorEvent;
import cc.otavia.core.message.ReactorEvent$;
import cc.otavia.core.stack.ChannelPromise;
import cc.otavia.core.stack.Promise;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.timer.TimeoutTrigger$DelayTime$;
import cc.otavia.core.timer.Timer$;
import cc.otavia.internal.Platform$;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public abstract class AbstractNetworkChannel
extends AbstractChannel {
    private int connectTimeoutMillis = 30000;
    private long connectTimeoutRegisterId = Timer$.MODULE$.INVALID_TIMEOUT_REGISTER_ID();
    private int waterMarkLow = WriteBufferWaterMark$.MODULE$.DEFAULT_LOW_WATER_MARK();
    private int waterMarkHigh = WriteBufferWaterMark$.MODULE$.DEFAULT_HIGH_WATER_MARK();

    public static int DEFAULT_CONNECT_TIMEOUT() {
        return AbstractNetworkChannel$.MODULE$.DEFAULT_CONNECT_TIMEOUT();
    }

    public AbstractNetworkChannel(ActorSystem system) {
        super(system);
    }

    private ActorSystem system$accessor() {
        return super.system();
    }

    @Override
    public <T> T getExtendedOption(ChannelOption<T> option) {
        ChannelOption<T> channelOption = option;
        ChannelOption<Object> channelOption2 = ChannelOption$.MODULE$.AUTO_READ();
        ChannelOption<T> channelOption3 = channelOption;
        if (!(channelOption2 != null ? !channelOption2.equals(channelOption3) : channelOption3 != null)) {
            return (T)BoxesRunTime.boxToBoolean((boolean)this.autoRead());
        }
        ChannelOption<WriteBufferWaterMark> channelOption4 = ChannelOption$.MODULE$.WRITE_BUFFER_WATER_MARK();
        ChannelOption<T> channelOption5 = channelOption;
        if (!(channelOption4 != null ? !channelOption4.equals(channelOption5) : channelOption5 != null)) {
            return (T)new WriteBufferWaterMark(this.waterMarkLow, this.waterMarkHigh, WriteBufferWaterMark$.MODULE$.$lessinit$greater$default$3());
        }
        ChannelOption<Integer> channelOption6 = ChannelOption$.MODULE$.CONNECT_TIMEOUT_MILLIS();
        ChannelOption<T> channelOption7 = channelOption;
        if (!(channelOption6 != null ? !channelOption6.equals(channelOption7) : channelOption7 != null)) {
            return (T)Predef$.MODULE$.int2Integer(this.connectTimeoutMillis);
        }
        ChannelOption<ReadPlanFactory> channelOption8 = ChannelOption$.MODULE$.READ_PLAN_FACTORY();
        ChannelOption<T> channelOption9 = channelOption;
        if (!(channelOption8 != null ? !channelOption8.equals(channelOption9) : channelOption9 != null)) {
            return (T)this.unsafeChannel().readPlanFactory();
        }
        ChannelOption<Object> channelOption10 = ChannelOption$.MODULE$.AUTO_CLOSE();
        ChannelOption<T> channelOption11 = channelOption;
        if (!(channelOption10 != null ? !channelOption10.equals(channelOption11) : channelOption11 != null)) {
            return (T)BoxesRunTime.boxToBoolean((boolean)this.autoClose());
        }
        ChannelOption<Object> channelOption12 = ChannelOption$.MODULE$.ALLOW_HALF_CLOSURE();
        ChannelOption<T> channelOption13 = channelOption;
        if (!(channelOption12 != null ? !channelOption12.equals(channelOption13) : channelOption13 != null)) {
            return (T)BoxesRunTime.boxToBoolean((boolean)this.allowHalfClosure());
        }
        return this.getTransportExtendedOption(option);
    }

    public <T> T getTransportExtendedOption(ChannelOption<T> option) {
        throw new UnsupportedOperationException(new StringBuilder(29).append("ChannelOption not supported: ").append(option).toString());
    }

    @Override
    public final <T> void setExtendedOption(ChannelOption<T> option, T value) {
        ChannelOption<T> channelOption = option;
        ChannelOption<Object> channelOption2 = ChannelOption$.MODULE$.AUTO_READ();
        ChannelOption<T> channelOption3 = channelOption;
        if (!(channelOption2 != null ? !channelOption2.equals(channelOption3) : channelOption3 != null)) {
            this.setAutoRead(BoxesRunTime.unboxToBoolean(value));
            return;
        }
        ChannelOption<WriteBufferWaterMark> channelOption4 = ChannelOption$.MODULE$.WRITE_BUFFER_WATER_MARK();
        ChannelOption<T> channelOption5 = channelOption;
        if (!(channelOption4 != null ? !channelOption4.equals(channelOption5) : channelOption5 != null)) {
            this.setWriteBufferWaterMark((WriteBufferWaterMark)value);
            return;
        }
        ChannelOption<Integer> channelOption6 = ChannelOption$.MODULE$.CONNECT_TIMEOUT_MILLIS();
        ChannelOption<T> channelOption7 = channelOption;
        if (!(channelOption6 != null ? !channelOption6.equals(channelOption7) : channelOption7 != null)) {
            this.setConnectTimeoutMillis(Predef$.MODULE$.Integer2int((Integer)value));
            return;
        }
        ChannelOption<ReadPlanFactory> channelOption8 = ChannelOption$.MODULE$.READ_PLAN_FACTORY();
        ChannelOption<T> channelOption9 = channelOption;
        if (!(channelOption8 != null ? !channelOption8.equals(channelOption9) : channelOption9 != null)) {
            this.setReadPlanFactory((ReadPlanFactory)value);
            return;
        }
        ChannelOption<Object> channelOption10 = ChannelOption$.MODULE$.AUTO_CLOSE();
        ChannelOption<T> channelOption11 = channelOption;
        if (!(channelOption10 != null ? !channelOption10.equals(channelOption11) : channelOption11 != null)) {
            this.setAutoClose(BoxesRunTime.unboxToBoolean(value));
            return;
        }
        ChannelOption<Object> channelOption12 = ChannelOption$.MODULE$.ALLOW_HALF_CLOSURE();
        ChannelOption<T> channelOption13 = channelOption;
        if (!(channelOption12 != null ? !channelOption12.equals(channelOption13) : channelOption13 != null)) {
            this.allowHalfClosure_$eq(BoxesRunTime.unboxToBoolean(value));
            return;
        }
        this.setTransportExtendedOption(option, value);
    }

    public <T> void setTransportExtendedOption(ChannelOption<T> option, T value) {
        throw new UnsupportedOperationException(new StringBuilder(29).append("ChannelOption not supported: ").append(option).toString());
    }

    @Override
    public boolean isExtendedOptionSupported(ChannelOption<?> option) {
        return AbstractNetworkChannel$.cc$otavia$core$channel$AbstractNetworkChannel$$$SUPPORTED_CHANNEL_OPTIONS.contains(option) || this.isTransportExtendedOptionSupported(option);
    }

    public boolean isTransportExtendedOptionSupported(ChannelOption<?> option) {
        return false;
    }

    private void setAutoRead(boolean auto) {
        if (!this.registered()) {
            this.autoRead_$eq(auto);
            return;
        }
        if (auto && !this.autoRead()) {
            this.autoRead_$eq(true);
            this.pipeline().read();
            return;
        }
        if (!auto && this.autoRead()) {
            this.autoRead_$eq(false);
            this.unsafeChannel().setAutoRead(false);
            return;
        }
    }

    private void setWriteBufferWaterMark(WriteBufferWaterMark mark) {
        this.waterMarkLow = mark.low();
        this.waterMarkHigh = mark.high();
    }

    private void setReadPlanFactory(ReadPlanFactory factory) {
        this.unsafeChannel().setReadPlanFactory(factory);
    }

    private void setConnectTimeoutMillis(int connectTimeoutMillis) {
        if (connectTimeoutMillis < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(38).append("connectTimeoutMillis ").append(connectTimeoutMillis).append(" (expected: >= 0)").toString());
        }
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    private void setAutoClose(boolean auto) {
        this.autoClose_$eq(auto);
        this.unsafeChannel().setAutoClose(auto);
    }

    private void setAllowHalfClosure(boolean allow) {
        this.unsafeChannel().setAllowHalfClosure(allow);
    }

    @Override
    public void registerTransport(ChannelPromise promise) {
        if (this.registering()) {
            this.invokeLater(() -> promise.setFailure(new IllegalStateException(new StringBuilder(39).append("The channel ").append(this).append(" is registering to reactor!").toString())));
            return;
        }
        if (this.registered()) {
            this.invokeLater(() -> promise.setFailure(new IllegalStateException("registered to reactor already")));
            return;
        }
        this.registering_$eq(true);
        this.ongoingChannelPromise_$eq(promise);
        this.reactor().register(this);
    }

    @Override
    public void handleChannelRegisterReplyEvent(ReactorEvent.RegisterReply event) {
        ChannelPromise promise = this.ongoingChannelPromise();
        this.ongoingChannelPromise_$eq(null);
        Option<Throwable> option = event.cause();
        if (None$.MODULE$.equals(option)) {
            boolean firstRegistration = this.neverRegistered();
            this.neverRegistered_$eq(false);
            this.registering_$eq(false);
            this.registered_$eq(true);
            this.pipeline().fireChannelRegistered();
            promise.setSuccess(event);
            if (event.active()) {
                if (firstRegistration) {
                    this.fireChannelActiveIfNotActiveBefore();
                }
                this.readIfIsAutoRead();
                return;
            }
            return;
        }
        if (option instanceof Some) {
            Throwable cause = (Throwable)((Some)option).value();
            this.closeNowAndFail(promise, cause);
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void bindTransport(SocketAddress local, ChannelPromise promise) {
        if (!this.mounted()) {
            this.invokeLater(() -> promise.setFailure(new IllegalStateException(new StringBuilder(33).append("channel ").append(this).append(" is not mounted to actor!").toString())));
            return;
        }
        if (!this.registered()) {
            if (this.registering()) {
                this.invokeLater(() -> promise.setFailure(new IllegalStateException("A register operation is already running")));
                return;
            }
            this.pipeline().register(this.newPromise());
            this.ongoingChannelPromise().onCompleted((Function1<ChannelPromise, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
                ChannelPromise channelPromise = x$1;
                ChannelPromise self = channelPromise;
                if (self.isSuccess()) {
                    this.ongoingChannelPromise_$eq(null);
                    this.bindTransport0(local, promise);
                    return;
                }
                ChannelPromise self2 = channelPromise;
                if (self2.isFailed()) {
                    this.ongoingChannelPromise_$eq(null);
                    promise.setFailure(self2.causeUnsafe());
                    return;
                }
                throw new MatchError((Object)channelPromise);
            });
            return;
        }
        this.bindTransport0(local, promise);
    }

    private void bindTransport0(SocketAddress local, ChannelPromise promise) {
        this.binding_$eq(true);
        SocketAddress socketAddress = local;
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            if (this.isOptionSupported(ChannelOption$.MODULE$.SO_BROADCAST()) && BoxesRunTime.unboxToBoolean((Object)this.getOption(ChannelOption$.MODULE$.SO_BROADCAST())) && !address.getAddress().isAnyLocalAddress() && !Platform$.MODULE$.isWindows() && !Platform$.MODULE$.maybeSuperUser()) {
                this.logger().warn(new StringBuilder(125).append("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; binding to a non-wildcard ").append(new StringBuilder(31).append("address (").append(address).append(") anyway as requested.").toString()).toString());
            }
        }
        this.ongoingChannelPromise_$eq(promise);
        this.setUnresolvedLocalAddress(local);
        this.reactor().bind(this, local);
    }

    @Override
    public final void handleChannelBindReplyEvent(ReactorEvent.BindReply event) {
        ChannelPromise promise = this.ongoingChannelPromise();
        this.ongoingChannelPromise_$eq(null);
        Option<Throwable> option = event.cause();
        if (None$.MODULE$.equals(option)) {
            this.bound_$eq(true);
            this.binding_$eq(false);
            if (event.firstActive() && this.fireChannelActiveIfNotActiveBefore()) {
                this.readIfIsAutoRead();
            }
            promise.setSuccess(ReactorEvent$.EMPTY_EVENT);
            return;
        }
        if (option instanceof Some) {
            Throwable cause = (Throwable)((Some)option).value();
            promise.setFailure(cause);
            this.closeTransport(this.newPromise());
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void connectTransport(SocketAddress remote, Option<SocketAddress> local, ChannelPromise promise) {
        if (!this.mounted()) {
            this.invokeLater(() -> promise.setFailure(new IllegalStateException(new StringBuilder(33).append("channel ").append(this).append(" is not mounted to actor!").toString())));
            return;
        }
        if (this.connected()) {
            this.invokeLater(() -> promise.setFailure(new AlreadyConnectedException()));
            return;
        }
        if (this.connecting()) {
            this.invokeLater(() -> promise.setFailure(new ConnectionPendingException()));
            return;
        }
        if (this.closed() || this.closing()) {
            this.invokeLater(() -> promise.setFailure(new ClosedChannelException()));
            return;
        }
        if (this.registering()) {
            this.invokeLater(() -> promise.setFailure(new IllegalStateException("A registering operation is running")));
            return;
        }
        if (!this.registered()) {
            if (!this.registering()) {
                this.pipeline().register(this.newPromise());
            }
            this.ongoingChannelPromise().onCompleted((Function1<ChannelPromise, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
                ChannelPromise channelPromise = x$1;
                ChannelPromise self = channelPromise;
                if (self.isSuccess()) {
                    this.ongoingChannelPromise_$eq(null);
                    this.connectTransport0(remote, local, promise);
                    return;
                }
                ChannelPromise self2 = channelPromise;
                if (self2.isFailed()) {
                    this.ongoingChannelPromise_$eq(null);
                    promise.setFailure(self2.causeUnsafe());
                    return;
                }
                throw new MatchError((Object)channelPromise);
            });
            return;
        }
        this.connectTransport0(remote, local, promise);
    }

    private void connectTransport0(SocketAddress remote, Option<SocketAddress> local, ChannelPromise promise) {
        this.connecting_$eq(true);
        this.ongoingChannelPromise_$eq(promise);
        ChannelOption<Object> fastOption = ChannelOption$.MODULE$.TCP_FASTOPEN_CONNECT();
        boolean fastOpen = this.isOptionSupported(fastOption) && BoxesRunTime.unboxToBoolean((Object)this.getOption(fastOption));
        this.reactor().connect(this, remote, local, fastOpen);
        if (this.connectTimeoutMillis > 0) {
            long tid;
            this.connectTimeoutRegisterId = tid = this.timer().registerChannelTimeout(TimeoutTrigger$DelayTime$.MODULE$.apply(Int$.MODULE$.int2long(this.connectTimeoutMillis), TimeoutTrigger$DelayTime$.MODULE$.$lessinit$greater$default$2()), this);
            promise.setTimeoutId(tid);
            return;
        }
    }

    @Override
    public final void handleChannelConnectReplyEvent(ReactorEvent.ConnectReply event) {
        if (this.ongoingChannelPromise() != null) {
            ChannelPromise promise = this.ongoingChannelPromise();
            this.ongoingChannelPromise_$eq(null);
            this.connecting_$eq(false);
            Option<Throwable> option = event.cause();
            if (None$.MODULE$.equals(option)) {
                this.connected_$eq(true);
                if (promise.canTimeout()) {
                    this.timer().cancelTimerTask(promise.timeoutId());
                }
                if (event.firstActive() && this.fireChannelActiveIfNotActiveBefore()) {
                    this.readIfIsAutoRead();
                }
                promise.setSuccess(event);
                return;
            }
            if (option instanceof Some) {
                Throwable cause = (Throwable)((Some)option).value();
                promise.setFailure(cause);
                this.closeTransport(this.newPromise());
                return;
            }
            throw new MatchError(option);
        }
    }

    private void handleConnectTimeout() {
        ChannelPromise promise = this.ongoingChannelPromise();
        this.ongoingChannelPromise_$eq(null);
        this.closeTransport(this.newPromise());
        promise.setFailure(new ConnectTimeoutException(new StringBuilder(22).append("connection timed out: ").append(this).toString()));
    }

    @Override
    public final void handleChannelTimeoutEvent(long eventRegisterId) {
        if (eventRegisterId == this.connectTimeoutRegisterId) {
            if (this.connecting()) {
                this.handleConnectTimeout();
                return;
            }
            return;
        }
        this.pipeline().fireChannelTimeoutEvent(eventRegisterId);
    }

    @Override
    public void openTransport(Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs, ChannelPromise promise) {
        this.invokeLater(() -> promise.setFailure(new UnsupportedOperationException()));
    }

    @Override
    public void closeTransport(ChannelPromise promise) {
        if (this.connecting() || this.registering() || this.connected()) {
            ChannelPromise ongoing = this.ongoingChannelPromise();
            if (ongoing != null) {
                ongoing.setFailure(new ClosedChannelException());
            }
            this.connecting_$eq(false);
            this.registering_$eq(false);
            this.closing_$eq(true);
            this.ongoingChannelPromise_$eq(promise);
            this.reactor().close(this);
            return;
        }
        if (this.closed()) {
            promise.setSuccess(ReactorEvent$.EMPTY_EVENT);
            return;
        }
        if (this.closing()) {
            promise.setFailure(new IllegalStateException("A close operation is running"));
            return;
        }
        promise.setFailure(new NotYetConnectedException());
    }

    @Override
    public void handleChannelCloseEvent(ReactorEvent.ChannelClose event) {
        this.closing_$eq(false);
        this.closed_$eq(true);
        if (this.ongoingChannelPromise() != null) {
            this.ongoingChannelPromise().setSuccess(event);
            this.ongoingChannelPromise_$eq(null);
        }
        ClosedChannelException cause = new ClosedChannelException();
        this.failedFutures(cause);
        this.failedStacks(cause);
        this.closeAdaptiveBuffers();
        this.pipeline().fireChannelInactive();
        if (this.registered()) {
            this.pipeline().fireChannelUnregistered();
        }
        while (!this.pipeline().isEmpty()) {
            this.pipeline().removeLast();
        }
    }

    @Override
    public void shutdownTransport(ChannelShutdownDirection direction, ChannelPromise promise) {
        if (!this.isActive()) {
            if (this.isOpen()) {
                promise.setFailure(new NotYetConnectedException());
                return;
            }
            promise.setFailure(new ClosedChannelException());
            return;
        }
        if (this.isShutdown(direction)) {
            promise.setSuccess(ReactorEvent$.EMPTY_EVENT);
            return;
        }
        this.reactor().shutdown(this, direction);
        promise.setSuccess(ReactorEvent$.EMPTY_EVENT);
    }

    public final void handleShutdownReply(ReactorEvent.ShutdownReply event) {
        ChannelShutdownDirection channelShutdownDirection = event.direction();
        ChannelShutdownDirection channelShutdownDirection2 = ChannelShutdownDirection$.Inbound;
        ChannelShutdownDirection channelShutdownDirection3 = channelShutdownDirection;
        if (!(channelShutdownDirection2 != null ? !channelShutdownDirection2.equals(channelShutdownDirection3) : channelShutdownDirection3 != null)) {
            this.pipeline().fireChannelShutdown(event.direction());
            return;
        }
        ChannelShutdownDirection channelShutdownDirection4 = ChannelShutdownDirection$.Outbound;
        ChannelShutdownDirection channelShutdownDirection5 = channelShutdownDirection;
        if (!(channelShutdownDirection4 != null ? !channelShutdownDirection4.equals(channelShutdownDirection5) : channelShutdownDirection5 != null)) {
            this.shutdownOutput(new ClosedChannelException());
            return;
        }
        throw new MatchError((Object)channelShutdownDirection);
    }

    private void shutdownOutput(Throwable cause) {
        if (this.outboundQueue() != null) {
            this.outboundQueue_$eq(null);
            this.failedFutures(cause);
            this.pipeline().fireChannelShutdown(ChannelShutdownDirection$.Outbound);
            return;
        }
    }

    @Override
    public void deregisterTransport(ChannelPromise promise) {
        if (!this.registered()) {
            promise.setSuccess(ReactorEvent$.EMPTY_EVENT);
            return;
        }
        this.reactor().deregister(this);
        this.ongoingChannelPromise_$eq(promise);
    }

    @Override
    public final void handleChannelDeregisterReplyEvent(ReactorEvent.DeregisterReply event) {
        Option<Throwable> option = event.cause();
        if (option instanceof Some) {
            Throwable value = (Throwable)((Some)option).value();
            this.logger().warn("Unexpected exception occurred while deregistering a channel.", value);
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        if (event.firstInactive()) {
            this.pipeline().fireChannelInactive();
        }
        if (this.registered()) {
            this.registered_$eq(false);
            this.pipeline().fireChannelUnregistered();
            if (!event.isOpen()) {
                while (!this.pipeline().isEmpty()) {
                    try {
                        this.pipeline().removeLast();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        ChannelPromise promise = this.ongoingChannelPromise();
        this.ongoingChannelPromise_$eq(null);
        promise.setSuccess(event);
    }

    private final void readIfIsAutoRead() {
        if (this.autoRead()) {
            this.pipeline().read();
            return;
        }
    }

    private boolean fireChannelActiveIfNotActiveBefore() {
        if (this.neverActive()) {
            this.neverActive_$eq(false);
            this.pipeline().fireChannelActive();
            return true;
        }
        return false;
    }

    private void closeNowAndFail(Promise<?> promise, Throwable cause) {
        this.closing_$eq(true);
        try {
            this.reactor().close(this);
        }
        catch (Exception e) {
            this.logger().warn("Failed to close a channel.", e);
        }
        this.closed_$eq(true);
        this.closing_$eq(false);
        promise.setFailure(cause);
    }

    private void closeIfClosed() {
        if (!this.isOpen()) {
            this.closeTransport(this.newPromise());
            return;
        }
    }

    private long totalPending() {
        return -1L;
    }

    @Override
    public final long writableBytes() {
        Integer n;
        long totalPending = this.totalPending();
        if (totalPending == -1L) {
            n = BoxesRunTime.boxToInteger((int)0);
        } else {
            Nothing$ bytes = Predef$.MODULE$.$qmark$qmark$qmark();
            n = BoxedUnit.UNIT;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void updateWritabilityIfNeeded(boolean notify, boolean notifyLater) {
        long totalPending = this.totalPending();
        if (totalPending > (long)this.waterMarkHigh) {
            this.writable_$eq(false);
            this.fireChannelWritabilityChangedIfNeeded(notify, notifyLater);
            return;
        }
        if (totalPending < (long)this.waterMarkLow) {
            this.writable_$eq(true);
            this.fireChannelWritabilityChangedIfNeeded(notify, notifyLater);
            return;
        }
    }

    private void fireChannelWritabilityChangedIfNeeded(boolean notify, boolean later) {
        if (notify) {
            if (later) {
                this.invokeLater(() -> this.pipeline().fireChannelWritabilityChanged());
                return;
            }
            this.pipeline().fireChannelWritabilityChanged();
            return;
        }
    }

    public String toString() {
        return new StringBuilder(13).append(this.getClass().getSimpleName()).append("(id=").append(this.id()).append(", state=").append(this.getStateString()).append(")").toString();
    }
}

