/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.buffer.pool.AdaptiveBuffer;
import cc.otavia.buffer.pool.PooledPageAllocator;
import cc.otavia.core.actor.ChannelsActor;
import cc.otavia.core.address.ActorAddress;
import cc.otavia.core.channel.ChannelAddress;
import cc.otavia.core.channel.ChannelOption;
import cc.otavia.core.channel.ChannelPipeline;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.UnsafeChannel;
import cc.otavia.core.reactor.Reactor;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.timer.Timer;
import java.net.SocketAddress;
import scala.Option;
import scala.runtime.Scala3RunTime$;

public interface Channel
extends ChannelAddress {
    public ChannelsActor<?> executor();

    public ActorSystem system();

    public void mount(ChannelsActor<?> var1);

    public static ActorAddress executorAddress$(Channel $this) {
        return $this.executorAddress();
    }

    default public ActorAddress<?> executorAddress() {
        return this.executor().self();
    }

    public static Reactor reactor$(Channel $this) {
        return $this.reactor();
    }

    default public Reactor reactor() {
        return this.executor().reactor();
    }

    public static Timer timer$(Channel $this) {
        return $this.timer();
    }

    default public Timer timer() {
        return this.executor().timer();
    }

    public <T> T getOption(ChannelOption<T> var1);

    public <T> Channel setOption(ChannelOption<T> var1, T var2);

    public boolean isOptionSupported(ChannelOption<?> var1);

    public boolean isMounted();

    public boolean isOpen();

    public boolean isActive();

    public boolean isRegistered();

    public boolean isShutdown(ChannelShutdownDirection var1);

    public Option<SocketAddress> localAddress();

    public Option<SocketAddress> remoteAddress();

    public static void setUnresolvedLocalAddress$(Channel $this, SocketAddress address) {
        $this.setUnresolvedLocalAddress(address);
    }

    default public void setUnresolvedLocalAddress(SocketAddress address) {
    }

    public static void setUnresolvedRemoteAddress$(Channel $this, SocketAddress address) {
        $this.setUnresolvedRemoteAddress(address);
    }

    default public void setUnresolvedRemoteAddress(SocketAddress address) {
    }

    public static boolean isWritable$(Channel $this) {
        return $this.isWritable();
    }

    default public boolean isWritable() {
        return this.writableBytes() > 0L;
    }

    public long writableBytes();

    public ChannelPipeline pipeline();

    public PooledPageAllocator directAllocator();

    public PooledPageAllocator heapAllocator();

    public static void write$(Channel $this, Object msg) {
        $this.write(msg);
    }

    default public void write(Object msg) {
        this.pipeline().write(msg);
    }

    public static void write$(Channel $this, Object msg, long msgId) {
        $this.write(msg, msgId);
    }

    default public void write(Object msg, long msgId) {
        this.pipeline().write(msg, msgId);
    }

    public static void writeAndFlush$(Channel $this, Object msg) {
        $this.writeAndFlush(msg);
    }

    default public void writeAndFlush(Object msg) {
        this.pipeline().writeAndFlush(msg);
    }

    public static void writeAndFlush$(Channel $this, Object msg, long msgId) {
        $this.writeAndFlush(msg, msgId);
    }

    default public void writeAndFlush(Object msg, long msgId) {
        this.pipeline().writeAndFlush(msg, msgId);
    }

    public static Channel flush$(Channel $this) {
        return $this.flush();
    }

    default public Channel flush() {
        this.pipeline().flush();
        return this;
    }

    public static void sendOutboundEvent$(Channel $this, Object event) {
        $this.sendOutboundEvent(event);
    }

    default public void sendOutboundEvent(Object event) {
        this.pipeline().sendOutboundEvent(event);
    }

    public static void assertExecutor$(Channel $this) {
        $this.assertExecutor();
    }

    default public void assertExecutor() {
        if (!this.executor().inExecutor()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"method must be called in ChannelsActor which this channel registered!");
        }
    }

    public void closeAfterCreate();

    public UnsafeChannel unsafeChannel();

    public static AdaptiveBuffer channelInboundAdaptiveBuffer$(Channel $this) {
        return $this.channelInboundAdaptiveBuffer();
    }

    default public AdaptiveBuffer channelInboundAdaptiveBuffer() {
        return this.pipeline().channelInboundBuffer();
    }

    public static AdaptiveBuffer channelOutboundAdaptiveBuffer$(Channel $this) {
        return $this.channelOutboundAdaptiveBuffer();
    }

    default public AdaptiveBuffer channelOutboundAdaptiveBuffer() {
        return this.pipeline().channelOutboundBuffer();
    }

    public int inflightFutureSize();

    public int pendingFutureSize();

    public int inflightStackSize();

    public int pendingStackSize();

    public <T> T writingChannelStackRequest();

    public long generateMessageId();

    public void onInboundMessage(Object var1);

    public void onInboundMessage(Object var1, long var2);
}

