/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.buffer.pool.AdaptiveBuffer;
import cc.otavia.common.ThrowableUtil$;
import cc.otavia.core.actor.ChannelsActor;
import cc.otavia.core.channel.ChannelHandler;
import cc.otavia.core.channel.ChannelHandlerContext;
import cc.otavia.core.channel.ChannelHandlerContextImpl$;
import cc.otavia.core.channel.ChannelOutboundInvoker;
import cc.otavia.core.channel.ChannelPipelineImpl;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.internal.ChannelHandlerMask$;
import cc.otavia.core.channel.message.AutoReadPlan$;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.stack.ChannelFuture;
import cc.otavia.core.stack.ChannelFuture$;
import java.net.SocketAddress;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.Scala3RunTime$;

public final class ChannelHandlerContextImpl
implements ChannelOutboundInvoker,
ChannelHandlerContext {
    private final ChannelPipelineImpl pipeline;
    private final String name;
    private final ChannelHandler handler;
    private final Logger logger;
    private final int executionMask;
    private long currentPendingBytes;
    private int handlerState;
    private boolean removed;
    private int idx;
    private ChannelHandlerContextImpl next;
    private ChannelHandlerContextImpl prev;
    private AdaptiveBuffer inboundAdaptive;
    private AdaptiveBuffer outboundAdaptive;

    public ChannelHandlerContextImpl(ChannelPipelineImpl pipeline, String name, ChannelHandler handler) {
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), pipeline.system());
        this.executionMask = ChannelHandlerMask$.MODULE$.mask(handler.getClass());
        this.currentPendingBytes = 0L;
        this.handlerState = ChannelHandlerContextImpl$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$INIT;
        this.idx = -1;
    }

    @Override
    public ChannelPipelineImpl pipeline() {
        return this.pipeline;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandler handler() {
        return this.handler;
    }

    public Logger logger() {
        return this.logger;
    }

    public int executionMask() {
        return this.executionMask;
    }

    public ChannelHandlerContextImpl next() {
        return this.next;
    }

    public void next_$eq(ChannelHandlerContextImpl x$1) {
        this.next = x$1;
    }

    public ChannelHandlerContextImpl prev() {
        return this.prev;
    }

    public void prev_$eq(ChannelHandlerContextImpl x$1) {
        this.prev = x$1;
    }

    public void setInboundAdaptiveBuffer(AdaptiveBuffer inboundAdaptiveBuffer) {
        this.inboundAdaptive = inboundAdaptiveBuffer;
    }

    public void setOutboundAdaptiveBuffer(AdaptiveBuffer outboundAdaptiveBuffer) {
        this.outboundAdaptive = outboundAdaptiveBuffer;
    }

    public int index() {
        return this.idx;
    }

    public void setIndex(int id) {
        this.idx = id;
    }

    @Override
    public AdaptiveBuffer inboundAdaptiveBuffer() {
        if (this.hasInboundAdaptive()) {
            return this.inboundAdaptive;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AdaptiveBuffer outboundAdaptiveBuffer() {
        if (this.hasOutboundAdaptive()) {
            return this.outboundAdaptive;
        }
        throw new UnsupportedOperationException();
    }

    private IllegalStateException handleOutboundHandlerException(Throwable cause, boolean closeDidThrow) {
        String msg = new StringBuilder(79).append(this.handler()).append(" threw an exception while handling an outbound event. This is most likely a bug").toString();
        this.logger().warn(new StringBuilder(49).append(msg).append(". This is most likely a bug, closing the channel.").toString(), cause);
        ChannelFuture channelFuture = closeDidThrow ? this.close(ChannelFuture$.MODULE$.apply()) : this.channel().close(ChannelFuture$.MODULE$.apply());
        return new IllegalStateException(msg, cause);
    }

    private ChannelHandlerContextImpl findContextInbound(int mask) {
        if (!this.removed) {
            ChannelHandlerContextImpl ctx = this;
            while (((ctx = ctx.next()).executionMask() & mask) == 0) {
            }
            return ctx;
        }
        throw new IllegalStateException(new StringBuilder(111).append("handler ").append(this.handler()).append(" has been removed from pipeline, ").append("so can't call the next handler in pipeline! This is most likely a bug!").toString());
    }

    private ChannelHandlerContextImpl findContextOutbound(int mask) {
        if (!this.removed) {
            ChannelHandlerContextImpl ctx = this;
            while (((ctx = ctx.prev()).executionMask() & mask) == 0) {
            }
            return ctx;
        }
        throw new IllegalStateException(new StringBuilder(111).append("handler ").append(this.handler()).append(" has been removed from pipeline, ").append("so can't call the next handler in pipeline! This is most likely a bug!").toString());
    }

    public boolean setAddComplete() {
        if (this.handlerState == ChannelHandlerContextImpl$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$INIT) {
            this.handlerState = ChannelHandlerContextImpl$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$ADD_COMPLETE;
            return true;
        }
        return false;
    }

    public void callHandlerAdded() throws Exception {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
            if (ChannelHandlerContextImpl$.MODULE$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$handlesPendingOutboundBytes(this.executionMask())) {
                long pending = this.pendingOutboundBytes();
                this.currentPendingBytes = Math.max(0L, pending);
                if (pending > 0L) {
                    this.pipeline().incrementPendingOutboundBytes(pending);
                    return;
                }
                return;
            }
            return;
        }
    }

    public void callHandlerRemoved() {
        block8: {
            try {
                if (this.handlerState != ChannelHandlerContextImpl$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$ADD_COMPLETE) break block8;
                this.handlerState = ChannelHandlerContextImpl$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$REMOVE_STARTED;
                try {
                    this.handler().handlerRemoved(this);
                }
                finally {
                    if (ChannelHandlerContextImpl$.MODULE$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$handlesPendingOutboundBytes(this.executionMask())) {
                        long pending = this.pendingOutboundBytes();
                        this.currentPendingBytes = Math.max(0L, pending);
                        if (pending > 0L) {
                            this.pipeline().decrementPendingOutboundBytes(pending);
                        }
                    }
                }
            }
            finally {
                this.handlerState = ChannelHandlerContextImpl$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$REMOVE_COMPLETE;
                this.removed = true;
            }
        }
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    public void remove(boolean relink) {
        if (this.handlerState != ChannelHandlerContextImpl$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$REMOVE_COMPLETE) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (relink) {
            ChannelHandlerContextImpl prev = this.prev();
            ChannelHandlerContextImpl next = this.next();
            prev.next_$eq(next);
            next.prev_$eq(prev);
            return;
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelRegistered() {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_REGISTERED());
        ctx.invokeChannelRegistered();
        return this;
    }

    public void invokeChannelRegistered() {
        try {
            try {
                this.handler().channelRegistered(this);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelUnregistered() {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_UNREGISTERED());
        ctx.invokeChannelUnregistered();
        return this;
    }

    public void invokeChannelUnregistered() {
        try {
            try {
                this.handler().channelUnregistered(this);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelActive() {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_ACTIVE());
        ctx.invokeChannelActive();
        return this;
    }

    public void invokeChannelActive() {
        try {
            try {
                this.handler().channelActive(this);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelInactive() {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_INACTIVE());
        ctx.invokeChannelInactive();
        return this;
    }

    public void invokeChannelInactive() {
        try {
            try {
                this.handler().channelInactive(this);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelShutdown(ChannelShutdownDirection direction) {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_SHUTDOWN());
        ctx.invokeChannelShutdown(direction);
        return this;
    }

    public void invokeChannelShutdown(ChannelShutdownDirection direction) {
        try {
            try {
                this.handler().channelShutdown(this, direction);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelExceptionCaught(Throwable cause) {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_EXCEPTION_CAUGHT());
        ctx.invokeChannelExceptionCaught(cause);
        return this;
    }

    public void invokeChannelExceptionCaught(Throwable cause) {
        try {
            try {
                cause.printStackTrace();
                this.handler().channelExceptionCaught(this, cause);
            }
            catch (Throwable error) {
                this.logger().debug(new StringBuilder(109).append("An exception ").append(ThrowableUtil$.MODULE$.stackTraceToString(error)).append(" was thrown by a user handler's ").append("exceptionCaught() method while handling the following exception:").toString(), cause);
                this.logger().warn(new StringBuilder(152).append("An exception '").append(error).append("' [enable DEBUG level for full stacktrace] ").append("was thrown by a user handler's exceptionCaught() ").append("method while handling the following exception:").toString(), cause);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelInboundEvent(Object evt) {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_INBOUND_EVENT());
        ctx.invokeChannelInboundEvent(evt);
        return this;
    }

    public void invokeChannelInboundEvent(Object event) {
        try {
            try {
                this.handler().channelInboundEvent(this, event);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelTimeoutEvent(long id) {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_TIMEOUT_EVENT());
        ctx.invokeChannelTimeoutEvent(id);
        return this;
    }

    public void invokeChannelTimeoutEvent(long id) {
        try {
            this.handler().channelTimeoutEvent(this, id);
        }
        catch (Throwable t) {
            this.invokeChannelExceptionCaught(t);
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelRead(Object msg) {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_READ());
        ctx.invokeChannelRead(msg);
        return this;
    }

    public void invokeChannelRead(Object msg) {
        try {
            try {
                this.handler().channelRead(this, msg);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelRead(Object msg, long msgId) {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_READ_ID());
        ctx.invokeChannelRead(msg, msgId);
        return this;
    }

    public void invokeChannelRead(Object msg, long id) {
        try {
            try {
                this.handler().channelRead(this, msg, id);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelReadComplete() {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_READ_COMPLETE());
        ctx.invokeChannelReadComplete();
        return this;
    }

    public void invokeChannelReadComplete() {
        try {
            try {
                this.handler().channelReadComplete(this);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl fireChannelWritabilityChanged() {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_CHANNEL_WRITABILITY_CHANGED());
        ctx.invokeChannelWritabilityChanged();
        return this;
    }

    public void invokeChannelWritabilityChanged() {
        try {
            try {
                this.handler().channelWritabilityChanged(this);
            }
            catch (Throwable t) {
                this.invokeChannelExceptionCaught(t);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl read(ReadPlan readPlan) {
        ChannelHandlerContextImpl ctx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_READ());
        ctx.invokeRead(readPlan);
        return this;
    }

    private void invokeRead(ReadPlan readPlan) {
        try {
            try {
                this.handler().read(this, readPlan);
            }
            catch (Throwable t) {
                this.handleOutboundHandlerException(t, false);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelHandlerContextImpl read() {
        ChannelHandlerContextImpl ctx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_READ());
        AutoReadPlan$ plan = AutoReadPlan$.MODULE$;
        ctx.invokeRead(plan);
        return this;
    }

    @Override
    public ChannelHandlerContextImpl flush() {
        ChannelHandlerContextImpl ctx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_FLUSH());
        ctx.invokeFlush();
        return this;
    }

    private void invokeFlush() {
        try {
            try {
                this.handler().flush(this);
            }
            catch (Throwable t) {
                this.handleOutboundHandlerException(t, false);
            }
        }
        finally {
            this.updatePendingBytesIfNeeded();
        }
    }

    @Override
    public ChannelFuture bind(SocketAddress local, ChannelFuture future) {
        ChannelHandlerContextImpl nextCtx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_BIND());
        nextCtx.invokeBind(local, future);
        return future;
    }

    public void invokeBind(SocketAddress local, ChannelFuture future) {
        try {
            this.handler().bind(this, local, future);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            future.promise().setFailure(this.handleOutboundHandlerException(t, false));
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress remote, Option<SocketAddress> local, ChannelFuture future) {
        ChannelHandlerContextImpl nextCtx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_CONNECT());
        nextCtx.invokeConnect(remote, local, future);
        return future;
    }

    private void invokeConnect(SocketAddress remote, Option<SocketAddress> local, ChannelFuture future) {
        try {
            this.handler().connect(this, remote, local, future);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            future.promise().setFailure(this.handleOutboundHandlerException(t, false));
        }
    }

    @Override
    public ChannelFuture open(Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs, ChannelFuture future) {
        ChannelHandlerContextImpl nextCtx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_OPEN());
        nextCtx.invokeOpen(path, options, attrs, future);
        return future;
    }

    private void invokeOpen(Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs, ChannelFuture future) {
        try {
            this.handler().open(this, path, options, attrs, future);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            future.promise().setFailure(this.handleOutboundHandlerException(t, false));
        }
    }

    @Override
    public ChannelFuture disconnect(ChannelFuture future) {
        ChannelHandlerContextImpl nextCtx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_DISCONNECT());
        nextCtx.invokeDisconnect(future);
        return future;
    }

    private void invokeDisconnect(ChannelFuture future) {
        try {
            this.handler().disconnect(this, future);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            future.promise().setFailure(this.handleOutboundHandlerException(t, false));
        }
    }

    @Override
    public ChannelFuture close(ChannelFuture future) {
        ChannelHandlerContextImpl ctx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_CLOSE());
        ctx.invokeClose(future);
        return future;
    }

    private void invokeClose(ChannelFuture future) {
        try {
            this.handler().close(this, future);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            future.promise().setFailure(this.handleOutboundHandlerException(t, false));
        }
    }

    @Override
    public ChannelFuture shutdown(ChannelShutdownDirection direction, ChannelFuture future) {
        ChannelHandlerContextImpl ctx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_SHUTDOWN());
        ctx.invokeShutdown(direction, future);
        return future;
    }

    private void invokeShutdown(ChannelShutdownDirection direction, ChannelFuture future) {
        try {
            this.handler().shutdown(this, direction, future);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            future.promise().setFailure(this.handleOutboundHandlerException(t, false));
        }
    }

    @Override
    public ChannelFuture register(ChannelFuture future) {
        ChannelHandlerContextImpl ctx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_REGISTER());
        ctx.invokeRegister(future);
        return future;
    }

    private void invokeRegister(ChannelFuture future) {
        try {
            this.handler().register(this, future);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            future.promise().setFailure(this.handleOutboundHandlerException(t, false));
        }
    }

    @Override
    public ChannelFuture deregister(ChannelFuture future) {
        ChannelHandlerContextImpl ctx = this.findContextOutbound(ChannelHandlerMask$.MODULE$.MASK_DEREGISTER());
        ctx.invokeDeregister(future);
        return future;
    }

    private void invokeDeregister(ChannelFuture future) {
        try {
            this.handler().deregister(this, future);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            future.promise().setFailure(this.handleOutboundHandlerException(t, false));
        }
    }

    @Override
    public void write(Object msg) {
        this.write0(msg, false);
    }

    private void invokeWrite(Object msg) {
        try {
            this.handler().write(this, msg);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            this.handleOutboundHandlerException(t, false);
        }
    }

    @Override
    public void write(Object msg, long msgId) {
        this.write0(msg, false, msgId);
    }

    private void invokeWrite(Object msg, long msgId) {
        try {
            this.handler().write(this, msg, msgId);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            this.handleOutboundHandlerException(t, false);
        }
    }

    @Override
    public void writeAndFlush(Object msg) {
        this.write0(msg, true);
    }

    private void invokeWriteAndFlush(Object msg) {
        this.invokeWrite(msg);
        this.invokeFlush();
    }

    @Override
    public void writeAndFlush(Object msg, long msgId) {
        this.write0(msg, true, msgId);
    }

    private void invokeWriteAndFlush(Object msg, long msgId) {
        this.invokeWrite(msg, msgId);
        this.invokeFlush();
    }

    private void write0(Object msg, boolean flush) {
        ChannelHandlerContextImpl next = this.findContextOutbound(flush ? ChannelHandlerMask$.MODULE$.MASK_WRITE() | ChannelHandlerMask$.MODULE$.MASK_FLUSH() : ChannelHandlerMask$.MODULE$.MASK_WRITE());
        if (flush) {
            next.invokeWriteAndFlush(msg);
            return;
        }
        next.invokeWrite(msg);
    }

    private void write0(Object msg, boolean flush, long msgId) {
        ChannelHandlerContextImpl next = this.findContextOutbound(flush ? ChannelHandlerMask$.MODULE$.MASK_WRITE() | ChannelHandlerMask$.MODULE$.MASK_FLUSH() : ChannelHandlerMask$.MODULE$.MASK_WRITE());
        if (flush) {
            next.invokeWriteAndFlush(msg, msgId);
            return;
        }
        next.invokeWrite(msg, msgId);
    }

    @Override
    public void sendOutboundEvent(Object event) {
        ChannelHandlerContextImpl ctx = this.findContextInbound(ChannelHandlerMask$.MODULE$.MASK_SEND_OUTBOUND_EVENT());
        ctx.invokeSendOutboundEvent(event);
    }

    private void invokeSendOutboundEvent(Object event) {
        try {
            this.handler().sendOutboundEvent(this, event);
            this.updatePendingBytesIfNeeded();
        }
        catch (Throwable t) {
            this.handleOutboundHandlerException(t, false);
        }
    }

    @Override
    public ChannelsActor<?> executor() {
        return this.pipeline().executor();
    }

    private long pendingOutboundBytes() {
        long pending = this.handler().pendingOutboundBytes(this);
        if (pending < 0L) {
            this.pipeline().forceCloseTransport();
            String handlerName = this.handler().getClass().getSimpleName();
            String message = new StringBuilder(97).append(handlerName).append(".pendingOutboundBytes(ChannelHandlerContext) returned a negative value: ").append(pending).append(". Force closed transport.").toString();
            throw new IllegalStateException(message);
        }
        return pending;
    }

    private void updatePendingBytesIfNeeded() {
        if (ChannelHandlerContextImpl$.MODULE$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$handlesPendingOutboundBytes(this.executionMask())) {
            long prev = this.currentPendingBytes;
            try {
                this.currentPendingBytes = this.pendingOutboundBytes();
                long delta = this.currentPendingBytes - prev;
                if (delta > 0L) {
                    this.pipeline().incrementPendingOutboundBytes(delta);
                } else if (delta < 0L) {
                    this.pipeline().decrementPendingOutboundBytes(-delta);
                }
            }
            catch (IllegalStateException e) {
                this.logger().error(ThrowableUtil$.MODULE$.stackTraceToString((Throwable)e));
            }
            catch (Throwable e) {
                throw e;
            }
            return;
        }
    }

    private boolean saveCurrentPendingBytesIfNeededInbound() {
        Option<IllegalStateException> option = this.saveCurrentPendingBytesIfNeeded();
        if (option instanceof Some) {
            IllegalStateException value = (IllegalStateException)((Some)option).value();
            this.logger().error(ThrowableUtil$.MODULE$.stackTraceToString((Throwable)value));
            return false;
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    private Option<IllegalStateException> saveCurrentPendingBytesIfNeeded() {
        if (!ChannelHandlerContextImpl$.MODULE$.cc$otavia$core$channel$ChannelHandlerContextImpl$$$handlesPendingOutboundBytes(this.executionMask())) {
            if (this.currentPendingBytes != 0L) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            return None$.MODULE$;
        }
        if (this.currentPendingBytes == -1L) {
            None$ ret = None$.MODULE$;
            try {
                this.currentPendingBytes = this.pendingOutboundBytes();
            }
            catch (IllegalStateException e) {
                ret = Some$.MODULE$.apply((Object)e);
            }
            return ret;
        }
        return None$.MODULE$;
    }

    public final Option<IllegalStateException> inline$saveCurrentPendingBytesIfNeeded() {
        return this.saveCurrentPendingBytesIfNeeded();
    }
}

