/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.core.channel.ChannelOption$;
import cc.otavia.core.channel.internal.WriteBufferWaterMark;
import cc.otavia.core.channel.message.ReadPlanFactory;
import java.net.NetworkInterface;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;

public class ChannelOption<T> {
    private final String name;
    private final int id;

    public static ChannelOption<Object> ALLOW_HALF_CLOSURE() {
        return ChannelOption$.MODULE$.ALLOW_HALF_CLOSURE();
    }

    public static ChannelOption<Object> AUTO_CLOSE() {
        return ChannelOption$.MODULE$.AUTO_CLOSE();
    }

    public static ChannelOption<Object> AUTO_READ() {
        return ChannelOption$.MODULE$.AUTO_READ();
    }

    public static ChannelOption<Function1<Object, Object>> CHANNEL_FUTURE_BARRIER() {
        return ChannelOption$.MODULE$.CHANNEL_FUTURE_BARRIER();
    }

    public static ChannelOption<Object> CHANNEL_MAX_FUTURE_INFLIGHT() {
        return ChannelOption$.MODULE$.CHANNEL_MAX_FUTURE_INFLIGHT();
    }

    public static ChannelOption<Object> CHANNEL_MAX_STACK_INFLIGHT() {
        return ChannelOption$.MODULE$.CHANNEL_MAX_STACK_INFLIGHT();
    }

    public static ChannelOption<Function1<Object, Object>> CHANNEL_STACK_BARRIER() {
        return ChannelOption$.MODULE$.CHANNEL_STACK_BARRIER();
    }

    public static ChannelOption<Object> CHANNEL_STACK_HEAD_OF_LINE() {
        return ChannelOption$.MODULE$.CHANNEL_STACK_HEAD_OF_LINE();
    }

    public static ChannelOption<Integer> CONNECT_TIMEOUT_MILLIS() {
        return ChannelOption$.MODULE$.CONNECT_TIMEOUT_MILLIS();
    }

    public static ChannelOption<Object> DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION() {
        return ChannelOption$.MODULE$.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION();
    }

    public static ChannelOption<NetworkInterface> IP_MULTICAST_IF() {
        return ChannelOption$.MODULE$.IP_MULTICAST_IF();
    }

    public static ChannelOption<Object> IP_MULTICAST_LOOP_DISABLED() {
        return ChannelOption$.MODULE$.IP_MULTICAST_LOOP_DISABLED();
    }

    public static ChannelOption<Integer> IP_MULTICAST_TTL() {
        return ChannelOption$.MODULE$.IP_MULTICAST_TTL();
    }

    public static ChannelOption<Integer> IP_TOS() {
        return ChannelOption$.MODULE$.IP_TOS();
    }

    public static ChannelOption<ReadPlanFactory> READ_PLAN_FACTORY() {
        return ChannelOption$.MODULE$.READ_PLAN_FACTORY();
    }

    public static ChannelOption<Integer> SO_BACKLOG() {
        return ChannelOption$.MODULE$.SO_BACKLOG();
    }

    public static ChannelOption<Object> SO_BROADCAST() {
        return ChannelOption$.MODULE$.SO_BROADCAST();
    }

    public static ChannelOption<Object> SO_KEEPALIVE() {
        return ChannelOption$.MODULE$.SO_KEEPALIVE();
    }

    public static ChannelOption<Integer> SO_LINGER() {
        return ChannelOption$.MODULE$.SO_LINGER();
    }

    public static ChannelOption<Integer> SO_RCVBUF() {
        return ChannelOption$.MODULE$.SO_RCVBUF();
    }

    public static ChannelOption<Object> SO_REUSEADDR() {
        return ChannelOption$.MODULE$.SO_REUSEADDR();
    }

    public static ChannelOption<Integer> SO_SNDBUF() {
        return ChannelOption$.MODULE$.SO_SNDBUF();
    }

    public static ChannelOption<Integer> SO_TIMEOUT() {
        return ChannelOption$.MODULE$.SO_TIMEOUT();
    }

    public static ChannelOption<Integer> TCP_FASTOPEN() {
        return ChannelOption$.MODULE$.TCP_FASTOPEN();
    }

    public static ChannelOption<Object> TCP_FASTOPEN_CONNECT() {
        return ChannelOption$.MODULE$.TCP_FASTOPEN_CONNECT();
    }

    public static ChannelOption<Object> TCP_NODELAY() {
        return ChannelOption$.MODULE$.TCP_NODELAY();
    }

    public static ChannelOption<WriteBufferWaterMark> WRITE_BUFFER_WATER_MARK() {
        return ChannelOption$.MODULE$.WRITE_BUFFER_WATER_MARK();
    }

    public static boolean exists(String string) {
        return ChannelOption$.MODULE$.exists(string);
    }

    public static <T> ChannelOption<T> valueOf(Class<?> clazz, String string) {
        return ChannelOption$.MODULE$.valueOf(clazz, string);
    }

    public static <T> ChannelOption<T> valueOf(String string) {
        return ChannelOption$.MODULE$.valueOf(string);
    }

    public ChannelOption(String name) {
        this.name = name;
        if (ChannelOption$.cc$otavia$core$channel$ChannelOption$$$pool.exists(name)) {
            throw new IllegalArgumentException(new StringBuilder(40).append("ChannelOption with name ").append(name).append(" already exists!").toString());
        }
        this.id = ChannelOption$.cc$otavia$core$channel$ChannelOption$$$nextId.getAndIncrement();
        ChannelOption$.cc$otavia$core$channel$ChannelOption$$$pool.add(name, this);
    }

    public String name() {
        return this.name;
    }

    public int id() {
        return this.id;
    }

    public void validate(T value) {
        Objects.requireNonNull(value, "value");
    }

    public static class ChannelOptionPool {
        private final ConcurrentHashMap<String, ChannelOption<?>> map = new ConcurrentHashMap();

        public ChannelOption<?> valueOf(String name) {
            if (this.map.containsKey(name)) {
                return this.map.get(name);
            }
            return new ChannelOption(name);
        }

        public void add(String name, ChannelOption<?> option) {
            this.map.put(name, option);
        }

        public boolean exists(String name) {
            return this.map.containsKey(name);
        }
    }
}

