/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.buffer.Buffer;
import cc.otavia.buffer.pool.AdaptiveBuffer;
import cc.otavia.buffer.pool.AdaptiveBuffer$;
import cc.otavia.buffer.pool.PooledPageAllocator;
import cc.otavia.core.actor.ChannelsActor;
import cc.otavia.core.channel.AbstractChannel;
import cc.otavia.core.channel.AbstractNetworkChannel;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelHandler;
import cc.otavia.core.channel.ChannelHandlerContext;
import cc.otavia.core.channel.ChannelHandlerContextImpl;
import cc.otavia.core.channel.ChannelOutboundInvoker;
import cc.otavia.core.channel.ChannelPipeline;
import cc.otavia.core.channel.ChannelPipelineException;
import cc.otavia.core.channel.ChannelPipelineImpl$;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.stack.ChannelFuture;
import cc.otavia.core.stack.ChannelPromise;
import cc.otavia.util.Resource$;
import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.NoSuchElementException;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ChannelPipelineImpl
implements ChannelOutboundInvoker,
ChannelPipeline {
    private final Channel channel;
    private final Logger logger;
    private final AdaptiveBuffer channelInboundAdaptiveBuffer;
    private final AdaptiveBuffer channelOutboundAdaptiveBuffer;
    private final ChannelHandlerContextImpl head;
    private final ChannelHandlerContextImpl tail;
    private final boolean touch;
    private final ArrayBuffer<ChannelHandlerContextImpl> handlers;
    private long _pendingOutboundBytes;

    public static ReadPlan DEFAULT_READ_PLAN() {
        return ChannelPipelineImpl$.MODULE$.DEFAULT_READ_PLAN();
    }

    public ChannelPipelineImpl(Channel channel) {
        this.channel = channel;
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), channel.system());
        this.channelInboundAdaptiveBuffer = AdaptiveBuffer$.MODULE$.apply(channel.directAllocator());
        this.channelOutboundAdaptiveBuffer = AdaptiveBuffer$.MODULE$.apply(channel.directAllocator());
        this.head = new ChannelHandlerContextImpl(this, ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$HEAD_NAME, ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$HEAD_HANDLER);
        this.tail = new ChannelHandlerContextImpl(this, ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$TAIL_NAME, ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$TAIL_HANDLER);
        this.head.next_$eq(this.tail);
        this.tail.prev_$eq(this.head);
        this.head.setInboundAdaptiveBuffer(this.channelInboundAdaptiveBuffer);
        this.head.setAddComplete();
        this.tail.setAddComplete();
        this.touch = true;
        this.handlers = new ArrayBuffer(4);
        this._pendingOutboundBytes = 0L;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public AdaptiveBuffer channelInboundBuffer() {
        return this.channelInboundAdaptiveBuffer;
    }

    @Override
    public AdaptiveBuffer channelOutboundBuffer() {
        return this.channelOutboundAdaptiveBuffer;
    }

    @Override
    public void closeInboundAdaptiveBuffers() {
        this.channelInboundAdaptiveBuffer.close();
        this.handlers.withFilter((Function1 & Serializable)ctx -> ctx.hasInboundAdaptive()).foreach((Function1)(JProcedure1 & Serializable)ctx -> ctx.inboundAdaptiveBuffer().close());
    }

    @Override
    public void closeOutboundAdaptiveBuffers() {
        this.channelOutboundAdaptiveBuffer.close();
        this.handlers.withFilter((Function1 & Serializable)ctx -> ctx.hasOutboundAdaptive()).foreach((Function1)(JProcedure1 & Serializable)ctx -> ctx.outboundAdaptiveBuffer().close());
    }

    public final Object touch(Object msg, ChannelHandlerContextImpl next) {
        if (this.touch) {
            Resource$.MODULE$.touch(msg, (Object)next);
        }
        return msg;
    }

    private ChannelHandlerContextImpl newContext(Option<String> name, ChannelHandler handler) {
        String string;
        ChannelPipelineImpl$.MODULE$.cc$otavia$core$channel$ChannelPipelineImpl$$$checkMultiplicity(handler);
        Option<String> option = name;
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            this.checkDuplicateName(value);
            string = value;
        } else if (None$.MODULE$.equals(option)) {
            string = this.generateName(handler);
        } else {
            throw new MatchError(option);
        }
        String value = string;
        return new ChannelHandlerContextImpl(this, value, handler);
    }

    private void checkDuplicateName(String name) throws IllegalArgumentException {
        if (this.context(name).nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Duplicate handler name: ").append(name).toString());
        }
    }

    private void replaceBufferHead(ChannelHandlerContextImpl newCtx, ChannelHandlerContextImpl oldFirst) {
        this.setHeadAdaptiveBuffer(newCtx);
        AdaptiveBuffer outbound = AdaptiveBuffer$.MODULE$.apply(this.channel().heapAllocator());
        oldFirst.setOutboundAdaptiveBuffer(outbound);
        if (newCtx.outboundAdaptiveBuffer().readableBytes() > 0) {
            outbound.writeBytes((Buffer)newCtx.outboundAdaptiveBuffer());
            return;
        }
    }

    private void setAdaptiveBuffer(ChannelHandlerContextImpl ctx, PooledPageAllocator allocator) {
        if (ctx.hasInboundAdaptive()) {
            AdaptiveBuffer inbound = AdaptiveBuffer$.MODULE$.apply(allocator);
            ctx.setInboundAdaptiveBuffer(inbound);
        }
        if (ctx.hasOutboundAdaptive()) {
            AdaptiveBuffer outbound = AdaptiveBuffer$.MODULE$.apply(allocator);
            ctx.setOutboundAdaptiveBuffer(outbound);
            return;
        }
    }

    private void setHeadAdaptiveBuffer(ChannelHandlerContextImpl newCtx) {
        if (newCtx.hasInboundAdaptive()) {
            AdaptiveBuffer inbound = AdaptiveBuffer$.MODULE$.apply(this.channel().heapAllocator());
            newCtx.setInboundAdaptiveBuffer(inbound);
        }
        if (newCtx.hasOutboundAdaptive()) {
            newCtx.setOutboundAdaptiveBuffer(this.channelOutboundAdaptiveBuffer);
            return;
        }
    }

    @Override
    public ChannelPipeline addFirst(Option<String> name, ChannelHandler handler) {
        this.channel().assertExecutor();
        ChannelHandlerContextImpl newCtx = this.newContext(name, handler);
        if (this.handlers.nonEmpty()) {
            ChannelHandlerContextImpl oldFirst = (ChannelHandlerContextImpl)this.handlers.head();
            if (newCtx.hasOutboundAdaptive() && oldFirst.hasOutboundAdaptive()) {
                this.replaceBufferHead(newCtx, oldFirst);
            } else {
                if (!newCtx.hasOutboundAdaptive() && oldFirst.hasOutboundAdaptive()) {
                    throw new IllegalStateException("can't add no outbound buffered handler before at outbound buffered handler!");
                }
                if (newCtx.isBufferHandlerContext() && !oldFirst.isBufferHandlerContext()) {
                    this.setHeadAdaptiveBuffer(newCtx);
                }
            }
        } else if (newCtx.isBufferHandlerContext()) {
            this.setHeadAdaptiveBuffer(newCtx);
        }
        this.handlers.insert(0, (Object)newCtx);
        this.resetIndices();
        ChannelHandlerContextImpl nextCtx = this.head.next();
        newCtx.prev_$eq(this.head);
        newCtx.next_$eq(nextCtx);
        this.head.next_$eq(newCtx);
        nextCtx.prev_$eq(newCtx);
        this.callHandlerAdded0(newCtx);
        return this;
    }

    @Override
    public ChannelPipeline addFirst(Seq<ChannelHandler> handlers) {
        handlers.foreach((Function1 & Serializable)handler -> this.addFirst((Option<String>)None$.MODULE$, (ChannelHandler)handler));
        return this;
    }

    @Override
    public ChannelPipeline addLast(Option<String> name, ChannelHandler handler) {
        ChannelHandlerContextImpl newCtx = this.newContext(name, handler);
        if (this.handlers.isEmpty() && newCtx.isBufferHandlerContext()) {
            this.setHeadAdaptiveBuffer(newCtx);
        }
        if (this.handlers.nonEmpty() && newCtx.isBufferHandlerContext() && !((ChannelHandlerContext)this.handlers.last()).isBufferHandlerContext()) {
            throw new IllegalStateException(new StringBuilder(54).append("buffered handler ").append(handler).append(" can't add after no buffered handler ").append(((ChannelHandlerContextImpl)this.handlers.last()).handler()).toString());
        }
        this.handlers.addOne((Object)newCtx);
        this.resetIndices();
        ChannelHandlerContextImpl prevCtx = this.tail.prev();
        newCtx.prev_$eq(prevCtx);
        newCtx.next_$eq(this.tail);
        prevCtx.next_$eq(newCtx);
        this.tail.prev_$eq(newCtx);
        this.callHandlerAdded0(newCtx);
        return this;
    }

    @Override
    public ChannelPipeline addBefore(String baseName, Option<String> name, ChannelHandler handler) {
        ChannelPipeline channelPipeline;
        this.channel().assertExecutor();
        String string = ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$HEAD_NAME;
        String string2 = baseName;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(39).append("Can't add handler ").append(handler).append(" before HeadHandler: ").append(ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$HEAD_NAME).toString());
        }
        String string3 = ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$TAIL_NAME;
        String string4 = baseName;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            channelPipeline = this.addLast(name, handler);
        } else {
            Tuple2 tuple2;
            Option option = ((IterableOnceOps)this.handlers.zipWithIndex()).find((Function1 & Serializable)_$1 -> {
                String string = ((ChannelHandlerContextImpl)_$1._1()).name();
                String string2 = baseName;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                ChannelHandlerContextImpl ctx = (ChannelHandlerContextImpl)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (index == 0) {
                    channelPipeline = this.addFirst(name, handler);
                } else {
                    ChannelHandlerContextImpl newCtx = this.newContext(name, handler);
                    if (newCtx.isBufferHandlerContext()) {
                        if (!ctx.isBufferHandlerContext()) {
                            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(54).append("buffered handler ").append(handler).append(" can't add after no buffered handler ").append(ctx.handler()).toString());
                        }
                        this.setAdaptiveBuffer(newCtx, this.channel().heapAllocator());
                    }
                    this.handlers.insert(index, (Object)newCtx);
                    this.resetIndices();
                    newCtx.prev_$eq(ctx.prev());
                    newCtx.next_$eq(ctx);
                    ctx.prev().next_$eq(newCtx);
                    ctx.prev_$eq(newCtx);
                    this.callHandlerAdded0(newCtx);
                    channelPipeline = BoxedUnit.UNIT;
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new NoSuchElementException(baseName);
                }
                throw new MatchError((Object)option);
            }
        }
        return this;
    }

    @Override
    public ChannelPipeline addAfter(String baseName, Option<String> name, ChannelHandler handler) {
        ChannelPipeline channelPipeline;
        this.channel().assertExecutor();
        String string = ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$TAIL_NAME;
        String string2 = baseName;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(37).append("Can't add handler after TailHandler: ").append(ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$TAIL_NAME).toString());
        }
        String string3 = ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$HEAD_NAME;
        String string4 = baseName;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            channelPipeline = this.addFirst(name, handler);
        } else {
            ChannelHandlerContextImpl newCtx;
            int index;
            ChannelHandlerContextImpl ctx;
            Tuple2 tuple2;
            Option option = ((IterableOnceOps)this.handlers.zipWithIndex()).find((Function1 & Serializable)_$2 -> {
                String string = ((ChannelHandlerContextImpl)_$2._1()).name();
                String string2 = baseName;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                ctx = (ChannelHandlerContextImpl)tuple2._1();
                index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                newCtx = this.newContext(name, handler);
                if (newCtx.isBufferHandlerContext()) {
                    ChannelHandlerContextImpl before = (ChannelHandlerContextImpl)this.handlers.apply(index);
                    if (!before.isBufferHandlerContext()) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(54).append("buffered handler ").append(handler).append(" can't add after no buffered handler ").append(before.handler()).toString());
                    }
                    this.setAdaptiveBuffer(newCtx, this.channel().heapAllocator());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new NoSuchElementException(baseName);
                }
                throw new MatchError((Object)option);
            }
            this.handlers.insert(index + 1, (Object)newCtx);
            this.resetIndices();
            newCtx.prev_$eq(ctx);
            newCtx.next_$eq(ctx.next());
            ctx.next().prev_$eq(newCtx);
            ctx.next_$eq(newCtx);
            this.callHandlerAdded0(newCtx);
            channelPipeline = BoxedUnit.UNIT;
        }
        return this;
    }

    private void callHandlerAdded0(ChannelHandlerContextImpl ctx) {
        block12: {
            try {
                ctx.callHandlerAdded();
            }
            catch (Throwable t) {
                boolean removed = false;
                try {
                    try {
                        Tuple2 tuple2;
                        Option option = ((IterableOnceOps)this.handlers.zipWithIndex()).find((Function1 & Serializable)_$3 -> {
                            Object object = _$3._1();
                            ChannelHandlerContextImpl channelHandlerContextImpl = ctx;
                            return !(object != null ? !object.equals(channelHandlerContextImpl) : channelHandlerContextImpl != null);
                        });
                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            this.handlers.remove(index);
                            this.resetIndices();
                        } else if (!None$.MODULE$.equals(option)) {
                            throw new MatchError((Object)option);
                        }
                        ctx.callHandlerRemoved();
                        removed = true;
                    }
                    catch (Throwable t2) {
                        this.logger().warn(new StringBuilder(28).append("Failed to remove a handler: ").append(ctx.name()).toString(), t2);
                    }
                }
                finally {
                    ctx.remove(true);
                }
                if (removed) {
                    String error = new StringBuilder(49).append(ctx.handler().getClass().getName()).append(".handlerAdded() has thrown an exception; removed.").toString();
                    this.fireChannelExceptionCaught(new ChannelPipelineException(error, t));
                    break block12;
                }
                String error = new StringBuilder(63).append(ctx.handler().getClass().getName()).append(".handlerAdded() has thrown an exception; also failed to remove.").toString();
                this.fireChannelExceptionCaught(new ChannelPipelineException(error, t));
            }
        }
    }

    private final void callHandlerRemoved0(ChannelHandlerContextImpl ctx) {
        try {
            ctx.callHandlerRemoved();
        }
        catch (Throwable t) {
            String error = new StringBuilder(42).append(ctx.handler().getClass().getName()).append(".handlerRemoved() has thrown an exception.").toString();
            this.fireChannelExceptionCaught(new RuntimeException(error, t));
        }
    }

    private String generateName(ChannelHandler handler) {
        String string;
        Class<?> handlerClz;
        HashMap<Class<?>, String> cache = ChannelPipelineImpl$.cc$otavia$core$channel$ChannelPipelineImpl$$$nameCaches.get();
        Option option = cache.get(handlerClz = handler.getClass());
        if (option instanceof Some) {
            String value;
            string = value = (String)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            String name0 = ChannelPipelineImpl$.MODULE$.cc$otavia$core$channel$ChannelPipelineImpl$$$generateName0(handlerClz);
            cache.put(handlerClz, (Object)name0);
            string = name0;
        } else {
            throw new MatchError((Object)option);
        }
        String name = string;
        if (this.context(name).nonEmpty()) {
            String x$proxy1 = name.substring(0, name.length() - 1);
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            String baseName = x$proxy1;
            int i = 1;
            boolean bl = true;
            while (bl) {
                String newName = new StringBuilder(0).append(baseName).append(i).toString();
                if (this.context(newName).isEmpty()) {
                    name = newName;
                    bl = false;
                }
                ++i;
            }
        }
        return name;
    }

    @Override
    public ChannelPipeline remove(ChannelHandler handler) {
        Tuple2 tuple2;
        this.channel().assertExecutor();
        Option option = ((IterableOnceOps)this.handlers.zipWithIndex()).find((Function1 & Serializable)_$4 -> {
            ChannelHandler channelHandler = ((ChannelHandlerContextImpl)_$4._1()).handler();
            ChannelHandler channelHandler2 = handler;
            return !(channelHandler != null ? !channelHandler.equals(channelHandler2) : channelHandler2 != null);
        });
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            ChannelHandlerContextImpl ctx = (ChannelHandlerContextImpl)tuple2._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            this.handlers.remove(index);
            this.resetIndices();
            this.remove0(ctx);
        } else if (None$.MODULE$.equals(option)) {
            this.logger().warn(new StringBuilder(47).append("Handler ").append(handler).append(" not be added to the channel's pipeline").toString());
        } else {
            throw new MatchError((Object)option);
        }
        return this;
    }

    @Override
    public Option<ChannelHandler> remove(String name) {
        Tuple2 tuple2;
        this.channel().assertExecutor();
        Option option = ((IterableOnceOps)this.handlers.zipWithIndex()).find((Function1 & Serializable)_$5 -> {
            String string = ((ChannelHandlerContextImpl)_$5._1()).name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            ChannelHandlerContextImpl ctx = (ChannelHandlerContextImpl)tuple2._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            this.handlers.remove(index);
            this.resetIndices();
            this.remove0(ctx);
            return Some$.MODULE$.apply((Object)ctx.handler());
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().warn(new StringBuilder(52).append("Handler name ").append(name).append(" not be added to the channel's pipeline").toString());
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public <T extends ChannelHandler> Option<T> remove(Class<T> handlerType) {
        return this.removeIfExists((Function1<ChannelHandlerContext, Object>)(Function1 & Serializable)ctx -> handlerType.isAssignableFrom(ctx.handler().getClass()));
    }

    private void remove0(ChannelHandlerContextImpl ctx) {
        try {
            this.callHandlerRemoved0(ctx);
        }
        finally {
            ctx.remove(true);
        }
    }

    @Override
    public Option<ChannelHandlerContext> context(ChannelHandler handler) {
        return this.handlers.find((Function1 & Serializable)_$6 -> {
            ChannelHandler channelHandler = _$6.handler();
            ChannelHandler channelHandler2 = handler;
            return !(channelHandler != null ? !channelHandler.equals(channelHandler2) : channelHandler2 != null);
        });
    }

    @Override
    public Option<ChannelHandlerContext> context(String name) {
        return this.handlers.find((Function1 & Serializable)_$7 -> {
            String string = _$7.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public Option<ChannelHandlerContext> context(Class<? extends ChannelHandler> handlerType) {
        return this.handlers.find((Function1 & Serializable)ctx -> handlerType.isAssignableFrom(ctx.handler().getClass()));
    }

    @Override
    public ChannelPipeline addLast(Seq<ChannelHandler> handlers) {
        handlers.foreach((Function1 & Serializable)handler -> this.addLast((Option<String>)None$.MODULE$, (ChannelHandler)handler));
        return this;
    }

    @Override
    public <T extends ChannelHandler> Option<T> removeIfExists(String name) {
        return this.removeIfExists((Function1<ChannelHandlerContext, Object>)(Function1 & Serializable)_$8 -> {
            String string = _$8.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public <T extends ChannelHandler> Option<T> removeIfExists(Class<T> handlerType) {
        return this.removeIfExists((Function1<ChannelHandlerContext, Object>)(Function1 & Serializable)ctx -> handlerType.isAssignableFrom(ctx.handler().getClass()));
    }

    @Override
    public <T extends ChannelHandler> Option<T> removeIfExists(ChannelHandler handler) {
        return this.removeIfExists((Function1<ChannelHandlerContext, Object>)(Function1 & Serializable)_$9 -> {
            ChannelHandler channelHandler = _$9.handler();
            ChannelHandler channelHandler2 = handler;
            return !(channelHandler != null ? !channelHandler.equals(channelHandler2) : channelHandler2 != null);
        });
    }

    private final <T extends ChannelHandler> Option<T> removeIfExists(Function1<ChannelHandlerContext, Object> finder) {
        Tuple2 tuple2;
        this.channel().assertExecutor();
        Option option = ((IterableOnceOps)this.handlers.zipWithIndex()).find((Function1 & Serializable)x$1 -> {
            ChannelHandlerContextImpl channelHandlerContextImpl = (ChannelHandlerContextImpl)x$1._1();
            int n = BoxesRunTime.unboxToInt((Object)x$1._2());
            return BoxesRunTime.unboxToBoolean((Object)finder.apply((Object)channelHandlerContextImpl));
        });
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            ChannelHandlerContextImpl ctx = (ChannelHandlerContextImpl)tuple2._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            this.handlers.remove(index);
            this.resetIndices();
            this.remove0(ctx);
            return Some$.MODULE$.apply((Object)ctx.handler());
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().warn("Handler not be added to the channel's pipeline");
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Option<ChannelHandler> removeFirst() {
        this.channel().assertExecutor();
        if (this.handlers.nonEmpty()) {
            ChannelHandlerContextImpl ctx = (ChannelHandlerContextImpl)this.handlers.remove(0);
            this.resetIndices();
            this.remove0(ctx);
            return Some$.MODULE$.apply((Object)ctx.handler());
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ChannelHandler> removeLast() {
        this.channel().assertExecutor();
        if (this.handlers.nonEmpty()) {
            ChannelHandlerContextImpl ctx = (ChannelHandlerContextImpl)this.handlers.remove(this.handlers.size() - 1);
            this.resetIndices();
            this.remove0(ctx);
            return Some$.MODULE$.apply((Object)ctx.handler());
        }
        return None$.MODULE$;
    }

    @Override
    public ChannelPipeline replace(ChannelHandler old, Option<String> newName, ChannelHandler newHandler) {
        this.replace((Function1<ChannelHandlerContext, Object>)(Function1 & Serializable)_$11 -> {
            ChannelHandler channelHandler = _$11.handler();
            ChannelHandler channelHandler2 = old;
            return !(channelHandler != null ? !channelHandler.equals(channelHandler2) : channelHandler2 != null);
        }, newName, newHandler);
        return this;
    }

    @Override
    public ChannelHandler replace(String old, Option<String> newName, ChannelHandler newHandler) {
        return this.replace((Function1<ChannelHandlerContext, Object>)(Function1 & Serializable)_$12 -> {
            String string = _$12.name();
            String string2 = old;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, newName, newHandler);
    }

    @Override
    public <T extends ChannelHandler> T replace(Class<T> old, Option<String> newName, ChannelHandler newHandler) {
        return (T)this.replace((Function1<ChannelHandlerContext, Object>)(Function1 & Serializable)ctx -> old.isAssignableFrom(ctx.handler().getClass()), newName, newHandler);
    }

    private final ChannelHandler replace(Function1<ChannelHandlerContext, Object> predicate, Option<String> newName, ChannelHandler newHandler) {
        Tuple2 tuple2;
        Option option = ((IterableOnceOps)this.handlers.zipWithIndex()).find((Function1 & Serializable)x$1 -> {
            ChannelHandlerContextImpl channelHandlerContextImpl = (ChannelHandlerContextImpl)x$1._1();
            int n = BoxesRunTime.unboxToInt((Object)x$1._2());
            return BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)channelHandlerContextImpl));
        });
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            ChannelHandlerContextImpl old = (ChannelHandlerContextImpl)tuple2._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            ChannelHandlerContextImpl newCtx = this.newContext(newName, newHandler);
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public Option<ChannelHandlerContext> firstContext() {
        if (this.handlers.nonEmpty()) {
            return Some$.MODULE$.apply(this.handlers.apply(0));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ChannelHandlerContext> lastContext() {
        if (this.handlers.nonEmpty()) {
            return Some$.MODULE$.apply(this.handlers.apply(this.handlers.size() - 1));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ChannelHandler> get(String name) {
        return this.context(name).map((Function1 & Serializable)_$14 -> _$14.handler());
    }

    @Override
    public <T extends ChannelHandler> Option<T> get(Class<T> handlerType) {
        return this.context(handlerType).map((Function1 & Serializable)_$15 -> _$15.handler());
    }

    @Override
    public Map<String, ChannelHandler> toMap() {
        return ((IterableOnceOps)this.handlers.map((Function1 & Serializable)ctx -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)ctx.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ctx.handler());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public ChannelPipelineImpl fireChannelRegistered() {
        this.head.invokeChannelRegistered();
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelUnregistered() {
        this.head.invokeChannelUnregistered();
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelActive() {
        this.head.invokeChannelActive();
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelInactive() {
        this.head.invokeChannelInactive();
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelShutdown(ChannelShutdownDirection direction) {
        this.head.invokeChannelShutdown(direction);
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelExceptionCaught(Throwable cause) {
        this.head.invokeChannelExceptionCaught(cause);
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelInboundEvent(Object event) {
        this.head.invokeChannelInboundEvent(event);
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelTimeoutEvent(long id) {
        this.head.invokeChannelTimeoutEvent(id);
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelRead(Object msg) {
        this.head.invokeChannelRead(msg);
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelRead(Object msg, long msgId) {
        this.head.invokeChannelRead(msg, msgId);
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelReadComplete() {
        this.head.invokeChannelReadComplete();
        return this;
    }

    @Override
    public ChannelPipelineImpl fireChannelWritabilityChanged() {
        this.head.invokeChannelWritabilityChanged();
        return this;
    }

    @Override
    public ChannelPipelineImpl flush() {
        this.tail.flush();
        return this;
    }

    @Override
    public ChannelPipelineImpl read(ReadPlan readPlan) {
        this.tail.read(readPlan);
        return this;
    }

    @Override
    public ChannelPipelineImpl read() {
        this.tail.read();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress local, ChannelFuture future) {
        this.assertInExecutor();
        return this.tail.bind(local, future);
    }

    @Override
    public ChannelFuture connect(SocketAddress remote, Option<SocketAddress> local, ChannelFuture future) {
        this.assertInExecutor();
        return this.tail.connect(remote, local, future);
    }

    @Override
    public ChannelFuture open(Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs, ChannelFuture future) {
        this.assertInExecutor();
        return this.tail.open(path, options, attrs, future);
    }

    @Override
    public ChannelFuture disconnect(ChannelFuture future) {
        this.assertInExecutor();
        return this.tail.disconnect(future);
    }

    @Override
    public ChannelFuture close(ChannelFuture future) {
        this.assertInExecutor();
        return this.tail.close(future);
    }

    @Override
    public ChannelFuture shutdown(ChannelShutdownDirection direction, ChannelFuture future) {
        this.assertInExecutor();
        return this.tail.shutdown(direction, future);
    }

    @Override
    public ChannelFuture register(ChannelFuture future) {
        this.assertInExecutor();
        return this.tail.register(future);
    }

    @Override
    public ChannelFuture deregister(ChannelFuture future) {
        this.assertInExecutor();
        return this.tail.deregister(future);
    }

    @Override
    public void write(Object msg) {
        this.assertInExecutor();
        this.tail.write(msg);
    }

    @Override
    public void write(Object msg, long msgId) {
        this.assertInExecutor();
        this.tail.write(msg, msgId);
    }

    @Override
    public void writeAndFlush(Object msg) {
        this.assertInExecutor();
        this.tail.writeAndFlush(msg);
    }

    @Override
    public void writeAndFlush(Object msg, long msgId) {
        this.assertInExecutor();
        this.tail.writeAndFlush(msg, msgId);
    }

    @Override
    public void sendOutboundEvent(Object event) {
        this.assertInExecutor();
        this.tail.sendOutboundEvent(event);
    }

    public final void forceCloseTransport() {
        AbstractChannel abstractChannel = (AbstractChannel)this.channel();
        abstractChannel.closeTransport(new ChannelPromise());
    }

    @Override
    public ChannelsActor<?> executor() {
        return this.channel().executor();
    }

    public void onUnhandledInboundException(Throwable cause) {
        this.logger().warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", cause);
        Resource$.MODULE$.dispose((Object)cause);
    }

    private void pendingOutboundBytesUpdated(long pendingOutboundBytes) {
        AbstractNetworkChannel abstractChannel = (AbstractNetworkChannel)this.channel();
        abstractChannel.updateWritabilityIfNeeded(true, false);
    }

    @Override
    public long pendingOutboundBytes() {
        return this._pendingOutboundBytes;
    }

    public final void incrementPendingOutboundBytes(long delta) {
        if (delta <= 0L) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this._pendingOutboundBytes += delta;
        if (this._pendingOutboundBytes < 0L) {
            this.forceCloseTransport();
            throw new IllegalStateException("pendingOutboundBytes overflowed, force closed transport.");
        }
        this.pendingOutboundBytesUpdated(this._pendingOutboundBytes);
    }

    public final void decrementPendingOutboundBytes(long delta) {
        if (delta <= 0L) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this._pendingOutboundBytes -= delta;
        if (this._pendingOutboundBytes < 0L) {
            this.forceCloseTransport();
            throw new IllegalStateException("pendingOutboundBytes underflowed, force closed transport.");
        }
        this.pendingOutboundBytesUpdated(this._pendingOutboundBytes);
    }

    private void resetIndices() {
        this.handlers.indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> ((ChannelHandlerContextImpl)this.handlers.apply(idx)).setIndex(idx));
    }

    public ChannelHandlerContextImpl findContextInbound(int from, int mask) {
        int cursor = from;
        ChannelHandlerContextImpl ctx = null;
        do {
            ctx = cursor < this.handlers.length() ? (ChannelHandlerContextImpl)this.handlers.apply(cursor) : this.tail;
            ++cursor;
        } while ((ctx.executionMask() & mask) == 0);
        return ctx;
    }

    public static final class HeadHandler
    implements ChannelHandler {
        @Override
        public boolean isBufferHandler() {
            return true;
        }

        @Override
        public ChannelFuture bind(ChannelHandlerContext ctx, SocketAddress local, ChannelFuture future) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.bindTransport(local, future.promise());
            return future;
        }

        @Override
        public ChannelFuture connect(ChannelHandlerContext ctx, SocketAddress remote, Option<SocketAddress> local, ChannelFuture future) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.connectTransport(remote, local, future.promise());
            return future;
        }

        @Override
        public ChannelFuture open(ChannelHandlerContext ctx, Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs, ChannelFuture future) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.openTransport(path, options, attrs, future.promise());
            return future;
        }

        @Override
        public ChannelFuture disconnect(ChannelHandlerContext ctx, ChannelFuture future) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.disconnectTransport(future.promise());
            return future;
        }

        @Override
        public ChannelFuture close(ChannelHandlerContext ctx, ChannelFuture future) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.closeTransport(future.promise());
            return future;
        }

        @Override
        public ChannelFuture shutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction, ChannelFuture future) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.shutdownTransport(direction, future.promise());
            return future;
        }

        @Override
        public ChannelFuture register(ChannelHandlerContext ctx, ChannelFuture future) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.registerTransport(future.promise());
            return future;
        }

        @Override
        public ChannelFuture deregister(ChannelHandlerContext ctx, ChannelFuture future) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.deregisterTransport(future.promise());
            return future;
        }

        @Override
        public void read(ChannelHandlerContext ctx, ReadPlan readPlan) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.readTransport(readPlan);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.writeTransport(msg);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, long msgId) {
            this.write(ctx, msg);
        }

        @Override
        public void flush(ChannelHandlerContext ctx) {
            AbstractChannel abstractChannel = (AbstractChannel)ctx.channel();
            abstractChannel.flushTransport();
        }

        @Override
        public void sendOutboundEvent(ChannelHandlerContext ctx, Object event) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
    }

    public static final class TailHandler
    implements ChannelHandler {
        @Override
        public void channelRegistered(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelShutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) {
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        }

        @Override
        public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) {
            Resource$.MODULE$.dispose(evt);
        }

        @Override
        public void channelTimeoutEvent(ChannelHandlerContext ctx, long id) {
        }

        @Override
        public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ((ChannelPipelineImpl)ctx.pipeline()).onUnhandledInboundException(cause);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.pipeline().channel().onInboundMessage(msg);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg, long msgId) {
            ctx.pipeline().channel().onInboundMessage(msg, msgId);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
        }
    }
}

