/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.core.channel.ChannelHandler;
import cc.otavia.core.channel.ChannelHandlerAdapter;
import cc.otavia.core.channel.ChannelHandlerContext;
import cc.otavia.core.channel.ChannelPipeline;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.internal.ChannelHandlerMask$;
import cc.otavia.core.channel.internal.DelegatingChannelHandlerContext;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.stack.ChannelFuture;
import java.net.SocketAddress;
import scala.Option;

public class CombinedChannelDuplexHandler<I extends ChannelHandler, O extends ChannelHandler>
extends ChannelHandlerAdapter {
    private CombinedChannelHandlerContext inboundCtx;
    private CombinedChannelHandlerContext outboundCtx;
    private boolean inited = false;
    private boolean handlerAdded = false;
    private I inbound;
    private O outbound;

    public CombinedChannelDuplexHandler() {
    }

    public CombinedChannelDuplexHandler(I inboundHandler, O outboundHandler) throws IllegalArgumentException {
        this();
        this.init(inboundHandler, outboundHandler);
    }

    public final void init(I inboundHandler, O outboundHandler) throws RuntimeException {
        if (this.inited) {
            throw new IllegalStateException(new StringBuilder(55).append("Handler CombinedChannelDuplexHandler[").append(this).append("] has been inited!").toString());
        }
        if (ChannelHandlerMask$.MODULE$.isOutbound(inboundHandler.getClass())) {
            throw new IllegalArgumentException("inboundHandler must not implement any outbound method to get combined.");
        }
        if (ChannelHandlerMask$.MODULE$.isInbound(outboundHandler.getClass())) {
            throw new IllegalArgumentException("outbound must not implement any inbound method to get combined.");
        }
        this.inbound = inboundHandler;
        this.outbound = outboundHandler;
        this.inited = true;
    }

    public I inboundHandler() {
        return this.inbound;
    }

    public O outboundHandler() {
        return this.outbound;
    }

    @Override
    public boolean isBufferHandler() {
        return this.inboundHandler().isBufferHandler() || this.outboundHandler().isBufferHandler();
    }

    private void checkAdded() {
        if (!this.handlerAdded) {
            throw new IllegalStateException("handler not added to pipeline yet");
        }
    }

    public final void removeInboundHandler() {
        this.checkAdded();
        this.inboundCtx.remove();
    }

    public final void removeOutboundHandler() {
        this.checkAdded();
        this.outboundCtx.remove();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        if (!this.inited) {
            throw new IllegalStateException(new StringBuilder(97).append("init() must be invoked before being added to a ").append(ChannelPipeline.class.getSimpleName()).append(" if ").append(CombinedChannelDuplexHandler.class.getSimpleName()).append(" was constructed with the default constructor.").toString());
        }
        this.outboundCtx = new CombinedChannelHandlerContext(ctx, (ChannelHandler)this.outbound);
        this.inboundCtx = new CombinedChannelHandlerContext(ctx, (ChannelHandler)this.inbound);
        this.handlerAdded = true;
        try {
            this.inbound.handlerAdded(this.inboundCtx);
        }
        finally {
            this.outbound.handlerAdded(this.outboundCtx);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        try {
            this.inboundCtx.remove();
        }
        finally {
            this.outboundCtx.remove();
        }
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelRegistered(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelRegistered();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelUnregistered(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelUnregistered();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelActive(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelInactive(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelInactive();
    }

    @Override
    public void channelShutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelShutdown(this.inboundCtx, direction);
            return;
        }
        this.inboundCtx.fireChannelShutdown(direction);
    }

    @Override
    public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelExceptionCaught(this.inboundCtx, cause);
            return;
        }
        this.inboundCtx.fireChannelExceptionCaught(cause);
    }

    @Override
    public void channelInboundEvent(ChannelHandlerContext ctx, Object evt) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelInboundEvent(this.inboundCtx, evt);
            return;
        }
        this.inboundCtx.fireChannelInboundEvent(evt);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelRead(this.inboundCtx, msg);
            return;
        }
        this.inboundCtx.fireChannelRead(msg);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelReadComplete(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelReadComplete();
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelWritabilityChanged(this.inboundCtx);
            return;
        }
        this.inboundCtx.fireChannelWritabilityChanged();
    }

    @Override
    public void channelTimeoutEvent(ChannelHandlerContext ctx, long id) {
        if (!this.inboundCtx.removed()) {
            this.inbound.channelTimeoutEvent(this.inboundCtx, id);
            return;
        }
        this.inboundCtx.fireChannelTimeoutEvent(id);
    }

    @Override
    public ChannelFuture bind(ChannelHandlerContext ctx, SocketAddress local, ChannelFuture future) {
        if (!this.outboundCtx.removed()) {
            return this.outbound.bind(this.outboundCtx, local, future);
        }
        return this.outboundCtx.bind(local, future);
    }

    @Override
    public ChannelFuture connect(ChannelHandlerContext ctx, SocketAddress remote, Option<SocketAddress> local, ChannelFuture future) {
        if (!this.outboundCtx.removed()) {
            return this.outbound.connect(this.outboundCtx, remote, local, future);
        }
        return this.outboundCtx.connect(remote, local, future);
    }

    @Override
    public ChannelFuture disconnect(ChannelHandlerContext ctx, ChannelFuture future) {
        if (!this.outboundCtx.removed()) {
            return this.outbound.disconnect(this.outboundCtx, future);
        }
        return this.outboundCtx.disconnect(future);
    }

    @Override
    public ChannelFuture close(ChannelHandlerContext ctx, ChannelFuture future) {
        if (!this.outboundCtx.removed()) {
            return this.outbound.close(this.outboundCtx, future);
        }
        return this.outboundCtx.close(future);
    }

    @Override
    public ChannelFuture shutdown(ChannelHandlerContext ctx, ChannelShutdownDirection direction, ChannelFuture future) {
        if (!this.outboundCtx.removed()) {
            return this.outbound.shutdown(this.outboundCtx, direction, future);
        }
        return this.outboundCtx.shutdown(direction, future);
    }

    @Override
    public ChannelFuture register(ChannelHandlerContext ctx, ChannelFuture future) {
        if (!this.outboundCtx.removed()) {
            return this.outbound.register(this.outboundCtx, future);
        }
        return this.outboundCtx.register(future);
    }

    @Override
    public ChannelFuture deregister(ChannelHandlerContext ctx, ChannelFuture future) {
        if (!this.outboundCtx.removed()) {
            return this.outbound.deregister(this.outboundCtx, future);
        }
        return this.outboundCtx.deregister(future);
    }

    @Override
    public void read(ChannelHandlerContext ctx, ReadPlan readPlan) {
        if (!this.outboundCtx.removed()) {
            this.outbound.read(this.outboundCtx, readPlan);
            return;
        }
        this.outboundCtx.read(readPlan);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg) {
        if (this.outboundCtx.removed()) {
            this.outbound.write(this.outboundCtx, msg);
            return;
        }
        this.outboundCtx.write(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, long msgId) {
        if (!this.outboundCtx.removed()) {
            this.outbound.write(this.outboundCtx, msg, msgId);
            return;
        }
        this.outboundCtx.write(msg, msgId);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) {
        if (!this.outboundCtx.removed()) {
            this.outbound.flush(this.outboundCtx);
            return;
        }
        this.outboundCtx.flush();
    }

    @Override
    public void sendOutboundEvent(ChannelHandlerContext ctx, Object event) {
        if (!this.outboundCtx.removed()) {
            this.outbound.sendOutboundEvent(this.outboundCtx, event);
            return;
        }
        this.outboundCtx.sendOutboundEvent(event);
    }

    @Override
    public long pendingOutboundBytes(ChannelHandlerContext ctx) {
        if (!this.outboundCtx.removed()) {
            return this.outboundCtx.handler().pendingOutboundBytes(this.outboundCtx);
        }
        return 0L;
    }

    public static final class CombinedChannelHandlerContext
    extends DelegatingChannelHandlerContext {
        private final ChannelHandler handler;
        private boolean removed;

        public CombinedChannelHandlerContext(ChannelHandlerContext ctx, ChannelHandler handler) {
            this.handler = handler;
            super(ctx);
            this.removed = false;
        }

        @Override
        public ChannelHandler handler() {
            return this.handler;
        }

        public boolean removed() {
            return this.removed;
        }

        public void removed_$eq(boolean x$1) {
            this.removed = x$1;
        }

        @Override
        public boolean isRemoved() {
            return this.delegatingCtx().isRemoved() || this.removed();
        }

        public void remove() {
            if (!this.removed()) {
                this.removed_$eq(true);
                try {
                    this.handler().handlerRemoved(this);
                }
                catch (Throwable cause) {
                    this.fireChannelExceptionCaught(cause);
                }
                return;
            }
        }
    }
}

