/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel;

import cc.otavia.core.channel.DefaultFileRegion$;
import cc.otavia.core.channel.FileRegion;
import cc.otavia.util.AbstractReferenceCounted;
import cc.otavia.util.IllegalReferenceCountException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import scala.runtime.BoxesRunTime;

public class DefaultFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private final long position;
    private final long count;
    private long _transferred;
    private FileChannel fileChannel;
    private File file;
    private final byte[] cBytes;

    public static void validate(DefaultFileRegion defaultFileRegion, long l) throws IOException {
        DefaultFileRegion$.MODULE$.validate(defaultFileRegion, l);
    }

    public DefaultFileRegion(long position, long count) {
        this.position = position;
        this.count = count;
        this._transferred = 0L;
        this.cBytes = BoxesRunTime.boxToLong((long)count).toString().getBytes(StandardCharsets.US_ASCII);
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long count() {
        return this.count;
    }

    public FileChannel cc$otavia$core$channel$DefaultFileRegion$$fileChannel() {
        return this.fileChannel;
    }

    private void fileChannel_$eq(FileChannel x$0) {
        this.fileChannel = x$0;
    }

    public DefaultFileRegion(FileChannel fileChannel, long position, long count) {
        this(position, count);
        this.fileChannel_$eq(fileChannel);
    }

    public DefaultFileRegion(File file, long position, long count) {
        this(position, count);
        this.file = file;
    }

    public DefaultFileRegion(File file) {
        this(0L, file.length());
        this.file = file;
    }

    public DefaultFileRegion(FileChannel fileChannel) {
        this(0L, fileChannel.size());
        this.fileChannel_$eq(fileChannel);
    }

    @Override
    public boolean isOpen() {
        boolean bl;
        DefaultFileRegion defaultFileRegion = this;
        synchronized (defaultFileRegion) {
            bl = this.cc$otavia$core$channel$DefaultFileRegion$$fileChannel() != null;
        }
        return bl;
    }

    @Override
    public byte[] countBytes() {
        return this.cBytes;
    }

    public void open() throws IOException {
        if (!this.isOpen() && this.refCnt() > 0) {
            DefaultFileRegion defaultFileRegion = this;
            synchronized (defaultFileRegion) {
                this.fileChannel_$eq(new RandomAccessFile(this.file, "r").getChannel());
            }
            return;
        }
    }

    public void deallocate() {
        if (this.cc$otavia$core$channel$DefaultFileRegion$$fileChannel() != null) {
            FileChannel fc = this.cc$otavia$core$channel$DefaultFileRegion$$fileChannel();
            this.fileChannel_$eq(null);
            try {
                fc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public long transferred() {
        return this._transferred;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) {
        long count = this.count() - position;
        if (count < 0L || position < 0L) {
            throw new IllegalArgumentException(new StringBuilder(17).append(position).append(" (expected: 0 - ").append(this.count() - 1L).append(")").toString());
        }
        if (count == 0L) {
            return 0L;
        }
        if (this.refCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
        this.open();
        long written = this.cc$otavia$core$channel$DefaultFileRegion$$fileChannel().transferTo(this.position() + position, count, target);
        if (written > 0L) {
            this._transferred += written;
        } else if (written == 0L) {
            DefaultFileRegion$.MODULE$.validate(this, position);
        }
        return written;
    }
}

