/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel.inflight;

import cc.otavia.core.channel.inflight.QueueMap$;
import cc.otavia.core.channel.inflight.QueueMapEntity;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.function.JProcedure1;

public class QueueMap<V extends QueueMapEntity> {
    private QueueMapEntity[] table = new QueueMapEntity[QueueMap$.MODULE$.tableSizeFor(this.initialCapacity())];
    private int mask = QueueMap$.MODULE$.tableSizeFor(this.initialCapacity()) - 1;
    private QueueMapEntity head;
    private QueueMapEntity tail;
    private int threshold = this.newThreshold(QueueMap$.MODULE$.tableSizeFor(this.initialCapacity()));
    private int contentSize = 0;

    public static int tableSizeFor(int n) {
        return QueueMap$.MODULE$.tableSizeFor(n);
    }

    private final double loadFactor() {
        return 2.0;
    }

    private final int initialCapacity() {
        return 16;
    }

    private int newThreshold(int size) {
        return (int)((double)size * this.loadFactor());
    }

    private int index(long id) {
        return (int)(id & (long)this.mask);
    }

    public int size() {
        return this.contentSize;
    }

    public boolean isEmpty() {
        return this.contentSize == 0;
    }

    public boolean nonEmpty() {
        return this.contentSize != 0;
    }

    public void append(V v) {
        if (this.contentSize == 0) {
            this.head = v;
            this.tail = v;
            this.put0((QueueMapEntity)v);
        } else {
            this.tail.queueLater_$eq((QueueMapEntity)v);
            v.queueEarlier_$eq(this.tail);
            this.tail = v;
            this.put0((QueueMapEntity)v);
        }
        ++this.contentSize;
    }

    public V pop() {
        if (this.contentSize == 1) {
            QueueMapEntity entity = this.head;
            this.head = null;
            this.tail = null;
            this.remove0(entity.entityId());
            return (V)entity;
        }
        QueueMapEntity entity = this.head;
        this.head = entity.queueLater();
        this.head.queueEarlier_$eq(null);
        entity.queueLater_$eq(null);
        this.remove0(entity.entityId());
        return (V)entity;
    }

    public V remove(long id) {
        QueueMapEntity entity = this.remove0(id);
        QueueMapEntity pre = entity.queueEarlier();
        QueueMapEntity next = entity.queueLater();
        entity.cleanEntity();
        if (pre != null && next != null) {
            pre.queueLater_$eq(next);
            next.queueEarlier_$eq(pre);
        } else if (pre != null || next != null) {
            if (pre == null) {
                this.head = next;
                this.head.queueEarlier_$eq(null);
            } else {
                this.tail = pre;
                this.tail.queueLater_$eq(null);
            }
        }
        return (V)entity;
    }

    public boolean contains(long id) {
        return this.findNode(id) != null;
    }

    public boolean isHead(V value) {
        QueueMapEntity queueMapEntity = this.head;
        V v = value;
        return !(queueMapEntity != null ? !queueMapEntity.equals(v) : v != null);
    }

    public V first() {
        return (V)this.head;
    }

    public boolean headIsBarrier() {
        return this.head != null && this.head.isBarrier();
    }

    private QueueMapEntity findNode(long id) {
        if (this.tail != null && this.tail.entityId() == id) {
            return this.tail;
        }
        if (this.table != null) {
            QueueMapEntity queueMapEntity = this.table[this.index(id)];
            if (queueMapEntity == null) {
                return null;
            }
            QueueMapEntity entity = queueMapEntity;
            return entity.findHashNode(id);
        }
        return null;
    }

    private final QueueMapEntity remove0(long id) {
        QueueMapEntity entity;
        QueueMapEntity queueMapEntity;
        int idx = this.index(id);
        QueueMapEntity queueMapEntity2 = this.table[idx];
        if (queueMapEntity2 == null) {
            queueMapEntity = null;
        } else {
            QueueMapEntity node = queueMapEntity2;
            if (node.entityId() == id) {
                this.table[idx] = node.hashNext();
                --this.contentSize;
                node.hashNext_$eq(null);
                queueMapEntity = node;
            } else {
                QueueMapEntity cursor;
                QueueMapEntity node2;
                QueueMapEntity prev = node2 = queueMapEntity2;
                for (cursor = node2.hashNext(); cursor != null && cursor.entityId() != id; cursor = cursor.hashNext()) {
                    prev = cursor;
                }
                if (cursor != null) {
                    prev.hashNext_$eq(cursor.hashNext());
                    --this.contentSize;
                    cursor.hashNext_$eq(null);
                }
                queueMapEntity = entity = cursor;
            }
        }
        if (this.table.length >= this.initialCapacity() * 4 && this.contentSize < this.table.length / 2) {
            this.resizeTable(this.table.length / 2);
        }
        return entity;
    }

    private final void put0(QueueMapEntity entity) {
        QueueMapEntity old;
        int idx = this.index(entity.entityId());
        QueueMapEntity queueMapEntity = this.table[idx];
        if (queueMapEntity == null) {
            this.table[idx] = entity;
            return;
        }
        QueueMapEntity tail = old = queueMapEntity;
        while (tail.hashNext() != null) {
            tail = tail.hashNext();
        }
        tail.hashNext_$eq(entity);
    }

    private final void resizeTable(int newLen) {
        Object[] oldTable = this.table;
        this.table = new QueueMapEntity[newLen];
        this.mask = newLen - 1;
        this.threshold = this.newThreshold(this.table.length);
        Object object = Predef$.MODULE$.refArrayOps(oldTable);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)node -> {
            for (QueueMapEntity cursor = node; cursor != null; cursor = cursor.hashNext()) {
                QueueMapEntity entity = cursor;
                entity.hashNext_$eq(null);
                this.put0(entity);
            }
        });
    }
}

