/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel.internal;

import cc.otavia.core.cache.ActorThreadLocal;
import cc.otavia.core.channel.ChannelHandler;
import cc.otavia.core.channel.ChannelHandlerContext;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.Skip;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.stack.ChannelFuture;
import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.file.Path;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ChannelHandlerMask$
implements Serializable {
    private static final int MASK_CHANNEL_EXCEPTION_CAUGHT;
    private static final int MASK_CHANNEL_REGISTERED;
    private static final int MASK_CHANNEL_UNREGISTERED;
    private static final int MASK_CHANNEL_ACTIVE;
    private static final int MASK_CHANNEL_INACTIVE;
    private static final int MASK_CHANNEL_SHUTDOWN;
    private static final int MASK_CHANNEL_READ;
    private static final int MASK_CHANNEL_READ_COMPLETE;
    private static final int MASK_CHANNEL_INBOUND_EVENT;
    private static final int MASK_CHANNEL_WRITABILITY_CHANGED;
    private static final int MASK_BIND;
    private static final int MASK_CONNECT;
    private static final int MASK_DISCONNECT;
    private static final int MASK_CLOSE;
    private static final int MASK_SHUTDOWN;
    private static final int MASK_REGISTER;
    private static final int MASK_DEREGISTER;
    private static final int MASK_READ;
    private static final int MASK_WRITE;
    private static final int MASK_FLUSH;
    private static final int MASK_SEND_OUTBOUND_EVENT;
    private static final int MASK_PENDING_OUTBOUND_BYTES;
    private static final int MASK_CHANNEL_TIMEOUT_EVENT;
    private static final int MASK_CHANNEL_READ_ID;
    private static final int MASK_WRITE_ID;
    private static final int MASK_OPEN;
    private static final int MASK_ALL_INBOUND;
    private static final int MASK_ALL_OUTBOUND;
    private static final ActorThreadLocal<HashMap<Class<? extends ChannelHandler>, Object>> MASKS;
    public static final ChannelHandlerMask$ MODULE$;

    private ChannelHandlerMask$() {
    }

    static {
        MODULE$ = new ChannelHandlerMask$();
        MASK_CHANNEL_EXCEPTION_CAUGHT = 1;
        MASK_CHANNEL_REGISTERED = 2;
        MASK_CHANNEL_UNREGISTERED = 4;
        MASK_CHANNEL_ACTIVE = 8;
        MASK_CHANNEL_INACTIVE = 16;
        MASK_CHANNEL_SHUTDOWN = 32;
        MASK_CHANNEL_READ = 64;
        MASK_CHANNEL_READ_COMPLETE = 128;
        MASK_CHANNEL_INBOUND_EVENT = 256;
        MASK_CHANNEL_WRITABILITY_CHANGED = 512;
        MASK_BIND = 1024;
        MASK_CONNECT = 2048;
        MASK_DISCONNECT = 4096;
        MASK_CLOSE = 8192;
        MASK_SHUTDOWN = 16384;
        MASK_REGISTER = 32768;
        MASK_DEREGISTER = 65536;
        MASK_READ = 131072;
        MASK_WRITE = 262144;
        MASK_FLUSH = 524288;
        MASK_SEND_OUTBOUND_EVENT = 0x100000;
        MASK_PENDING_OUTBOUND_BYTES = 0x200000;
        MASK_CHANNEL_TIMEOUT_EVENT = 0x400000;
        MASK_CHANNEL_READ_ID = 0x800000;
        MASK_WRITE_ID = 0x1000000;
        MASK_OPEN = 0x2000000;
        MASK_ALL_INBOUND = MODULE$.MASK_CHANNEL_EXCEPTION_CAUGHT() | MODULE$.MASK_CHANNEL_REGISTERED() | MODULE$.MASK_CHANNEL_UNREGISTERED() | MODULE$.MASK_CHANNEL_ACTIVE() | MODULE$.MASK_CHANNEL_INACTIVE() | MODULE$.MASK_CHANNEL_SHUTDOWN() | MODULE$.MASK_CHANNEL_READ() | MODULE$.MASK_CHANNEL_READ_COMPLETE() | MODULE$.MASK_CHANNEL_WRITABILITY_CHANGED() | MODULE$.MASK_CHANNEL_INBOUND_EVENT() | MODULE$.MASK_CHANNEL_TIMEOUT_EVENT() | MODULE$.MASK_CHANNEL_READ_ID();
        MASK_ALL_OUTBOUND = MODULE$.MASK_BIND() | MODULE$.MASK_CONNECT() | MODULE$.MASK_DISCONNECT() | MODULE$.MASK_CLOSE() | MODULE$.MASK_SHUTDOWN() | MODULE$.MASK_REGISTER() | MODULE$.MASK_DEREGISTER() | MODULE$.MASK_READ() | MODULE$.MASK_WRITE() | MODULE$.MASK_FLUSH() | MODULE$.MASK_SEND_OUTBOUND_EVENT() | MODULE$.MASK_PENDING_OUTBOUND_BYTES() | MODULE$.MASK_WRITE_ID() | MODULE$.MASK_OPEN();
        MASKS = new ActorThreadLocal<HashMap<Class<? extends ChannelHandler>, Object>>(){

            public HashMap initialValue() {
                return HashMap$.MODULE$.empty();
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ChannelHandlerMask$.class);
    }

    public int MASK_CHANNEL_EXCEPTION_CAUGHT() {
        return MASK_CHANNEL_EXCEPTION_CAUGHT;
    }

    public int MASK_CHANNEL_REGISTERED() {
        return MASK_CHANNEL_REGISTERED;
    }

    public int MASK_CHANNEL_UNREGISTERED() {
        return MASK_CHANNEL_UNREGISTERED;
    }

    public int MASK_CHANNEL_ACTIVE() {
        return MASK_CHANNEL_ACTIVE;
    }

    public int MASK_CHANNEL_INACTIVE() {
        return MASK_CHANNEL_INACTIVE;
    }

    public int MASK_CHANNEL_SHUTDOWN() {
        return MASK_CHANNEL_SHUTDOWN;
    }

    public int MASK_CHANNEL_READ() {
        return MASK_CHANNEL_READ;
    }

    public int MASK_CHANNEL_READ_COMPLETE() {
        return MASK_CHANNEL_READ_COMPLETE;
    }

    public int MASK_CHANNEL_INBOUND_EVENT() {
        return MASK_CHANNEL_INBOUND_EVENT;
    }

    public int MASK_CHANNEL_WRITABILITY_CHANGED() {
        return MASK_CHANNEL_WRITABILITY_CHANGED;
    }

    public int MASK_BIND() {
        return MASK_BIND;
    }

    public int MASK_CONNECT() {
        return MASK_CONNECT;
    }

    public int MASK_DISCONNECT() {
        return MASK_DISCONNECT;
    }

    public int MASK_CLOSE() {
        return MASK_CLOSE;
    }

    public int MASK_SHUTDOWN() {
        return MASK_SHUTDOWN;
    }

    public int MASK_REGISTER() {
        return MASK_REGISTER;
    }

    public int MASK_DEREGISTER() {
        return MASK_DEREGISTER;
    }

    public int MASK_READ() {
        return MASK_READ;
    }

    public int MASK_WRITE() {
        return MASK_WRITE;
    }

    public int MASK_FLUSH() {
        return MASK_FLUSH;
    }

    public int MASK_SEND_OUTBOUND_EVENT() {
        return MASK_SEND_OUTBOUND_EVENT;
    }

    public int MASK_PENDING_OUTBOUND_BYTES() {
        return MASK_PENDING_OUTBOUND_BYTES;
    }

    public int MASK_CHANNEL_TIMEOUT_EVENT() {
        return MASK_CHANNEL_TIMEOUT_EVENT;
    }

    public int MASK_CHANNEL_READ_ID() {
        return MASK_CHANNEL_READ_ID;
    }

    public int MASK_WRITE_ID() {
        return MASK_WRITE_ID;
    }

    public int MASK_OPEN() {
        return MASK_OPEN;
    }

    public int mask(Class<? extends ChannelHandler> clazz) {
        BoxedUnit boxedUnit;
        HashMap<Class<? extends ChannelHandler>, Object> map = MASKS.get();
        int mask = 0;
        if (!map.contains(clazz)) {
            mask = this.mask0(clazz);
            boxedUnit = map.put(clazz, (Object)BoxesRunTime.boxToInteger((int)mask));
        } else {
            mask = BoxesRunTime.unboxToInt((Object)map.apply(clazz));
            boxedUnit = BoxedUnit.UNIT;
        }
        return mask;
    }

    private int mask0(Class<? extends ChannelHandler> handlerType) {
        int mask = MASK_ALL_INBOUND | MASK_ALL_OUTBOUND;
        if (this.isSkip(handlerType, "channelExceptionCaught", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Throwable.class}))) {
            mask &= ~this.MASK_CHANNEL_EXCEPTION_CAUGHT();
        }
        if (this.isSkip(handlerType, "channelRegistered", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class}))) {
            mask &= ~this.MASK_CHANNEL_REGISTERED();
        }
        if (this.isSkip(handlerType, "channelUnregistered", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class}))) {
            mask &= ~this.MASK_CHANNEL_UNREGISTERED();
        }
        if (this.isSkip(handlerType, "channelActive", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class}))) {
            mask &= ~this.MASK_CHANNEL_ACTIVE();
        }
        if (this.isSkip(handlerType, "channelInactive", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class}))) {
            mask &= ~this.MASK_CHANNEL_INACTIVE();
        }
        if (this.isSkip(handlerType, "channelShutdown", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, ChannelShutdownDirection.class}))) {
            mask &= ~this.MASK_CHANNEL_SHUTDOWN();
        }
        if (this.isSkip(handlerType, "channelRead", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Object.class}))) {
            mask &= ~this.MASK_CHANNEL_READ();
        }
        if (this.isSkip(handlerType, "channelRead", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Object.class, Long.TYPE}))) {
            mask &= ~this.MASK_CHANNEL_READ_ID();
        }
        if (this.isSkip(handlerType, "channelReadComplete", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class}))) {
            mask &= ~this.MASK_CHANNEL_READ_COMPLETE();
        }
        if (this.isSkip(handlerType, "channelWritabilityChanged", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class}))) {
            mask &= ~this.MASK_CHANNEL_WRITABILITY_CHANGED();
        }
        if (this.isSkip(handlerType, "channelInboundEvent", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Object.class}))) {
            mask &= ~this.MASK_CHANNEL_INBOUND_EVENT();
        }
        if (this.isSkip(handlerType, "channelTimeoutEvent", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Long.TYPE}))) {
            mask &= ~this.MASK_CHANNEL_TIMEOUT_EVENT();
        }
        if (this.isSkip(handlerType, "bind", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, SocketAddress.class, ChannelFuture.class}))) {
            mask &= ~this.MASK_BIND();
        }
        if (this.isSkip(handlerType, "connect", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, SocketAddress.class, Option.class, ChannelFuture.class}))) {
            mask &= ~this.MASK_CONNECT();
        }
        if (this.isSkip(handlerType, "disconnect", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, ChannelFuture.class}))) {
            mask &= ~this.MASK_DISCONNECT();
        }
        if (this.isSkip(handlerType, "close", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, ChannelFuture.class}))) {
            mask &= ~this.MASK_CLOSE();
        }
        if (this.isSkip(handlerType, "shutdown", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, ChannelShutdownDirection.class, ChannelFuture.class}))) {
            mask &= ~this.MASK_SHUTDOWN();
        }
        if (this.isSkip(handlerType, "register", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, ChannelFuture.class}))) {
            mask &= ~this.MASK_REGISTER();
        }
        if (this.isSkip(handlerType, "deregister", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, ChannelFuture.class}))) {
            mask &= ~this.MASK_DEREGISTER();
        }
        if (this.isSkip(handlerType, "read", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, ReadPlan.class}))) {
            mask &= ~this.MASK_READ();
        }
        if (this.isSkip(handlerType, "write", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Object.class}))) {
            mask &= ~this.MASK_WRITE();
        }
        if (this.isSkip(handlerType, "write", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Object.class, Long.TYPE}))) {
            mask &= ~this.MASK_WRITE_ID();
        }
        if (this.isSkip(handlerType, "flush", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class}))) {
            mask &= ~this.MASK_FLUSH();
        }
        if (this.isSkip(handlerType, "sendOutboundEvent", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Object.class}))) {
            mask &= ~this.MASK_SEND_OUTBOUND_EVENT();
        }
        if (this.isSkip(handlerType, "pendingOutboundBytes", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class}))) {
            mask &= ~this.MASK_PENDING_OUTBOUND_BYTES();
        }
        if (this.isSkip(handlerType, "open", (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ChannelHandlerContext.class, Path.class, Seq.class, Seq.class, ChannelFuture.class}))) {
            mask &= ~this.MASK_OPEN();
        }
        return mask;
    }

    public boolean isInbound(Class<? extends ChannelHandler> clazz) {
        return (this.mask(clazz) & MASK_ALL_INBOUND) != 0;
    }

    public boolean isOutbound(Class<? extends ChannelHandler> clazz) {
        return (this.mask(clazz) & MASK_ALL_OUTBOUND) != 0;
    }

    private boolean isSkip(Class<?> handlerType, String methodName, Seq<Class<?>> paramTypes) {
        boolean skip = false;
        try {
            skip = handlerType.getMethod(methodName, (Class[])Arrays$.MODULE$.seqToArray(paramTypes, Class.class)).isAnnotationPresent(Skip.class);
        }
        catch (Throwable throwable) {}
        return skip;
    }
}

