/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.channel.message;

import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.message.MaxMessagesReadPlanFactory$ServerChannelReadPlanFactory$;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.channel.message.ReadPlanFactory;
import scala.runtime.Scala3RunTime$;

public abstract class MaxMessagesReadPlanFactory
implements ReadPlanFactory {
    private final int maxMessagesPerRead;

    public MaxMessagesReadPlanFactory(int maxMessagesPerRead) {
        this.maxMessagesPerRead = maxMessagesPerRead;
        if (maxMessagesPerRead <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
    }

    private int maxMessagesPerRead() {
        return this.maxMessagesPerRead;
    }

    public MaxMessagesReadPlanFactory() {
        this(1);
    }

    @Override
    public ReadPlan newPlan(Channel channel) {
        return this.newMaxMessagePlan(this.maxMessagesPerRead());
    }

    public abstract MaxMessageReadPlan newMaxMessagePlan(int var1);

    public static abstract class MaxMessageReadPlan
    implements ReadPlan {
        private final int maxMessagesPerRead;
        private int messagesCompleted;
        private int messagesPrepared;

        public MaxMessageReadPlan(int maxMessagesPerRead) {
            this.maxMessagesPerRead = maxMessagesPerRead;
            if (maxMessagesPerRead <= 0) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            this.messagesCompleted = 0;
            this.messagesPrepared = 0;
        }

        public int maxMessagesPerRead() {
            return this.maxMessagesPerRead;
        }

        @Override
        public boolean lastRead(int attemptedBytesRead, int actualBytesRead, int numMessagesRead) {
            if (numMessagesRead > 0) {
                this.messagesCompleted += numMessagesRead;
            }
            return this.messagesCompleted < this.maxMessagesPerRead();
        }

        @Override
        public void readComplete() {
            this.messagesCompleted = 0;
            this.messagesPrepared = 0;
        }

        @Override
        public int estimatedNextSize() {
            ++this.messagesPrepared;
            if (this.messagesPrepared < this.maxMessagesPerRead()) {
                return 1;
            }
            return 0;
        }
    }

    public static class ServerChannelReadPlanFactory
    extends MaxMessagesReadPlanFactory {
        public static int $lessinit$greater$default$1() {
            return MaxMessagesReadPlanFactory$ServerChannelReadPlanFactory$.MODULE$.$lessinit$greater$default$1();
        }

        public ServerChannelReadPlanFactory(int maxMessagesPerRead) {
            super(maxMessagesPerRead);
        }

        @Override
        public MaxMessageReadPlan newMaxMessagePlan(int maxMessagesPerRead) {
            return new MaxMessageReadPlan(maxMessagesPerRead){

                public int estimatedNextSize() {
                    return 128 * super.estimatedNextSize();
                }
            };
        }
    }
}

