/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.ioc;

import cc.otavia.core.ioc.Module;
import cc.otavia.core.ioc.ModuleListener;
import cc.otavia.core.system.ActorSystem;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AbstractModule
implements Module {
    private final ConcurrentLinkedQueue<ModuleListener> listeners = new ConcurrentLinkedQueue();
    private volatile boolean ld = false;
    private volatile ActorSystem system;

    @Override
    public boolean loaded() {
        return this.ld;
    }

    @Override
    public void addListener(ModuleListener listener) {
        if (!this.ld) {
            this.listeners.add(listener);
            return;
        }
        this.callback(listener);
    }

    @Override
    public void onLoaded(ActorSystem system) {
        this.system = system;
        this.ld = true;
        while (!this.listeners.isEmpty()) {
            ModuleListener listener = this.listeners.poll();
            this.callback(listener);
        }
    }

    private final void callback(ModuleListener listener) {
        try {
            listener.onLoaded(this.system);
        }
        catch (Throwable throwable) {}
    }
}

