/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.ioc;

import cc.otavia.core.address.Address;
import cc.otavia.core.ioc.Bean;
import cc.otavia.core.ioc.Bean$;
import cc.otavia.core.system.ActorSystem;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class BeanManager {
    private final ActorSystem system;
    private final ConcurrentHashMap<String, Bean> beans;
    private final ConcurrentHashMap<String, String> qualifiers;
    private final ConcurrentHashMap<String, Buffer<String>> superTypes;

    public BeanManager(ActorSystem system) {
        this.system = system;
        this.beans = new ConcurrentHashMap();
        this.qualifiers = new ConcurrentHashMap();
        this.superTypes = new ConcurrentHashMap();
    }

    public ActorSystem system() {
        return this.system;
    }

    public void register(Class<?> clz, Address<?> address, Option<String> qualifier, boolean primary) {
        Object object;
        Bean bean = Bean$.MODULE$.apply(clz, address, primary);
        this.beans.put(bean.name(), bean);
        Option<String> option = qualifier;
        if (option instanceof Some) {
            String name = (String)((Some)option).value();
            object = this.qualifiers.put(name, bean.name());
        } else if (None$.MODULE$.equals(option)) {
            object = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        bean.superClasses().withFilter((Function1 & Serializable)sp2 -> {
            String string = sp2;
            String string2 = bean.name();
            return string == null ? string2 != null : !string.equals(string2);
        }).foreach((Function1 & Serializable)sp2 -> {
            Buffer<String> value = null;
            value = !this.superTypes.containsKey(sp2) ? new Buffer<String>() : this.superTypes.get(sp2);
            return (Buffer)value.addOne((Object)bean.name());
        });
    }

    public Option<String> register$default$3() {
        return None$.MODULE$;
    }

    public boolean register$default$4() {
        return false;
    }

    public Address<?> getBean(String qualifier, Class<?> clz) {
        if (this.qualifiers.containsKey(qualifier)) {
            String name = this.qualifiers.get(qualifier);
            Bean bean = this.beans.get(name);
            if (clz.isAssignableFrom(bean.clz())) {
                return bean.address();
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException();
    }

    public Address<?> getBean(Class<?> clz) {
        String spName = clz.getName();
        if (this.superTypes.containsKey(spName)) {
            Buffer<String> seq = this.superTypes.get(spName);
            if (seq.length() == 1) {
                Bean bean = this.beans.get(seq.head());
                return bean.address();
            }
            ObjectRef bean = ObjectRef.create(null);
            seq.foreach((Function1)(JProcedure1 & Serializable)name -> {
                Bean b = this.beans.get(name);
                if (b.primary()) {
                    if ((Bean)bean$3.elem == null) {
                        Bean bean = b;
                        bean$3.elem = bean;
                        bean = null;
                        return;
                    }
                    throw new IllegalStateException();
                }
            });
            if ((Bean)bean.elem != null) {
                return ((Bean)bean.elem).address();
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    public int count() {
        return this.beans.size();
    }
}

