/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.reactor;

import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.reactor.Reactor;
import cc.otavia.core.reactor.Reactor$;
import cc.otavia.core.reactor.Reactor$Command$;
import cc.otavia.core.reactor.Reactor$Command$Bind$;
import cc.otavia.core.reactor.Reactor$Command$Close$;
import cc.otavia.core.reactor.Reactor$Command$Connect$;
import cc.otavia.core.reactor.Reactor$Command$Deregister$;
import cc.otavia.core.reactor.Reactor$Command$Disconnect$;
import cc.otavia.core.reactor.Reactor$Command$Flush$;
import cc.otavia.core.reactor.Reactor$Command$Open$;
import cc.otavia.core.reactor.Reactor$Command$Read$;
import cc.otavia.core.reactor.Reactor$Command$Register$;
import cc.otavia.core.reactor.Reactor$Command$Shutdown$;
import cc.otavia.core.util.Nextable;
import java.net.SocketAddress;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Option;
import scala.collection.immutable.Seq;

public interface Reactor {
    public static int DEFAULT_MAX_TASKS_PER_RUN() {
        return Reactor$.MODULE$.DEFAULT_MAX_TASKS_PER_RUN();
    }

    public static void register$(Reactor $this, Channel channel) {
        $this.register(channel);
    }

    default public void register(Channel channel) {
        Command.Register command = Reactor$Command$Register$.MODULE$.apply(channel);
        this.submit(command);
    }

    public static void deregister$(Reactor $this, Channel channel) {
        $this.deregister(channel);
    }

    default public void deregister(Channel channel) {
        Command.Deregister command = Reactor$Command$Deregister$.MODULE$.apply(channel);
        this.submit(command);
    }

    public static void bind$(Reactor $this, Channel channel, SocketAddress local) {
        $this.bind(channel, local);
    }

    default public void bind(Channel channel, SocketAddress local) {
        Command.Bind command = Reactor$Command$Bind$.MODULE$.apply(channel, local);
        this.submit(command);
    }

    public static void open$(Reactor $this, Channel channel, Path path, Seq options, Seq attrs) {
        $this.open(channel, path, (Seq<OpenOption>)options, attrs);
    }

    default public void open(Channel channel, Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs) {
        Command.Open command = Reactor$Command$Open$.MODULE$.apply(channel, path, options, attrs);
        this.submit(command);
    }

    public static void connect$(Reactor $this, Channel channel, SocketAddress remote, Option local, boolean fast) {
        $this.connect(channel, remote, (Option<SocketAddress>)local, fast);
    }

    default public void connect(Channel channel, SocketAddress remote, Option<SocketAddress> local, boolean fast) {
        Command.Connect command = Reactor$Command$Connect$.MODULE$.apply(channel, remote, local, fast);
        this.submit(command);
    }

    public static void disconnect$(Reactor $this, Channel channel) {
        $this.disconnect(channel);
    }

    default public void disconnect(Channel channel) {
        Command.Disconnect command = Reactor$Command$Disconnect$.MODULE$.apply(channel);
        this.submit(command);
    }

    public static void close$(Reactor $this, Channel channel) {
        $this.close(channel);
    }

    default public void close(Channel channel) {
        Command.Close command = Reactor$Command$Close$.MODULE$.apply(channel);
        this.submit(command);
    }

    public static void shutdown$(Reactor $this, Channel channel, ChannelShutdownDirection direction) {
        $this.shutdown(channel, direction);
    }

    default public void shutdown(Channel channel, ChannelShutdownDirection direction) {
        Command.Shutdown command = Reactor$Command$Shutdown$.MODULE$.apply(channel, direction);
        this.submit(command);
    }

    public static void read$(Reactor $this, Channel channel, ReadPlan plan) {
        $this.read(channel, plan);
    }

    default public void read(Channel channel, ReadPlan plan) {
        Command.Read command = Reactor$Command$Read$.MODULE$.apply(channel, plan);
        this.submit(command);
    }

    public static void flush$(Reactor $this, Channel channel, Object payload) {
        $this.flush(channel, payload);
    }

    default public void flush(Channel channel, Object payload) {
        Command.Flush command = Reactor$Command$Flush$.MODULE$.apply(channel, payload);
        this.submit(command);
    }

    public void submit(Command var1);

    public static abstract class Command
    implements Nextable {
        private volatile Nextable cc$otavia$core$util$Nextable$$n;

        public static int ordinal(Command command) {
            return Reactor$Command$.MODULE$.ordinal(command);
        }

        public Command() {
            Nextable.$init$(this);
        }

        @Override
        public Nextable cc$otavia$core$util$Nextable$$n() {
            return this.cc$otavia$core$util$Nextable$$n;
        }

        @Override
        public void cc$otavia$core$util$Nextable$$n_$eq(Nextable x$1) {
            this.cc$otavia$core$util$Nextable$$n = x$1;
        }

        public abstract Channel channel();
    }
}

