/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.slf4a;

import cc.otavia.common.Report$;
import cc.otavia.core.slf4a.ILoggerFactory;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.nop.NOPServiceProvider;
import cc.otavia.core.slf4a.spi.SLF4AServiceProvider;
import cc.otavia.core.system.ActorSystem;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import scala.Function1;
import scala.MatchError;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class LoggerFactory$
implements Serializable {
    private static final int UNINITIALIZED;
    private static final int ONGOING_INITIALIZATION;
    private static final int FAILED_INITIALIZATION;
    private static final int SUCCESSFUL_INITIALIZATION;
    private static final int NOP_FALLBACK_INITIALIZATION;
    private static volatile int INITIALIZATION_STATE;
    private static volatile SLF4AServiceProvider PROVIDER;
    private static final NOPServiceProvider NOP_SERVICE_PROVIDER;
    public static final LoggerFactory$ MODULE$;

    private LoggerFactory$() {
    }

    static {
        MODULE$ = new LoggerFactory$();
        UNINITIALIZED = 0;
        ONGOING_INITIALIZATION = 1;
        FAILED_INITIALIZATION = 2;
        SUCCESSFUL_INITIALIZATION = 3;
        NOP_FALLBACK_INITIALIZATION = 4;
        INITIALIZATION_STATE = MODULE$.UNINITIALIZED();
        NOP_SERVICE_PROVIDER = new NOPServiceProvider();
        NOP_SERVICE_PROVIDER.initialize();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LoggerFactory$.class);
    }

    public Logger getLogger(Class<?> clz, ActorSystem system) {
        Logger logger = this.getLogger(clz.getName(), system);
        return logger;
    }

    public Logger getLogger(String name, ActorSystem system) {
        ILoggerFactory iLoggerFactory = this.getILoggerFactory();
        return iLoggerFactory.getLogger(name, system);
    }

    public int UNINITIALIZED() {
        return UNINITIALIZED;
    }

    public int ONGOING_INITIALIZATION() {
        return ONGOING_INITIALIZATION;
    }

    public int FAILED_INITIALIZATION() {
        return FAILED_INITIALIZATION;
    }

    public int SUCCESSFUL_INITIALIZATION() {
        return SUCCESSFUL_INITIALIZATION;
    }

    public int NOP_FALLBACK_INITIALIZATION() {
        return NOP_FALLBACK_INITIALIZATION;
    }

    public int INITIALIZATION_STATE() {
        return INITIALIZATION_STATE;
    }

    public void INITIALIZATION_STATE_$eq(int x$1) {
        INITIALIZATION_STATE = x$1;
    }

    private ILoggerFactory getILoggerFactory() {
        return this.getProvider().getLoggerFactory();
    }

    private SLF4AServiceProvider getProvider() {
        SLF4AServiceProvider sLF4AServiceProvider;
        LoggerFactory$ loggerFactory$ = this;
        synchronized (loggerFactory$) {
            SLF4AServiceProvider sLF4AServiceProvider2;
            if (this.INITIALIZATION_STATE() == this.UNINITIALIZED()) {
                this.INITIALIZATION_STATE_$eq(this.ONGOING_INITIALIZATION());
                this.performInitialization();
            }
            int n = this.INITIALIZATION_STATE();
            if (this.SUCCESSFUL_INITIALIZATION() == n) {
                sLF4AServiceProvider2 = PROVIDER;
            } else if (this.NOP_FALLBACK_INITIALIZATION() == n) {
                sLF4AServiceProvider2 = NOP_SERVICE_PROVIDER;
            } else {
                if (this.FAILED_INITIALIZATION() == n) {
                    throw new IllegalStateException();
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            sLF4AServiceProvider = sLF4AServiceProvider2;
        }
        return sLF4AServiceProvider;
    }

    public void reset() {
        this.INITIALIZATION_STATE_$eq(this.UNINITIALIZED());
    }

    private final void performInitialization() {
        this.bind();
    }

    private final void bind() {
        try {
            ArrayBuffer<SLF4AServiceProvider> providersList = this.findServiceProviders();
            this.reportMultipleBindingAmbiguity(providersList);
            if (providersList.nonEmpty()) {
                PROVIDER = (SLF4AServiceProvider)providersList.head();
                PROVIDER.initialize();
                this.INITIALIZATION_STATE_$eq(this.SUCCESSFUL_INITIALIZATION());
                this.reportActualBinding(providersList);
            } else {
                this.INITIALIZATION_STATE_$eq(this.NOP_FALLBACK_INITIALIZATION());
                Report$.MODULE$.report("No SLF4A providers were found.", Report$.MODULE$.report$default$2());
                Report$.MODULE$.report("Defaulting to no-operation (NOP) logger implementation.", Report$.MODULE$.report$default$2());
            }
        }
        catch (Exception e) {
            this.failedBinding(e);
            throw new IllegalStateException("Unexpected initialization failure", e);
        }
    }

    private ArrayBuffer<SLF4AServiceProvider> findServiceProviders() {
        ClassLoader classLoaderOfLoggerFactory = this.getClass().getClassLoader();
        ServiceLoader<SLF4AServiceProvider> serviceLoader = this.getServiceLoader(classLoaderOfLoggerFactory);
        ArrayBuffer providerList = new ArrayBuffer();
        Iterator<SLF4AServiceProvider> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            this.safelyInstantiate((ArrayBuffer<SLF4AServiceProvider>)providerList, iterator);
        }
        return providerList;
    }

    private ServiceLoader<SLF4AServiceProvider> getServiceLoader(ClassLoader classLoaderOfLoggerFactory) {
        ServiceLoader serviceLoader;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            serviceLoader = ServiceLoader.load(SLF4AServiceProvider.class, classLoaderOfLoggerFactory);
        } else {
            PrivilegedAction<ServiceLoader> action = () -> ServiceLoader.load(SLF4AServiceProvider.class, classLoaderOfLoggerFactory);
            serviceLoader = AccessController.doPrivileged(action);
        }
        ServiceLoader serviceLoader2 = serviceLoader;
        return serviceLoader2;
    }

    private void safelyInstantiate(ArrayBuffer<SLF4AServiceProvider> providerList, Iterator<SLF4AServiceProvider> iterator) {
        try {
            SLF4AServiceProvider provider = iterator.next();
            providerList.addOne((Object)provider);
        }
        catch (ServiceConfigurationError e) {
            Report$.MODULE$.report(new StringBuilder(48).append("A SLF4A service provider failed to instantiate:\n").append(e.getMessage()).toString(), Report$.MODULE$.report$default$2());
        }
    }

    private boolean isAmbiguousProviderList(ArrayBuffer<SLF4AServiceProvider> providerList) {
        return providerList.length() > 1;
    }

    private void reportMultipleBindingAmbiguity(ArrayBuffer<SLF4AServiceProvider> providerList) {
        if (this.isAmbiguousProviderList(providerList)) {
            Report$.MODULE$.report("Class path contains multiple SLF4A providers.", Report$.MODULE$.report$default$2());
            providerList.foreach((Function1)(JProcedure1 & Serializable)provider -> Report$.MODULE$.report(new StringBuilder(17).append("Found provider [").append(provider).append("]").toString(), Report$.MODULE$.report$default$2()));
            return;
        }
    }

    private void reportActualBinding(ArrayBuffer<SLF4AServiceProvider> providerList) {
        if (providerList.nonEmpty() && this.isAmbiguousProviderList(providerList)) {
            Report$.MODULE$.report(new StringBuilder(29).append("Actual provider is of type [").append(providerList.head()).append("]").toString(), Report$.MODULE$.report$default$2());
            return;
        }
    }

    private void failedBinding(Throwable t) {
        this.INITIALIZATION_STATE_$eq(this.FAILED_INITIALIZATION());
        Report$.MODULE$.report("Failed to instantiate SLF4A LoggerFactory", t);
    }
}

