/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.stack;

import cc.otavia.core.stack.FutureDispatcher$;
import cc.otavia.core.stack.MessagePromise;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.function.JProcedure1;

public abstract class FutureDispatcher {
    private MessagePromise<?>[] table;
    private int mask = FutureDispatcher$.MODULE$.tableSizeFor(this.initialCapacity()) - 1;
    private int threshold = this.newThreshold(FutureDispatcher$.MODULE$.tableSizeFor(this.initialCapacity()));
    private int contentSize = 0;

    public static int tableSizeFor(int n) {
        return FutureDispatcher$.MODULE$.tableSizeFor(n);
    }

    private final double loadFactor() {
        return 2.0;
    }

    private final int initialCapacity() {
        return 16;
    }

    private int newThreshold(int size) {
        return (int)((double)size * this.loadFactor());
    }

    public final void push(MessagePromise<?> promise) {
        if (this.table == null) {
            this.table = new MessagePromise[FutureDispatcher$.MODULE$.tableSizeFor(this.initialCapacity())];
        } else if (this.contentSize + 1 >= this.threshold) {
            this.resizeTable(this.table.length * 2);
        }
        this.put0(promise);
    }

    private final void put0(MessagePromise<?> promise) {
        MessagePromise<?> old;
        long id$proxy1 = promise.id();
        int idx = (int)(id$proxy1 & (long)this.cc$otavia$core$stack$FutureDispatcher$$inline$mask());
        MessagePromise<?> messagePromise = this.table[idx];
        if (messagePromise == null) {
            this.table[idx] = promise;
            return;
        }
        MessagePromise<?> tail = old = messagePromise;
        while (tail.hashNext() != null) {
            tail = tail.hashNext();
        }
        tail.hashNext_$eq(promise);
    }

    public final MessagePromise<?> pop(long id) {
        MessagePromise<?> promise;
        MessagePromise<?> messagePromise;
        int idx = (int)(id & (long)this.cc$otavia$core$stack$FutureDispatcher$$inline$mask());
        MessagePromise<?> messagePromise2 = this.table[idx];
        if (messagePromise2 == null) {
            messagePromise = null;
        } else {
            MessagePromise<?> node = messagePromise2;
            if (node.id() == id) {
                this.table[idx] = node.hashNext();
                --this.contentSize;
                node.hashNext_$eq(null);
                messagePromise = node;
            } else {
                MessagePromise<?> cursor;
                MessagePromise<?> node2;
                MessagePromise<?> prev = node2 = messagePromise2;
                for (cursor = node2.hashNext(); cursor != null && cursor.id() != id; cursor = cursor.hashNext()) {
                    prev = cursor;
                }
                if (cursor != null) {
                    prev.hashNext_$eq(cursor.hashNext());
                    --this.contentSize;
                    cursor.hashNext_$eq(null);
                }
                messagePromise = promise = cursor;
            }
        }
        if (this.table.length >= this.initialCapacity() * 4 && this.contentSize < this.table.length / 2) {
            this.resizeTable(this.table.length / 2);
        }
        return promise;
    }

    public final boolean contains(long id) {
        MessagePromise<?> messagePromise;
        if (this.cc$otavia$core$stack$FutureDispatcher$$inline$table() != null) {
            FutureDispatcher FutureDispatcher_this = this;
            MessagePromise<?> messagePromise2 = this.cc$otavia$core$stack$FutureDispatcher$$inline$table()[(int)(id & (long)FutureDispatcher_this.cc$otavia$core$stack$FutureDispatcher$$inline$mask())];
            if (messagePromise2 == null) {
                messagePromise = null;
            } else {
                MessagePromise<?> promise = messagePromise2;
                messagePromise = this.inline$findNode$i1(promise, id);
            }
        } else {
            messagePromise = null;
        }
        return messagePromise != null;
    }

    private final void resizeTable(int newLen) {
        Object[] oldTable = this.table;
        this.table = new MessagePromise[newLen];
        this.mask = newLen - 1;
        this.threshold = this.newThreshold(this.table.length);
        Object object = Predef$.MODULE$.refArrayOps(oldTable);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)node -> {
            for (MessagePromise<?> cursor = node; cursor != null; cursor = cursor.hashNext()) {
                MessagePromise<?> promise = cursor;
                promise.hashNext_$eq(null);
                this.put0(promise);
            }
        });
    }

    public final int cc$otavia$core$stack$FutureDispatcher$$inline$mask() {
        return this.mask;
    }

    public final MessagePromise<?>[] cc$otavia$core$stack$FutureDispatcher$$inline$table() {
        return this.table;
    }

    public MessagePromise<?> inline$findNode$i1(MessagePromise<?> x$0, long id) {
        return x$0.findNode(id);
    }
}

