/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.stack;

import cc.otavia.core.actor.AbstractActor;
import cc.otavia.core.cache.Poolable;
import cc.otavia.core.stack.AbstractPromise;
import cc.otavia.core.stack.PromiseIterator;
import cc.otavia.core.stack.PromiseIterator$;
import cc.otavia.core.stack.StackState;
import cc.otavia.core.stack.StackState$;
import cc.otavia.core.util.Chainable;
import scala.MatchError;

public abstract class Stack
implements Chainable,
Poolable {
    private Chainable cc$otavia$core$util$Chainable$$n;
    private Chainable cc$otavia$core$util$Chainable$$p;
    private Thread cc$otavia$core$cache$Poolable$$thread;
    private StackState stackState;
    private boolean error;
    private AbstractPromise<?> completedHead;
    private AbstractPromise<?> completedTail;
    private AbstractPromise<?> uncompletedHead;
    private AbstractPromise<?> uncompletedTail;
    private AbstractActor<?> actor;

    public Stack() {
        Chainable.$init$(this);
        Poolable.$init$(this);
        this.stackState = StackState$.MODULE$.start();
        this.error = false;
    }

    @Override
    public Chainable cc$otavia$core$util$Chainable$$n() {
        return this.cc$otavia$core$util$Chainable$$n;
    }

    @Override
    public Chainable cc$otavia$core$util$Chainable$$p() {
        return this.cc$otavia$core$util$Chainable$$p;
    }

    @Override
    public void cc$otavia$core$util$Chainable$$n_$eq(Chainable x$1) {
        this.cc$otavia$core$util$Chainable$$n = x$1;
    }

    @Override
    public void cc$otavia$core$util$Chainable$$p_$eq(Chainable x$1) {
        this.cc$otavia$core$util$Chainable$$p = x$1;
    }

    @Override
    public Thread cc$otavia$core$cache$Poolable$$thread() {
        return this.cc$otavia$core$cache$Poolable$$thread;
    }

    @Override
    public void cc$otavia$core$cache$Poolable$$thread_$eq(Thread x$1) {
        this.cc$otavia$core$cache$Poolable$$thread = x$1;
    }

    public AbstractActor<?> runtimeActor() {
        return this.actor;
    }

    public void setRuntimeActor(AbstractActor<?> a) {
        this.actor = a;
    }

    public final StackState state() {
        return this.stackState;
    }

    public final void setState(StackState stackState) {
        this.recycleCompletedPromises();
        this.stackState = stackState;
    }

    public void setFailed() {
        this.error = true;
    }

    public boolean isFailed() {
        return this.error;
    }

    public abstract boolean isDone();

    @Override
    public void cleanInstance() {
        this.recycleCompletedPromises();
        this.stackState = StackState$.MODULE$.start();
        this.error = false;
        this.actor = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveCompletedPromise(AbstractPromise<?> completed) {
        Chainable pre = completed.pre();
        Chainable next = completed.next();
        completed.deChain();
        Chainable chainable = pre;
        if (chainable == null) {
            Chainable chainable2 = next;
            if (chainable2 == null) {
                this.uncompletedHead = null;
                this.uncompletedTail = null;
            } else {
                if (chainable2 == null) throw new MatchError((Object)chainable2);
                Chainable nextNode = chainable2;
                nextNode.cleanPre();
                this.uncompletedHead = (AbstractPromise)nextNode;
            }
        } else {
            if (chainable == null) throw new MatchError((Object)chainable);
            Chainable preNode = chainable;
            Chainable chainable3 = next;
            if (chainable3 == null) {
                preNode.cleanNext();
                this.uncompletedTail = (AbstractPromise)preNode;
            } else {
                if (chainable3 == null) throw new MatchError((Object)chainable3);
                Chainable nextNode = chainable3;
                preNode.next_$eq(nextNode);
            }
        }
        if (this.completedHead == null) {
            this.completedHead = completed;
            this.completedTail = completed;
            return;
        }
        AbstractPromise<?> oldTail = this.completedTail;
        oldTail.next_$eq(completed);
        this.completedTail = completed;
    }

    public void addUncompletedPromise(AbstractPromise<?> uncompleted) {
        if (this.uncompletedHead == null) {
            this.uncompletedHead = uncompleted;
            this.uncompletedTail = uncompleted;
            return;
        }
        AbstractPromise<?> oldTail = this.uncompletedTail;
        oldTail.next_$eq(uncompleted);
        uncompleted.pre_$eq(oldTail);
        this.uncompletedTail = uncompleted;
    }

    public void addUncompletedPromiseIterator(PromiseIterator iterator) {
        if (this.uncompletedHead == null) {
            this.uncompletedHead = iterator.head();
            this.uncompletedTail = iterator.tail();
        } else {
            this.uncompletedTail.next_$eq(iterator.head());
            iterator.head().next_$eq(this.uncompletedTail);
            this.uncompletedTail = iterator.tail();
        }
        iterator.clean();
    }

    public boolean hasUncompletedPromise() {
        return this.uncompletedHead != null;
    }

    public boolean hasCompletedPromise() {
        return this.completedHead != null;
    }

    public int completedPromiseCount() {
        Chainable cursor = this.completedHead;
        int count = 0;
        while (cursor != null) {
            cursor = cursor.next();
            ++count;
        }
        return count;
    }

    public int uncompletedPromiseCount() {
        Chainable cursor = this.uncompletedHead;
        int count = 0;
        while (cursor != null) {
            cursor = cursor.next();
            ++count;
        }
        return count;
    }

    public final void recycleCompletedPromises() {
        this.completedTail = null;
        while (this.completedHead != null) {
            AbstractPromise<?> promise = this.completedHead;
            this.completedHead = (AbstractPromise)promise.next();
            promise.recycle();
        }
    }

    private void recycleUncompletedPromises() {
        this.uncompletedTail = null;
        while (this.uncompletedHead != null) {
            AbstractPromise<?> promise = this.uncompletedHead;
            this.uncompletedHead = (AbstractPromise)promise.next();
            this.uncompletedHead.cleanPre();
            promise.recycle();
        }
    }

    public PromiseIterator uncompletedPromises() {
        PromiseIterator iterator = PromiseIterator$.MODULE$.apply(this.uncompletedHead, this.uncompletedTail);
        this.uncompletedHead = null;
        this.uncompletedTail = null;
        return iterator;
    }
}

