/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.core.actor.AbstractActor;
import cc.otavia.core.actor.AcceptorActor;
import cc.otavia.core.actor.AutoCleanable;
import cc.otavia.core.actor.ChannelsActor;
import cc.otavia.core.actor.StateActor;
import cc.otavia.core.address.ActorAddress;
import cc.otavia.core.message.Ask;
import cc.otavia.core.message.Call;
import cc.otavia.core.message.Event;
import cc.otavia.core.message.ExceptionMessage;
import cc.otavia.core.message.Notice;
import cc.otavia.core.message.Reply;
import cc.otavia.core.system.ActorHouse$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.ActorSystem$;
import cc.otavia.core.system.ActorThread$;
import cc.otavia.core.system.HouseManager;
import cc.otavia.core.system.MailBox;
import cc.otavia.core.util.Nextable;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Int$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayDeque;
import scala.runtime.BoxesRunTime;

public class ActorHouse
implements Runnable {
    private final HouseManager manager;
    private AbstractActor<? extends Call> dweller;
    private int atp;
    private final MailBox noticeMailbox;
    private final MailBox askMailbox;
    private final MailBox replyMailbox;
    private final MailBox exceptionMailbox;
    private final MailBox eventMailbox;
    private final AtomicInteger status;
    private volatile ActorHouse preHouse;
    private volatile ActorHouse nextHouse;
    private volatile boolean _inHighPriorityQueue;

    public static int CHANNELS_ACTOR() {
        return ActorHouse$.MODULE$.CHANNELS_ACTOR();
    }

    public static int SERVER_CHANNELS_ACTOR() {
        return ActorHouse$.MODULE$.SERVER_CHANNELS_ACTOR();
    }

    public static int STATE_ACTOR() {
        return ActorHouse$.MODULE$.STATE_ACTOR();
    }

    public ActorHouse(HouseManager manager) {
        this.manager = manager;
        this.atp = 0;
        this.noticeMailbox = new MailBox(this);
        this.askMailbox = new MailBox(this);
        this.replyMailbox = new MailBox(this);
        this.exceptionMailbox = new MailBox(this);
        this.eventMailbox = new MailBox(this);
        this.status = new AtomicInteger(ActorHouse$.cc$otavia$core$system$ActorHouse$$$CREATED);
        this._inHighPriorityQueue = false;
    }

    public HouseManager manager() {
        return this.manager;
    }

    public AtomicInteger status() {
        return this.status;
    }

    public boolean highPriority() {
        return this.replyMailbox.size() > ActorHouse$.cc$otavia$core$system$ActorHouse$$$HIGH_PRIORITY_REPLY_SIZE || this.eventMailbox.size() > ActorHouse$.cc$otavia$core$system$ActorHouse$$$HIGH_PRIORITY_EVENT_SIZE || (double)this.dweller.stackEndRate() < 0.6;
    }

    public boolean inHighPriorityQueue() {
        return this._inHighPriorityQueue;
    }

    public void inHighPriorityQueue_$eq(boolean value) {
        this._inHighPriorityQueue = value;
    }

    public boolean isReady() {
        return this.status().get() == ActorHouse$.cc$otavia$core$system$ActorHouse$$$READY;
    }

    public boolean isRunning() {
        return this.status().get() == ActorHouse$.cc$otavia$core$system$ActorHouse$$$RUNNING;
    }

    public boolean isWaiting() {
        return this.status().get() == ActorHouse$.cc$otavia$core$system$ActorHouse$$$RUNNING;
    }

    public void next_$eq(ActorHouse house) {
        this.nextHouse = house;
    }

    public ActorHouse next() {
        return this.nextHouse;
    }

    public boolean isTail() {
        return this.nextHouse == null;
    }

    public void pre_$eq(ActorHouse house) {
        this.preHouse = house;
    }

    public ActorHouse pre() {
        return this.preHouse;
    }

    public boolean isHead() {
        return this.preHouse == null;
    }

    public void deChain() {
        this.nextHouse = null;
        this.preHouse = null;
    }

    public void setActor(AbstractActor<? extends Call> actor) {
        this.dweller = actor;
        AbstractActor<? extends Call> abstractActor = actor;
        if (abstractActor instanceof AcceptorActor) {
            this.atp = ActorHouse$.MODULE$.SERVER_CHANNELS_ACTOR();
            return;
        }
        if (abstractActor instanceof ChannelsActor) {
            this.atp = ActorHouse$.MODULE$.CHANNELS_ACTOR();
            return;
        }
        if (abstractActor instanceof StateActor) {
            this.atp = ActorHouse$.MODULE$.STATE_ACTOR();
            return;
        }
        throw new IllegalStateException("");
    }

    public AbstractActor<? extends Call> actor() {
        return this.dweller;
    }

    public ActorSystem system() {
        return this.manager().thread().system();
    }

    public int actorType() {
        return this.atp;
    }

    public boolean isEmpty() {
        return this.askMailbox.isEmpty() && this.noticeMailbox.isEmpty() && this.replyMailbox.isEmpty() && this.eventMailbox.isEmpty();
    }

    public boolean nonEmpty() {
        return this.askMailbox.nonEmpty() || this.noticeMailbox.nonEmpty() || this.replyMailbox.nonEmpty() || this.eventMailbox.nonEmpty();
    }

    public void mount() {
        if (this.status().compareAndSet(ActorHouse$.cc$otavia$core$system$ActorHouse$$$CREATED, ActorHouse$.cc$otavia$core$system$ActorHouse$$$MOUNTING)) {
            this.manager().mount(this);
            return;
        }
    }

    public void doMount() {
        if (this.status().compareAndSet(ActorHouse$.cc$otavia$core$system$ActorHouse$$$MOUNTING, ActorHouse$.cc$otavia$core$system$ActorHouse$$$WAITING)) {
            this.dweller.mount();
            if (this.nonEmpty()) {
                this.waiting2ready();
                return;
            }
            return;
        }
    }

    public void putNotice(Notice notice) {
        if (this.system().isBusy() && !ActorThread$.MODULE$.currentThreadIsActorThread()) {
            System.gc();
            Thread.sleep(Int$.MODULE$.int2long(ActorSystem$.MODULE$.MEMORY_OVER_SLEEP()));
        }
        this.put(notice, this.noticeMailbox);
    }

    public void putAsk(Ask<?> ask) {
        this.put(ask, this.askMailbox);
    }

    public void putReply(Reply reply) {
        this.put(reply, this.replyMailbox);
    }

    public void putException(ExceptionMessage cause) {
        this.put(cause, this.exceptionMailbox);
    }

    public void putEvent(Event event) {
        this.put(event, this.eventMailbox);
    }

    private final void put(Nextable msg, MailBox mailBox) {
        mailBox.put(msg);
        if (this.status().get() == ActorHouse$.cc$otavia$core$system$ActorHouse$$$WAITING) {
            this.waiting2ready();
            return;
        }
    }

    private void waiting2ready() {
        if (this.status().compareAndSet(ActorHouse$.cc$otavia$core$system$ActorHouse$$$WAITING, ActorHouse$.cc$otavia$core$system$ActorHouse$$$READY)) {
            this.manager().ready(this);
            return;
        }
    }

    public void schedule() {
        if (this.status().compareAndSet(ActorHouse$.cc$otavia$core$system$ActorHouse$$$READY, ActorHouse$.cc$otavia$core$system$ActorHouse$$$SCHEDULED)) {
            return;
        }
    }

    @Override
    public void run() {
        if (this.status().compareAndSet(ActorHouse$.cc$otavia$core$system$ActorHouse$$$SCHEDULED, ActorHouse$.cc$otavia$core$system$ActorHouse$$$RUNNING)) {
            if (this.replyMailbox.size() > this.dweller.niceReply() * 2) {
                this.dispatchReplies(this.dweller.niceReply() * 2);
            } else {
                if (this.replyMailbox.nonEmpty()) {
                    this.dispatchReplies(this.dweller.niceReply());
                }
                if (this.eventMailbox.nonEmpty()) {
                    this.dispatchEvents(this.dweller.niceEvent());
                }
                if (this.askMailbox.nonEmpty()) {
                    if (this.dweller.batchable()) {
                        Nextable cursor = this.askMailbox.getChain(this.dweller.maxBatchSize());
                        ArrayBuffer buf = ActorThread$.MODULE$.threadBuffer();
                        while (cursor != null) {
                            Ask ask = (Ask)cursor;
                            cursor = ask.next();
                            ask.dechain();
                            if (BoxesRunTime.unboxToBoolean((Object)this.dweller.batchAskFilter().apply((Object)ask))) {
                                buf.addOne((Object)ask);
                                continue;
                            }
                            if (buf.nonEmpty()) {
                                this.handleBatchAsk(buf);
                            }
                            this.dweller.receiveAsk(ask);
                            this.runLaterTasks();
                        }
                        if (buf.nonEmpty()) {
                            this.handleBatchAsk(buf);
                        }
                    } else {
                        Nextable cursor = this.askMailbox.getChain(this.dweller.niceAsk());
                        while (cursor != null) {
                            Nextable msg = cursor;
                            cursor = msg.next();
                            msg.dechain();
                            this.dweller.receiveAsk((Ask)msg);
                            this.runLaterTasks();
                        }
                    }
                }
                if (this.noticeMailbox.nonEmpty()) {
                    if (this.dweller.batchable()) {
                        Nextable cursor = this.noticeMailbox.getChain(this.dweller.maxBatchSize());
                        ArrayBuffer buf = ActorThread$.MODULE$.threadBuffer();
                        while (cursor != null) {
                            Notice notice = (Notice)cursor;
                            cursor = notice.next();
                            notice.dechain();
                            if (BoxesRunTime.unboxToBoolean((Object)this.dweller.batchNoticeFilter().apply((Object)notice))) {
                                buf.addOne((Object)notice);
                                continue;
                            }
                            if (buf.nonEmpty()) {
                                this.handleBatchNotice(buf);
                            }
                            this.dweller.receiveNotice(notice);
                            this.runLaterTasks();
                        }
                        if (buf.nonEmpty()) {
                            this.handleBatchNotice(buf);
                        }
                    } else {
                        Nextable cursor = this.noticeMailbox.getChain(this.dweller.niceNotice());
                        while (cursor != null) {
                            Nextable msg = cursor;
                            cursor = msg.next();
                            msg.dechain();
                            this.dweller.receiveNotice((Notice)msg);
                            this.runLaterTasks();
                        }
                    }
                }
            }
            if (this.nonEmpty()) {
                if (this.status().compareAndSet(ActorHouse$.cc$otavia$core$system$ActorHouse$$$RUNNING, ActorHouse$.cc$otavia$core$system$ActorHouse$$$READY)) {
                    this.manager().ready(this);
                    return;
                }
                return;
            }
            this.status().compareAndSet(ActorHouse$.cc$otavia$core$system$ActorHouse$$$RUNNING, ActorHouse$.cc$otavia$core$system$ActorHouse$$$WAITING);
            return;
        }
    }

    private void dispatchReplies(int size) {
        Nextable cursor = this.replyMailbox.getChain(size);
        while (cursor != null) {
            Nextable msg = cursor;
            cursor = msg.next();
            msg.dechain();
            this.dweller.receiveReply((Reply)msg);
            this.runLaterTasks();
        }
    }

    private void dispatchEvents(int size) {
        Nextable cursor = this.eventMailbox.getChain(size);
        while (cursor != null) {
            Event msg = (Event)cursor;
            cursor = msg.next();
            msg.dechain();
            this.dweller.receiveEvent(msg);
            this.runLaterTasks();
        }
    }

    private void handleBatchNotice(ArrayBuffer<Notice> buf) {
        Seq notices = buf.toSeq();
        buf.clear();
        this.dweller.receiveBatchNotice((Seq<Notice>)notices);
        this.runLaterTasks();
    }

    private void handleBatchAsk(ArrayBuffer<Ask<?>> buf) {
        Seq asks = buf.toSeq();
        buf.clear();
        this.dweller.receiveBatchAsk(asks);
        this.runLaterTasks();
    }

    private void runLaterTasks() {
        if (this.actorType() == ActorHouse$.MODULE$.CHANNELS_ACTOR()) {
            while (this.manager().laterTasks().nonEmpty()) {
                ArrayDeque<Runnable> arrayDeque = this.manager().laterTasks();
                Runnable task = (Runnable)arrayDeque.removeHead(arrayDeque.removeHead$default$1());
                task.run();
            }
            return;
        }
    }

    public <M extends Call> ActorAddress<M> createActorAddress() {
        ActorAddress address = new ActorAddress(this);
        if (this.actor() instanceof AutoCleanable) {
            this.manager().thread().registerAddressRef(address);
        }
        return address;
    }

    public ActorAddress<?> createUntypedAddress() {
        ActorAddress address = new ActorAddress(this);
        if (this.actor() instanceof AutoCleanable) {
            this.manager().thread().registerAddressRef(address);
        }
        return address;
    }

    public String toString() {
        return new StringBuilder(19).append("events=").append(this.eventMailbox.size()).append(", notices=").append(this.noticeMailbox.size()).append(", ").append(new StringBuilder(15).append("asks=").append(this.askMailbox.size()).append(", replies=").append(this.replyMailbox.size()).toString()).toString();
    }
}

