/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.common.Report$;
import cc.otavia.common.SystemPropertyUtil$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.ActorSystemImpl;
import cc.otavia.core.system.ActorThreadFactory;
import java.io.Serializable;
import java.net.InetAddress;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ActorSystem$
implements Serializable {
    private static ActorSystem system;
    private static final String DEFAULT_SYSTEM_NAME;
    private static final int DEFAULT_MAX_TASKS_PER_RUN;
    private static final int DEFAULT_POOL_HOLDER_MAX_SIZE;
    private static final int DEFAULT_ACTOR_THREAD_POOL_SIZE;
    private static final int ACTOR_THREAD_POOL_SIZE;
    private static final boolean MEMORY_MONITOR;
    private static final int MEMORY_MONITOR_DURATION;
    private static final int MEMORY_OVER_SLEEP;
    private static final boolean SYSTEM_MONITOR;
    private static final int SYSTEM_MONITOR_DURATION;
    private static final boolean PRINT_BANNER;
    private static final int PAGE_SIZE;
    public static final ActorSystem$ MODULE$;

    private ActorSystem$() {
    }

    static {
        int n;
        MODULE$ = new ActorSystem$();
        DEFAULT_SYSTEM_NAME = new StringBuilder(12).append("ActorSystem:").append(InetAddress.getLocalHost().getHostName()).toString();
        DEFAULT_MAX_TASKS_PER_RUN = Math.max(1, SystemPropertyUtil$.MODULE$.getInt("cc.otavia.reactor.maxTaskPerRun", 16));
        DEFAULT_POOL_HOLDER_MAX_SIZE = SystemPropertyUtil$.MODULE$.getInt("cc.otavia.pool.holder.maxSize", 256);
        DEFAULT_ACTOR_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
        ACTOR_THREAD_POOL_SIZE = SystemPropertyUtil$.MODULE$.getInt("cc.otavia.actor.thread.pool.size", DEFAULT_ACTOR_THREAD_POOL_SIZE);
        boolean DEFAULT_MEMORY_MONITOR = true;
        MEMORY_MONITOR = SystemPropertyUtil$.MODULE$.getBoolean("cc.otavia.system.memory.monitor", DEFAULT_MEMORY_MONITOR);
        int DEFAULT_MEMORY_MONITOR_DURATION = 20;
        MEMORY_MONITOR_DURATION = SystemPropertyUtil$.MODULE$.getInt("cc.otavia.system.memory.monitor.duration", DEFAULT_MEMORY_MONITOR_DURATION);
        int DEFAULT_MEMORY_OVER_SLEEP = 40;
        MEMORY_OVER_SLEEP = SystemPropertyUtil$.MODULE$.getInt("cc.otavia.system.memory.over.sleep", DEFAULT_MEMORY_OVER_SLEEP);
        boolean DEFAULT_SYSTEM_MONITOR = false;
        SYSTEM_MONITOR = SystemPropertyUtil$.MODULE$.getBoolean("cc.otavia.system.monitor", DEFAULT_SYSTEM_MONITOR);
        int DEFAULT_SYSTEM_MONITOR_DURATION = 10;
        SYSTEM_MONITOR_DURATION = SystemPropertyUtil$.MODULE$.getInt("cc.otavia.system.monitor.duration", DEFAULT_SYSTEM_MONITOR_DURATION);
        boolean DEFAULT_PRINT_BANNER = true;
        PRINT_BANNER = SystemPropertyUtil$.MODULE$.getBoolean("cc.otavia.system.banner", DEFAULT_PRINT_BANNER);
        int DEFAULT_PAGE_SIZE = 4;
        int[] ENABLE_PAGE_SIZES = new int[]{1, 2, 4, 8, 16};
        int K = 1024;
        int size = SystemPropertyUtil$.MODULE$.getInt("cc.otavia.buffer.page.size", DEFAULT_PAGE_SIZE);
        Object object = Predef$.MODULE$.intArrayOps(ENABLE_PAGE_SIZES);
        if (ArrayOps$.MODULE$.contains$extension(object, (Object)BoxesRunTime.boxToInteger((int)size))) {
            n = size * K;
        } else {
            Report$.MODULE$.report(new StringBuilder(74).append("cc.otavia.buffer.page.size is set to ").append(size).append(", but only support ").append(Predef$.MODULE$.wrapIntArray(ENABLE_PAGE_SIZES).mkString("[", ", ", "]")).append(", set to default ").append(DEFAULT_PAGE_SIZE * K).append(" ").toString(), "Buffer");
            n = DEFAULT_PAGE_SIZE * K;
        }
        PAGE_SIZE = n;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ActorSystem$.class);
    }

    public int DEFAULT_MAX_TASKS_PER_RUN() {
        return DEFAULT_MAX_TASKS_PER_RUN;
    }

    public int DEFAULT_POOL_HOLDER_MAX_SIZE() {
        return DEFAULT_POOL_HOLDER_MAX_SIZE;
    }

    public int ACTOR_THREAD_POOL_SIZE() {
        return ACTOR_THREAD_POOL_SIZE;
    }

    public boolean MEMORY_MONITOR() {
        return MEMORY_MONITOR;
    }

    public int MEMORY_MONITOR_DURATION() {
        return MEMORY_MONITOR_DURATION;
    }

    public int MEMORY_OVER_SLEEP() {
        return MEMORY_OVER_SLEEP;
    }

    public boolean SYSTEM_MONITOR() {
        return SYSTEM_MONITOR;
    }

    public int SYSTEM_MONITOR_DURATION() {
        return SYSTEM_MONITOR_DURATION;
    }

    public boolean PRINT_BANNER() {
        return PRINT_BANNER;
    }

    public int PAGE_SIZE() {
        return PAGE_SIZE;
    }

    public ActorSystem apply() {
        ActorSystem actorSystem;
        ActorSystem$ actorSystem$ = this;
        synchronized (actorSystem$) {
            if (system != null) {
                throw new IllegalStateException("Can't create multiple ActorSystem instances within the same JVM instance, use method global to get the only instance that has been created.");
            }
            system = new ActorSystemImpl(DEFAULT_SYSTEM_NAME, new ActorThreadFactory.DefaultActorThreadFactory());
            actorSystem = system;
        }
        return actorSystem;
    }

    public ActorSystem apply(String name) {
        ActorSystem actorSystem;
        ActorSystem$ actorSystem$ = this;
        synchronized (actorSystem$) {
            if (system != null) {
                throw new IllegalStateException("Can't create multiple ActorSystem instances within the same JVM instance, use method global to get the only instance that has been created.");
            }
            system = new ActorSystemImpl(name, new ActorThreadFactory.DefaultActorThreadFactory());
            actorSystem = system;
        }
        return actorSystem;
    }

    public ActorSystem global() {
        ActorSystem actorSystem;
        ActorSystem$ actorSystem$ = this;
        synchronized (actorSystem$) {
            actorSystem = system == null ? this.apply() : system;
        }
        return actorSystem;
    }
}

