/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.core.actor.AbstractActor;
import cc.otavia.core.actor.Actor;
import cc.otavia.core.actor.ActorContext;
import cc.otavia.core.actor.ActorContext$;
import cc.otavia.core.actor.ActorFactory;
import cc.otavia.core.actor.ChannelsActor;
import cc.otavia.core.actor.MainActor;
import cc.otavia.core.address.ActorAddress;
import cc.otavia.core.address.Address;
import cc.otavia.core.address.RobinAddress;
import cc.otavia.core.cache.ThreadLocal;
import cc.otavia.core.channel.ChannelFactory;
import cc.otavia.core.ioc.BeanDefinition;
import cc.otavia.core.ioc.BeanManager;
import cc.otavia.core.ioc.Module;
import cc.otavia.core.message.Call;
import cc.otavia.core.reactor.Reactor;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.system.ActorHouse;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.ActorSystem$;
import cc.otavia.core.system.ActorThread;
import cc.otavia.core.system.ActorThreadFactory;
import cc.otavia.core.system.ActorThreadPool;
import cc.otavia.core.system.DefaultActorThreadPool;
import cc.otavia.core.system.SystemInfo$;
import cc.otavia.core.system.monitor.ActorThreadMonitor;
import cc.otavia.core.system.monitor.ReactorMonitor$;
import cc.otavia.core.system.monitor.SystemMonitor;
import cc.otavia.core.system.monitor.SystemMonitor$;
import cc.otavia.core.system.monitor.SystemMonitorTask;
import cc.otavia.core.system.monitor.ThreadMonitor;
import cc.otavia.core.system.monitor.ThreadMonitor$;
import cc.otavia.core.timer.Timeout;
import cc.otavia.core.timer.Timer;
import cc.otavia.core.timer.TimerImpl;
import cc.otavia.core.transport.TransportFactory;
import cc.otavia.core.transport.TransportFactory$;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;

public final class ActorSystemImpl
implements ActorSystem {
    private final String name;
    private final ActorThreadFactory actorThreadFactory;
    private volatile boolean initialize;
    private final ConcurrentLinkedQueue<Module> earlyModules;
    private final Logger logger;
    private final TimerImpl timerImpl;
    private final ActorThreadPool actorThreadPool;
    private final AtomicLong generator;
    private final BeanManager beanManager;
    private Address<MainActor.Args> mainActor;
    private final ChannelFactory chFactory;
    private final MemoryMXBean memoryMXBean;
    private volatile boolean busy;
    private final SystemMonitorTask systemMonitorTask;
    private final Reactor react;
    private final AtomicLong gcTime;
    private final Set<ThreadLocal<?>> threadLocals;

    public ActorSystemImpl(String name, ActorThreadFactory actorThreadFactory) {
        this.name = name;
        this.actorThreadFactory = actorThreadFactory;
        actorThreadFactory.setSystem(this);
        this.initialize = false;
        this.earlyModules = new ConcurrentLinkedQueue();
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), (ActorSystem)this);
        this.timerImpl = new TimerImpl(this);
        this.actorThreadPool = new DefaultActorThreadPool(this, actorThreadFactory, ActorSystem$.MODULE$.ACTOR_THREAD_POOL_SIZE());
        this.generator = new AtomicLong(1L);
        this.beanManager = new BeanManager(this);
        AtomicLong totals = new AtomicLong(0L);
        TransportFactory transFactory = TransportFactory$.MODULE$.getTransportFactory(this);
        this.chFactory = new ChannelFactory(transFactory);
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.busy = false;
        Timeout memoryMonitor = null;
        if (ActorSystem$.MODULE$.MEMORY_MONITOR()) {
            int duration = ActorSystem$.MODULE$.MEMORY_MONITOR_DURATION() * 100;
            memoryMonitor = this.timer().internalTimer().newTimeout(_$3 -> this.calculateBusy(), Int$.MODULE$.int2long(duration), scala.concurrent.duration.package$.MODULE$.MILLISECONDS(), Int$.MODULE$.int2long(duration), scala.concurrent.duration.package$.MODULE$.MILLISECONDS());
        }
        this.systemMonitorTask = new SystemMonitorTask(this);
        Timeout systemMonitor = null;
        if (ActorSystem$.MODULE$.SYSTEM_MONITOR()) {
            int duration = ActorSystem$.MODULE$.SYSTEM_MONITOR_DURATION() * 100;
            systemMonitor = this.timer().internalTimer().newTimeout(_$5 -> this.doMonitor(), Int$.MODULE$.int2long(duration), scala.concurrent.duration.package$.MODULE$.MILLISECONDS(), Int$.MODULE$.int2long(duration), scala.concurrent.duration.package$.MODULE$.MILLISECONDS());
        }
        if (ActorSystem$.MODULE$.PRINT_BANNER()) {
            Predef$.MODULE$.println((Object)new StringBuilder(9).append("\u001b[33m").append(SystemInfo$.MODULE$.logo()).append("\u001b[0m").toString());
            Predef$.MODULE$.println((Object)SystemInfo$.MODULE$.info());
            Predef$.MODULE$.println((Object)"\n");
        }
        this.react = transFactory.openReactor(this);
        this.gcTime = new AtomicLong(System.currentTimeMillis());
        this.threadLocals = HashSet$.MODULE$.empty();
        this.initialize = true;
        this.loadEarlyModules();
    }

    public String name() {
        return this.name;
    }

    public ActorThreadFactory actorThreadFactory() {
        return this.actorThreadFactory;
    }

    private void loadEarlyModules() {
        while (!this.earlyModules.isEmpty()) {
            Module module = this.earlyModules.poll();
            this.loadModule(module);
        }
    }

    private void doMonitor() {
        this.systemMonitorTask.run();
    }

    @Override
    public boolean initialized() {
        return this.initialize;
    }

    @Override
    public ActorThreadPool pool() {
        return this.actorThreadPool;
    }

    @Override
    public Reactor reactor() {
        return this.react;
    }

    @Override
    public Timer timer() {
        return this.timerImpl;
    }

    @Override
    public void shutdown() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public int defaultMaxFetchPerRunning() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public int defaultMaxBatchSize() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public <A extends Actor<? extends Call>> Address<Call> buildActor(ActorFactory<A> factory, int num, boolean global, Option<String> qualifier, boolean primary) {
        ActorFactory<A> actorFactory = factory;
        Tuple2<Address<?>, Class<?>> tuple2 = this.createActor(actorFactory, num);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Address address = (Address)tuple2._1();
        Class clz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)address, (Object)clz);
        Address address2 = (Address)tuple22._1();
        Class clz2 = (Class)tuple22._2();
        if (global) {
            this.beanManager.register(clz2, address2, qualifier, primary);
        }
        this.mountActor(address2);
        return address2;
    }

    @Override
    public int buildActor$default$2() {
        return 1;
    }

    @Override
    public boolean buildActor$default$3() {
        return false;
    }

    @Override
    public <A extends Actor<? extends Call>> Option<String> buildActor$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean buildActor$default$5() {
        return false;
    }

    private void mountActor(Address<?> address) {
        Address<?> address2 = address;
        if (address2 instanceof ActorAddress) {
            ActorAddress addr2 = (ActorAddress)address2;
            addr2.house().mount();
            return;
        }
        if (address2 instanceof RobinAddress) {
            RobinAddress robinAddress = (RobinAddress)address2;
            Object object = Predef$.MODULE$.refArrayOps((Object[])robinAddress.underlying());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)addr -> ((ActorAddress)addr).house().mount());
            return;
        }
        throw new MatchError(address2);
    }

    private ActorAddress<?> setActorContext(AbstractActor<?> actor, ActorThread thread) {
        ActorHouse house = thread.createActorHouse();
        house.setActor(actor);
        ActorAddress<?> address = house.createUntypedAddress();
        ActorContext context = ActorContext$.MODULE$.apply(this, address, this.generator.getAndIncrement());
        actor.setCtx(context);
        return address;
    }

    private Tuple2<Address<?>, Class<?>> createActor(ActorFactory<?> factory, int num) {
        if (num == 1) {
            AbstractActor actor = (AbstractActor)factory.create();
            boolean isIO = actor instanceof ChannelsActor;
            ActorThread thread = this.pool().next(isIO);
            ActorAddress<?> address = this.setActorContext(actor, thread);
            this.logger.debug(new StringBuilder(14).append("Created actor ").append(actor).toString());
            return Tuple2$.MODULE$.apply(address, actor.getClass());
        }
        if (num > 1) {
            int[] range = (int[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), num).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
            Object object = Predef$.MODULE$.intArrayOps(range);
            Object[] actors = (AbstractActor[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$6 -> ActorSystemImpl.$anonfun$1(factory, BoxesRunTime.unboxToInt((Object)_$6)), ClassTag$.MODULE$.apply(AbstractActor.class));
            Object object2 = Predef$.MODULE$.refArrayOps(actors);
            boolean isIO = (AbstractActor)ArrayOps$.MODULE$.head$extension(object2) instanceof ChannelsActor;
            Seq<ActorThread> threads = this.pool().nexts(num, isIO);
            Object object3 = Predef$.MODULE$.intArrayOps(range);
            ActorAddress[] address = (ActorAddress[])ArrayOps$.MODULE$.map$extension(object3, arg_0 -> this.$anonfun$adapted$2((AbstractActor[])actors, threads, arg_0), ClassTag$.MODULE$.apply(ActorAddress.class));
            this.logger.debug(new StringBuilder(15).append("Created actors ").append(Predef$.MODULE$.wrapRefArray(actors).mkString("Array(", ", ", ")")).toString());
            Object object4 = Predef$.MODULE$.refArrayOps(actors);
            return Tuple2$.MODULE$.apply(new RobinAddress(address), ((AbstractActor)ArrayOps$.MODULE$.head$extension(object4)).getClass());
        }
        throw new IllegalArgumentException("num must large than 0");
    }

    @Override
    public void registerGlobalActor(BeanDefinition definition) {
        Tuple2<Address<?>, Class<?>> tuple2 = this.createActor(definition.factory(), definition.num());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Address address = (Address)tuple2._1();
        Class clz = (Class)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)address, (Object)clz);
        Address address2 = (Address)tuple22._1();
        Class clz2 = (Class)tuple22._2();
        this.beanManager.register(clz2, address2, definition.qualifier(), definition.primary());
        this.mountActor(address2);
    }

    @Override
    public void loadModule(Module module) {
        block3: {
            try {
                if (!this.initialize) {
                    this.earlyModules.add(module);
                    break block3;
                }
                this.logger.debug(new StringBuilder(15).append("Loading module ").append(module).toString());
                ArrayBuffer unmount = new ArrayBuffer(module.definitions().length());
                module.definitions().foreach((Function1)(JProcedure1 & Serializable)definition -> {
                    Tuple2<Address<?>, Class<?>> tuple2 = this.createActor(definition.factory(), definition.num());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Address address = (Address)tuple2._1();
                    Class clz = (Class)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)address, (Object)clz);
                    Address address2 = (Address)tuple22._1();
                    Class clz2 = (Class)tuple22._2();
                    unmount.addOne((Object)address2);
                    this.beanManager.register(clz2, address2, definition.qualifier(), definition.primary());
                });
                unmount.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Address address = x$1;
                    if (address instanceof ActorAddress) {
                        ActorAddress address2 = (ActorAddress)address;
                        address2.house().mount();
                        return;
                    }
                    if (address instanceof RobinAddress) {
                        RobinAddress robinAddress = (RobinAddress)address;
                        Object object = Predef$.MODULE$.refArrayOps((Object[])robinAddress.underlying());
                        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)addr -> ((ActorAddress)addr).house().mount());
                        return;
                    }
                    throw new MatchError((Object)address);
                });
                module.onLoaded(this);
            }
            catch (Throwable t) {
                this.logger.error(new StringBuilder(30).append("Load module ").append(module).append(" occur error with ").toString(), t);
            }
        }
    }

    @Override
    public <M extends MainActor> void runMain(ActorFactory<M> factory, Seq<Module> modules) {
        modules.foreach((Function1)(JProcedure1 & Serializable)m -> this.loadModule((Module)m));
        Address<Call> address = this.buildActor(factory, this.buildActor$default$2(), this.buildActor$default$3(), this.buildActor$default$4(), this.buildActor$default$5());
        this.mainActor = address;
    }

    @Override
    public <M extends MainActor> Seq<Module> runMain$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public <M extends Call> Address<M> getAddress(Class<? extends Actor<?>> clz, Option<String> qualifier, Option<String> remote) {
        Address<?> address;
        Option<String> option = qualifier;
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            address = this.beanManager.getBean(value, clz);
        } else if (None$.MODULE$.equals(option)) {
            address = this.beanManager.getBean(clz);
        } else {
            throw new MatchError(option);
        }
        Address<?> address2 = address;
        return address2;
    }

    public String toString() {
        SystemMonitor stats = this.monitor();
        Object object = Predef$.MODULE$.refArrayOps((Object[])stats.threadMonitor().actorThreadMonitors());
        return new StringBuilder(30).append("name = ").append(stats.name()).append(", threads = ").append(stats.threads()).append(", beans = ").append(stats.beans()).append("\n").append(new StringBuilder(1).append(stats.threadMonitor().timerMonitor()).append("\n").toString()).append(String.valueOf(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$7 -> _$7.toString(), ClassTag$.MODULE$.apply(String.class))).mkString("[", ",\n", "]"))).toString();
    }

    @Override
    public SystemMonitor monitor() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.pool().workers());
        ThreadMonitor threadMonitor = ThreadMonitor$.MODULE$.apply(this.timer().monitor(), ReactorMonitor$.MODULE$.apply(), (ActorThreadMonitor[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$8 -> _$8.monitor(), ClassTag$.MODULE$.apply(ActorThreadMonitor.class)));
        return SystemMonitor$.MODULE$.apply(this.name(), this.pool().size(), this.beanManager.count(), threadMonitor);
    }

    @Override
    public ChannelFactory channelFactory() {
        return this.chFactory;
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    private void calculateBusy() {
        MemoryUsage usage = this.memoryMXBean.getHeapMemoryUsage();
        if ((double)((float)usage.getUsed() / (float)usage.getMax()) > 0.9 && usage.getMax() - usage.getUsed() < 0x6400000L) {
            this.busy = true;
            return;
        }
        this.busy = false;
    }

    @Override
    public void registerLongLifeThreadLocal(ThreadLocal<?> threadLocal) {
        this.threadLocals.addOne(threadLocal);
    }

    @Override
    public void gc() {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = this.gcTime.get()) > 1000L && this.gcTime.compareAndSet(last, now)) {
            System.gc();
            this.logger.trace("GC");
            return;
        }
    }

    private static final /* synthetic */ AbstractActor $anonfun$1(ActorFactory factory$1, int _$6) {
        return (AbstractActor)factory$1.create();
    }

    private final /* synthetic */ ActorAddress $anonfun$2(AbstractActor[] actors$1, Seq threads$1, int index) {
        AbstractActor actor = actors$1[index];
        ActorThread thread = (ActorThread)threads$1.apply(index);
        return this.setActorContext(actor, thread);
    }
}

