/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.buffer.pool.AbstractPooledPageAllocator;
import cc.otavia.buffer.pool.DirectPooledPageAllocator;
import cc.otavia.buffer.pool.HeapPooledPageAllocator;
import cc.otavia.core.actor.Actor;
import cc.otavia.core.address.ActorAddress;
import cc.otavia.core.address.ActorThreadAddress;
import cc.otavia.core.message.Event;
import cc.otavia.core.message.ResourceTimeoutEvent;
import cc.otavia.core.system.ActorHouse;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.ActorSystem$;
import cc.otavia.core.system.ActorThread$;
import cc.otavia.core.system.ActorThreadPool;
import cc.otavia.core.system.AddressPhantomReference;
import cc.otavia.core.system.HouseManager;
import cc.otavia.core.system.monitor.ActorThreadMonitor;
import cc.otavia.core.system.monitor.ActorThreadMonitor$;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;

public final class ActorThread
extends Thread {
    private final ActorSystem system;
    private final int id;
    private final ArrayDeque<Runnable> channelLaterTasks;
    private final HouseManager manager;
    private final ConcurrentLinkedQueue<Event> eventQueue;
    private final ActorThreadAddress address;
    private final ReferenceQueue<ActorAddress<?>> referenceQueue;
    private final HashSet<Reference<?>> refSet;
    private volatile int status;
    private final Object lock;
    private final DirectPooledPageAllocator direct;
    private final HeapPooledPageAllocator heap;
    private final ArrayBuffer mutableBuffer;
    private final HashSet mutableSet;

    public static ActorThread currentThread() {
        return ActorThread$.MODULE$.currentThread();
    }

    public static int currentThreadIndex() {
        return ActorThread$.MODULE$.currentThreadIndex();
    }

    public static boolean currentThreadIsActorThread() {
        return ActorThread$.MODULE$.currentThreadIsActorThread();
    }

    public static <T> ArrayBuffer<T> threadBuffer() {
        return ActorThread$.MODULE$.threadBuffer();
    }

    public static <T> HashSet<T> threadSet() {
        return ActorThread$.MODULE$.threadSet();
    }

    public ActorThread(ActorSystem system) {
        this.system = system;
        this.id = system.pool().nextThreadId();
        this.channelLaterTasks = ArrayDeque$.MODULE$.empty();
        this.manager = new HouseManager(this);
        this.eventQueue = new ConcurrentLinkedQueue();
        this.address = new ActorThreadAddress(this);
        this.referenceQueue = new ReferenceQueue();
        this.refSet = HashSet$.MODULE$.empty();
        this.status = ActorThread$.cc$otavia$core$system$ActorThread$$$ST_STARTING;
        this.lock = new Object();
        this.direct = new DirectPooledPageAllocator(ActorSystem$.MODULE$.PAGE_SIZE());
        this.heap = new HeapPooledPageAllocator(ActorSystem$.MODULE$.PAGE_SIZE());
        this.mutableBuffer = ArrayBuffer$.MODULE$.empty();
        this.mutableSet = HashSet$.MODULE$.empty();
        this.setName(new StringBuilder(20).append("otavia-actor-worker-").append(this.index()).toString());
    }

    public ActorSystem system() {
        return this.system;
    }

    public ArrayBuffer<Object> cc$otavia$core$system$ActorThread$$mutableBuffer() {
        return this.mutableBuffer;
    }

    public HashSet<Object> cc$otavia$core$system$ActorThread$$mutableSet() {
        return this.mutableSet;
    }

    public void prepared() {
        if (this.direct.size() == 0) {
            this.direct.allocate().close();
        }
        if (this.heap.size() == 0) {
            this.heap.allocate().close();
            return;
        }
    }

    public AbstractPooledPageAllocator directAllocator() {
        return this.direct;
    }

    public AbstractPooledPageAllocator heapAllocator() {
        return this.heap;
    }

    public ActorThreadPool parent() {
        return this.system().pool();
    }

    public int index() {
        return this.id;
    }

    public HouseManager houseManager() {
        return this.manager;
    }

    public Actor<?> currentRunningActor() {
        return this.manager.currentRunningActor();
    }

    public ArrayDeque<Runnable> laterTasks() {
        return this.channelLaterTasks;
    }

    public void cleanChannelTask() {
        if (this.channelLaterTasks.nonEmpty()) {
            this.channelLaterTasks.clear();
            return;
        }
    }

    public ActorThreadAddress actorThreadAddress() {
        return this.address;
    }

    public ActorHouse createActorHouse() {
        ActorHouse house = new ActorHouse(this.manager);
        return house;
    }

    public void registerAddressRef(ActorAddress<?> address) {
        AddressPhantomReference ref = new AddressPhantomReference(address, this.referenceQueue);
        this.refSet.add((Object)ref);
    }

    private int stopActors() {
        int count = 0;
        boolean bl = true;
        while (count < ActorThread$.cc$otavia$core$system$ActorThread$$$GC_PEER_ROUND && bl) {
            Reference<ActorAddress<?>> reference = this.referenceQueue.poll();
            if (reference != null) {
                reference.clear();
                this.refSet.remove(reference);
                ++count;
                continue;
            }
            bl = false;
        }
        return count;
    }

    public void notifyThread() {
        if (this.status == ActorThread$.cc$otavia$core$system$ActorThread$$$ST_WAITING) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            return;
        }
    }

    public void putEvent(Event event) {
        this.eventQueue.offer(event);
        if (this.status == ActorThread$.cc$otavia$core$system$ActorThread$$$ST_WAITING) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            return;
        }
    }

    public void putEvents(Seq<Event> events) {
        events.foreach((Function1 & Serializable)event -> this.eventQueue.offer((Event)event));
        if (this.status == ActorThread$.cc$otavia$core$system$ActorThread$$$ST_WAITING) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            return;
        }
    }

    @Override
    public void run() {
        this.status = ActorThread$.cc$otavia$core$system$ActorThread$$$ST_RUNNING;
        long spinStart = System.currentTimeMillis();
        long emptyTimes = 0L;
        boolean gc = false;
        while (true) {
            boolean success = false;
            int stops = this.refSet.isEmpty() ? 0 : this.stopActors();
            boolean runHouse = this.manager.run();
            boolean runEvent = this.runThreadEvent();
            if (stops > 0 || runHouse || runEvent) {
                success = true;
            }
            if (success) {
                emptyTimes = 0L;
                gc = false;
                continue;
            }
            if (++emptyTimes == 1L) {
                spinStart = System.currentTimeMillis();
                continue;
            }
            if (emptyTimes < 20L) {
                Thread.yield();
                continue;
            }
            if (emptyTimes < 25L) {
                if (!this.manager.trySteal()) continue;
                --emptyTimes;
                continue;
            }
            if (emptyTimes < 50L) {
                this.suspendThread(5L);
                continue;
            }
            this.suspendThread(this.suspendThread$default$1());
            if (emptyTimes % 100L == 0L && this.manager.trySteal()) {
                emptyTimes = 20L;
            }
            if (gc || System.currentTimeMillis() - spinStart <= 2000L) continue;
            this.system().gc();
            gc = true;
        }
    }

    private void suspendThread(long millis) {
        Object object = this.lock;
        synchronized (object) {
            this.status = ActorThread$.cc$otavia$core$system$ActorThread$$$ST_WAITING;
            this.lock.wait(millis);
            this.status = ActorThread$.cc$otavia$core$system$ActorThread$$$ST_RUNNING;
        }
    }

    private long suspendThread$default$1() {
        return 50L;
    }

    private boolean runThreadEvent() {
        if (!this.eventQueue.isEmpty()) {
            ResourceTimeoutEvent event = (ResourceTimeoutEvent)this.eventQueue.poll();
            event.cache().parent().handleTimeout(event.registerId(), event.cache());
            return true;
        }
        return false;
    }

    public ActorThreadMonitor monitor() {
        return ActorThreadMonitor$.MODULE$.apply(this.eventQueue.size(), this.manager.monitor());
    }
}

